/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.data;

import de.gematik.idp.crypto.model.PkiIdentity;
import de.gematik.idp.data.IdpKeyDescriptor;
import java.util.Optional;
import lombok.Generated;

public class FederationPubKey {
    private final PkiIdentity identity;
    private final String issuer;
    private final String type;
    private Optional<Boolean> addX5c;
    private Optional<String> keyId;
    private Optional<String> use;
    private String url;

    public IdpKeyDescriptor buildJwk() {
        IdpKeyDescriptor keyDesc = IdpKeyDescriptor.constructFromX509Certificate(this.identity.getCertificate(), this.keyId, this.addX5c.orElse(false));
        keyDesc.setPublicKeyUse(this.use.orElse(null));
        return keyDesc;
    }

    @Generated
    public FederationPubKey(PkiIdentity identity, String issuer, String type, Optional<Boolean> addX5c, Optional<String> keyId, Optional<String> use, String url) {
        this.identity = identity;
        this.issuer = issuer;
        this.type = type;
        this.addX5c = addX5c;
        this.keyId = keyId;
        this.use = use;
        this.url = url;
    }

    @Generated
    public FederationPubKey(PkiIdentity identity, String issuer, String type) {
        this.identity = identity;
        this.issuer = issuer;
        this.type = type;
    }

    @Generated
    public PkiIdentity getIdentity() {
        return this.identity;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Optional<Boolean> getAddX5c() {
        return this.addX5c;
    }

    @Generated
    public Optional<String> getKeyId() {
        return this.keyId;
    }

    @Generated
    public Optional<String> getUse() {
        return this.use;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setAddX5c(Optional<Boolean> addX5c) {
        this.addX5c = addX5c;
    }

    @Generated
    public void setKeyId(Optional<String> keyId) {
        this.keyId = keyId;
    }

    @Generated
    public void setUse(Optional<String> use) {
        this.use = use;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }
}

