/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.authentication;

import de.gematik.idp.authentication.AuthenticationResponse;
import de.gematik.idp.brainPoolExtension.BrainpoolAlgorithmSuiteIdentifiers;
import de.gematik.idp.crypto.model.PkiIdentity;
import de.gematik.idp.exceptions.ChallengeExpiredException;
import de.gematik.idp.exceptions.ChallengeSignatureInvalidException;
import de.gematik.idp.exceptions.IdpJoseException;
import de.gematik.idp.exceptions.NoNestedJwtFoundException;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.JsonWebToken;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class AuthenticationChallengeVerifier {
    private PkiIdentity serverIdentity;

    public void verifyResponseAndThrowExceptionIfFail(JsonWebToken authenticationResponse) {
        X509Certificate clientCertificate = this.extractClientCertificateFromChallenge(authenticationResponse).orElseThrow(() -> new IdpJoseException("Could not extract client certificate from challenge response header"));
        this.performClientSignatureValidation(clientCertificate, authenticationResponse.getRawString());
        this.performServerSignatureValidationOfNjwt(authenticationResponse);
    }

    public void verifyResponseWithCertAndThrowExceptionIfFail(X509Certificate authCert, JsonWebToken authenticationResponse) {
        this.performClientSignatureValidation(authCert, authenticationResponse.getRawString());
    }

    public void verifyResponseWithPublicKeyAndThrowExceptionIfFail(PublicKey publicKey, JsonWebToken authenticationResponse) {
        this.performClientSignatureValidationWithKey(publicKey, authenticationResponse.getRawString());
    }

    private void performClientSignatureValidation(X509Certificate clientCertificate, String authResponse) {
        JwtConsumer serverJwtConsumer = new JwtConsumerBuilder().setVerificationKey((Key)clientCertificate.getPublicKey()).setSkipDefaultAudienceValidation().setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"PS256", BrainpoolAlgorithmSuiteIdentifiers.BRAINPOOL256_USING_SHA256})).build();
        try {
            serverJwtConsumer.process(authResponse);
        }
        catch (Exception e) {
            throw new ChallengeSignatureInvalidException(e);
        }
    }

    private void performClientSignatureValidationWithKey(PublicKey publicKey, String authResponse) {
        JwtConsumer serverJwtConsumer = new JwtConsumerBuilder().setVerificationKey((Key)publicKey).build();
        try {
            serverJwtConsumer.process(authResponse);
        }
        catch (InvalidJwtException e) {
            throw new ChallengeSignatureInvalidException((Exception)((Object)e));
        }
    }

    private void performServerSignatureValidationOfNjwt(JsonWebToken authenticationResponse) {
        JsonWebToken serverChallenge = authenticationResponse.getBodyClaim(ClaimName.NESTED_JWT).map(njwt -> new JsonWebToken(njwt.toString())).orElseThrow(NoNestedJwtFoundException::new);
        if (serverChallenge.getExpiresAt().isBefore(ZonedDateTime.now()) || serverChallenge.getExpiresAtBody().isBefore(ZonedDateTime.now())) {
            throw new ChallengeExpiredException();
        }
        try {
            serverChallenge.verify(this.serverIdentity.getCertificate().getPublicKey());
        }
        catch (Exception e) {
            throw new ChallengeSignatureInvalidException();
        }
    }

    public Optional<X509Certificate> extractClientCertificateFromChallenge(JsonWebToken authenticationResponse) {
        return authenticationResponse.getClientCertificateFromHeader();
    }

    public Map<String, Object> extractClaimsFromSignedChallenge(AuthenticationResponse authenticationResponse) {
        return authenticationResponse.getSignedChallenge().getBodyClaims();
    }

    @Generated
    public static AuthenticationChallengeVerifierBuilder builder() {
        return new AuthenticationChallengeVerifierBuilder();
    }

    @Generated
    public PkiIdentity getServerIdentity() {
        return this.serverIdentity;
    }

    @Generated
    public void setServerIdentity(PkiIdentity serverIdentity) {
        this.serverIdentity = serverIdentity;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationChallengeVerifier)) {
            return false;
        }
        AuthenticationChallengeVerifier other = (AuthenticationChallengeVerifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PkiIdentity this$serverIdentity = this.getServerIdentity();
        PkiIdentity other$serverIdentity = other.getServerIdentity();
        return !(this$serverIdentity == null ? other$serverIdentity != null : !this$serverIdentity.equals(other$serverIdentity));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationChallengeVerifier;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PkiIdentity $serverIdentity = this.getServerIdentity();
        result = result * 59 + ($serverIdentity == null ? 43 : $serverIdentity.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticationChallengeVerifier(serverIdentity=" + this.getServerIdentity() + ")";
    }

    @Generated
    public AuthenticationChallengeVerifier(PkiIdentity serverIdentity) {
        this.serverIdentity = serverIdentity;
    }

    @Generated
    public static class AuthenticationChallengeVerifierBuilder {
        @Generated
        private PkiIdentity serverIdentity;

        @Generated
        AuthenticationChallengeVerifierBuilder() {
        }

        @Generated
        public AuthenticationChallengeVerifierBuilder serverIdentity(PkiIdentity serverIdentity) {
            this.serverIdentity = serverIdentity;
            return this;
        }

        @Generated
        public AuthenticationChallengeVerifier build() {
            return new AuthenticationChallengeVerifier(this.serverIdentity);
        }

        @Generated
        public String toString() {
            return "AuthenticationChallengeVerifier.AuthenticationChallengeVerifierBuilder(serverIdentity=" + this.serverIdentity + ")";
        }
    }
}

