/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.idp.authentication.IdpJwtProcessor;
import de.gematik.idp.data.FederationPrivKey;
import de.gematik.idp.data.FederationPubKey;
import de.gematik.idp.data.IdpJwksDocument;
import de.gematik.idp.data.IdpKeyDescriptor;
import de.gematik.idp.exceptions.IdpRuntimeException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;

public final class JwtHelper {
    public static String signJson(IdpJwtProcessor jwtProcessor, ObjectMapper objectMapper, Object object, String typ) {
        try {
            return jwtProcessor.buildJws(objectMapper.writeValueAsString(object), Map.ofEntries(Map.entry("typ", typ)), false).getRawString();
        }
        catch (JsonProcessingException e) {
            throw new IdpRuntimeException("EntityStatement to json failed", (Exception)((Object)e));
        }
    }

    public static IdpJwksDocument getJwks(FederationPrivKey ... federationPrivKeys) {
        return IdpJwksDocument.builder().keys(Arrays.stream(federationPrivKeys).map(federationPrivKey -> {
            IdpKeyDescriptor keyDesc = IdpKeyDescriptor.constructFromX509Certificate(federationPrivKey.getIdentity().getCertificate(), federationPrivKey.getKeyId(), federationPrivKey.getAddX5c().orElse(false));
            keyDesc.setPublicKeyUse(federationPrivKey.getUse().orElse(null));
            return keyDesc;
        }).toList()).build();
    }

    public static IdpJwksDocument getJwks(FederationPubKey ... federationPubKeys) {
        if (federationPubKeys == null) {
            throw new NullPointerException("federationPubKeys is marked non-null but is null");
        }
        return IdpJwksDocument.builder().keys(Stream.of(federationPubKeys).map(federationPubKey -> {
            IdpKeyDescriptor keyDesc = IdpKeyDescriptor.constructFromX509Certificate(federationPubKey.getIdentity().getCertificate(), federationPubKey.getKeyId(), federationPubKey.getAddX5c().orElse(false));
            keyDesc.setPublicKeyUse(federationPubKey.getUse().orElse(null));
            return keyDesc;
        }).toList()).build();
    }

    @Generated
    private JwtHelper() {
    }
}

