/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.data.fedidp;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import de.gematik.idp.data.fedidp.RequestAuthenticationMethodsSupported;
import java.util.Arrays;
import lombok.Generated;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class OpenidProvider {
    private String issuer;
    private String signedJwksUri;
    private String organizationName;
    private String logoUri;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String pushedAuthorizationRequestEndpoint;
    private String[] clientRegistrationTypesSupported;
    private String[] subjectTypesSupported;
    private String[] responseTypesSupported;
    private String[] scopesSupported;
    private String[] responseModesSupported;
    private String[] grantTypesSupported;
    private boolean requirePushedAuthorizationRequests;
    private String[] tokenEndpointAuthMethodsSupported;
    private RequestAuthenticationMethodsSupported requestAuthenticationMethodsSupported;
    private String[] idTokenSigningAlgValuesSupported;
    private String[] idTokenEncryptionAlgValuesSupported;
    private String[] idTokenEncryptionEncValuesSupported;
    private String userTypeSupported;

    @Generated
    public static OpenidProviderBuilder builder() {
        return new OpenidProviderBuilder();
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public String getSignedJwksUri() {
        return this.signedJwksUri;
    }

    @Generated
    public String getOrganizationName() {
        return this.organizationName;
    }

    @Generated
    public String getLogoUri() {
        return this.logoUri;
    }

    @Generated
    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    @Generated
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @Generated
    public String getPushedAuthorizationRequestEndpoint() {
        return this.pushedAuthorizationRequestEndpoint;
    }

    @Generated
    public String[] getClientRegistrationTypesSupported() {
        return this.clientRegistrationTypesSupported;
    }

    @Generated
    public String[] getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    @Generated
    public String[] getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    @Generated
    public String[] getScopesSupported() {
        return this.scopesSupported;
    }

    @Generated
    public String[] getResponseModesSupported() {
        return this.responseModesSupported;
    }

    @Generated
    public String[] getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    @Generated
    public boolean isRequirePushedAuthorizationRequests() {
        return this.requirePushedAuthorizationRequests;
    }

    @Generated
    public String[] getTokenEndpointAuthMethodsSupported() {
        return this.tokenEndpointAuthMethodsSupported;
    }

    @Generated
    public RequestAuthenticationMethodsSupported getRequestAuthenticationMethodsSupported() {
        return this.requestAuthenticationMethodsSupported;
    }

    @Generated
    public String[] getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    @Generated
    public String[] getIdTokenEncryptionAlgValuesSupported() {
        return this.idTokenEncryptionAlgValuesSupported;
    }

    @Generated
    public String[] getIdTokenEncryptionEncValuesSupported() {
        return this.idTokenEncryptionEncValuesSupported;
    }

    @Generated
    public String getUserTypeSupported() {
        return this.userTypeSupported;
    }

    @Generated
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Generated
    public void setSignedJwksUri(String signedJwksUri) {
        this.signedJwksUri = signedJwksUri;
    }

    @Generated
    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    @Generated
    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    @Generated
    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    @Generated
    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    @Generated
    public void setPushedAuthorizationRequestEndpoint(String pushedAuthorizationRequestEndpoint) {
        this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
    }

    @Generated
    public void setClientRegistrationTypesSupported(String[] clientRegistrationTypesSupported) {
        this.clientRegistrationTypesSupported = clientRegistrationTypesSupported;
    }

    @Generated
    public void setSubjectTypesSupported(String[] subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    @Generated
    public void setResponseTypesSupported(String[] responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    @Generated
    public void setScopesSupported(String[] scopesSupported) {
        this.scopesSupported = scopesSupported;
    }

    @Generated
    public void setResponseModesSupported(String[] responseModesSupported) {
        this.responseModesSupported = responseModesSupported;
    }

    @Generated
    public void setGrantTypesSupported(String[] grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
    }

    @Generated
    public void setRequirePushedAuthorizationRequests(boolean requirePushedAuthorizationRequests) {
        this.requirePushedAuthorizationRequests = requirePushedAuthorizationRequests;
    }

    @Generated
    public void setTokenEndpointAuthMethodsSupported(String[] tokenEndpointAuthMethodsSupported) {
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
    }

    @Generated
    public void setRequestAuthenticationMethodsSupported(RequestAuthenticationMethodsSupported requestAuthenticationMethodsSupported) {
        this.requestAuthenticationMethodsSupported = requestAuthenticationMethodsSupported;
    }

    @Generated
    public void setIdTokenSigningAlgValuesSupported(String[] idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
    }

    @Generated
    public void setIdTokenEncryptionAlgValuesSupported(String[] idTokenEncryptionAlgValuesSupported) {
        this.idTokenEncryptionAlgValuesSupported = idTokenEncryptionAlgValuesSupported;
    }

    @Generated
    public void setIdTokenEncryptionEncValuesSupported(String[] idTokenEncryptionEncValuesSupported) {
        this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
    }

    @Generated
    public void setUserTypeSupported(String userTypeSupported) {
        this.userTypeSupported = userTypeSupported;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenidProvider)) {
            return false;
        }
        OpenidProvider other = (OpenidProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRequirePushedAuthorizationRequests() != other.isRequirePushedAuthorizationRequests()) {
            return false;
        }
        String this$issuer = this.getIssuer();
        String other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        String this$signedJwksUri = this.getSignedJwksUri();
        String other$signedJwksUri = other.getSignedJwksUri();
        if (this$signedJwksUri == null ? other$signedJwksUri != null : !this$signedJwksUri.equals(other$signedJwksUri)) {
            return false;
        }
        String this$organizationName = this.getOrganizationName();
        String other$organizationName = other.getOrganizationName();
        if (this$organizationName == null ? other$organizationName != null : !this$organizationName.equals(other$organizationName)) {
            return false;
        }
        String this$logoUri = this.getLogoUri();
        String other$logoUri = other.getLogoUri();
        if (this$logoUri == null ? other$logoUri != null : !this$logoUri.equals(other$logoUri)) {
            return false;
        }
        String this$authorizationEndpoint = this.getAuthorizationEndpoint();
        String other$authorizationEndpoint = other.getAuthorizationEndpoint();
        if (this$authorizationEndpoint == null ? other$authorizationEndpoint != null : !this$authorizationEndpoint.equals(other$authorizationEndpoint)) {
            return false;
        }
        String this$tokenEndpoint = this.getTokenEndpoint();
        String other$tokenEndpoint = other.getTokenEndpoint();
        if (this$tokenEndpoint == null ? other$tokenEndpoint != null : !this$tokenEndpoint.equals(other$tokenEndpoint)) {
            return false;
        }
        String this$pushedAuthorizationRequestEndpoint = this.getPushedAuthorizationRequestEndpoint();
        String other$pushedAuthorizationRequestEndpoint = other.getPushedAuthorizationRequestEndpoint();
        if (this$pushedAuthorizationRequestEndpoint == null ? other$pushedAuthorizationRequestEndpoint != null : !this$pushedAuthorizationRequestEndpoint.equals(other$pushedAuthorizationRequestEndpoint)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getClientRegistrationTypesSupported(), other.getClientRegistrationTypesSupported())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSubjectTypesSupported(), other.getSubjectTypesSupported())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getResponseTypesSupported(), other.getResponseTypesSupported())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getScopesSupported(), other.getScopesSupported())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getResponseModesSupported(), other.getResponseModesSupported())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getGrantTypesSupported(), other.getGrantTypesSupported())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTokenEndpointAuthMethodsSupported(), other.getTokenEndpointAuthMethodsSupported())) {
            return false;
        }
        RequestAuthenticationMethodsSupported this$requestAuthenticationMethodsSupported = this.getRequestAuthenticationMethodsSupported();
        RequestAuthenticationMethodsSupported other$requestAuthenticationMethodsSupported = other.getRequestAuthenticationMethodsSupported();
        if (this$requestAuthenticationMethodsSupported == null ? other$requestAuthenticationMethodsSupported != null : !((Object)this$requestAuthenticationMethodsSupported).equals(other$requestAuthenticationMethodsSupported)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIdTokenSigningAlgValuesSupported(), other.getIdTokenSigningAlgValuesSupported())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIdTokenEncryptionAlgValuesSupported(), other.getIdTokenEncryptionAlgValuesSupported())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIdTokenEncryptionEncValuesSupported(), other.getIdTokenEncryptionEncValuesSupported())) {
            return false;
        }
        String this$userTypeSupported = this.getUserTypeSupported();
        String other$userTypeSupported = other.getUserTypeSupported();
        return !(this$userTypeSupported == null ? other$userTypeSupported != null : !this$userTypeSupported.equals(other$userTypeSupported));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenidProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequirePushedAuthorizationRequests() ? 79 : 97);
        String $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        String $signedJwksUri = this.getSignedJwksUri();
        result = result * 59 + ($signedJwksUri == null ? 43 : $signedJwksUri.hashCode());
        String $organizationName = this.getOrganizationName();
        result = result * 59 + ($organizationName == null ? 43 : $organizationName.hashCode());
        String $logoUri = this.getLogoUri();
        result = result * 59 + ($logoUri == null ? 43 : $logoUri.hashCode());
        String $authorizationEndpoint = this.getAuthorizationEndpoint();
        result = result * 59 + ($authorizationEndpoint == null ? 43 : $authorizationEndpoint.hashCode());
        String $tokenEndpoint = this.getTokenEndpoint();
        result = result * 59 + ($tokenEndpoint == null ? 43 : $tokenEndpoint.hashCode());
        String $pushedAuthorizationRequestEndpoint = this.getPushedAuthorizationRequestEndpoint();
        result = result * 59 + ($pushedAuthorizationRequestEndpoint == null ? 43 : $pushedAuthorizationRequestEndpoint.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getClientRegistrationTypesSupported());
        result = result * 59 + Arrays.deepHashCode(this.getSubjectTypesSupported());
        result = result * 59 + Arrays.deepHashCode(this.getResponseTypesSupported());
        result = result * 59 + Arrays.deepHashCode(this.getScopesSupported());
        result = result * 59 + Arrays.deepHashCode(this.getResponseModesSupported());
        result = result * 59 + Arrays.deepHashCode(this.getGrantTypesSupported());
        result = result * 59 + Arrays.deepHashCode(this.getTokenEndpointAuthMethodsSupported());
        RequestAuthenticationMethodsSupported $requestAuthenticationMethodsSupported = this.getRequestAuthenticationMethodsSupported();
        result = result * 59 + ($requestAuthenticationMethodsSupported == null ? 43 : ((Object)$requestAuthenticationMethodsSupported).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getIdTokenSigningAlgValuesSupported());
        result = result * 59 + Arrays.deepHashCode(this.getIdTokenEncryptionAlgValuesSupported());
        result = result * 59 + Arrays.deepHashCode(this.getIdTokenEncryptionEncValuesSupported());
        String $userTypeSupported = this.getUserTypeSupported();
        result = result * 59 + ($userTypeSupported == null ? 43 : $userTypeSupported.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OpenidProvider(issuer=" + this.getIssuer() + ", signedJwksUri=" + this.getSignedJwksUri() + ", organizationName=" + this.getOrganizationName() + ", logoUri=" + this.getLogoUri() + ", authorizationEndpoint=" + this.getAuthorizationEndpoint() + ", tokenEndpoint=" + this.getTokenEndpoint() + ", pushedAuthorizationRequestEndpoint=" + this.getPushedAuthorizationRequestEndpoint() + ", clientRegistrationTypesSupported=" + Arrays.deepToString(this.getClientRegistrationTypesSupported()) + ", subjectTypesSupported=" + Arrays.deepToString(this.getSubjectTypesSupported()) + ", responseTypesSupported=" + Arrays.deepToString(this.getResponseTypesSupported()) + ", scopesSupported=" + Arrays.deepToString(this.getScopesSupported()) + ", responseModesSupported=" + Arrays.deepToString(this.getResponseModesSupported()) + ", grantTypesSupported=" + Arrays.deepToString(this.getGrantTypesSupported()) + ", requirePushedAuthorizationRequests=" + this.isRequirePushedAuthorizationRequests() + ", tokenEndpointAuthMethodsSupported=" + Arrays.deepToString(this.getTokenEndpointAuthMethodsSupported()) + ", requestAuthenticationMethodsSupported=" + this.getRequestAuthenticationMethodsSupported() + ", idTokenSigningAlgValuesSupported=" + Arrays.deepToString(this.getIdTokenSigningAlgValuesSupported()) + ", idTokenEncryptionAlgValuesSupported=" + Arrays.deepToString(this.getIdTokenEncryptionAlgValuesSupported()) + ", idTokenEncryptionEncValuesSupported=" + Arrays.deepToString(this.getIdTokenEncryptionEncValuesSupported()) + ", userTypeSupported=" + this.getUserTypeSupported() + ")";
    }

    @Generated
    public OpenidProvider() {
    }

    @Generated
    public OpenidProvider(String issuer, String signedJwksUri, String organizationName, String logoUri, String authorizationEndpoint, String tokenEndpoint, String pushedAuthorizationRequestEndpoint, String[] clientRegistrationTypesSupported, String[] subjectTypesSupported, String[] responseTypesSupported, String[] scopesSupported, String[] responseModesSupported, String[] grantTypesSupported, boolean requirePushedAuthorizationRequests, String[] tokenEndpointAuthMethodsSupported, RequestAuthenticationMethodsSupported requestAuthenticationMethodsSupported, String[] idTokenSigningAlgValuesSupported, String[] idTokenEncryptionAlgValuesSupported, String[] idTokenEncryptionEncValuesSupported, String userTypeSupported) {
        this.issuer = issuer;
        this.signedJwksUri = signedJwksUri;
        this.organizationName = organizationName;
        this.logoUri = logoUri;
        this.authorizationEndpoint = authorizationEndpoint;
        this.tokenEndpoint = tokenEndpoint;
        this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
        this.clientRegistrationTypesSupported = clientRegistrationTypesSupported;
        this.subjectTypesSupported = subjectTypesSupported;
        this.responseTypesSupported = responseTypesSupported;
        this.scopesSupported = scopesSupported;
        this.responseModesSupported = responseModesSupported;
        this.grantTypesSupported = grantTypesSupported;
        this.requirePushedAuthorizationRequests = requirePushedAuthorizationRequests;
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
        this.requestAuthenticationMethodsSupported = requestAuthenticationMethodsSupported;
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
        this.idTokenEncryptionAlgValuesSupported = idTokenEncryptionAlgValuesSupported;
        this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
        this.userTypeSupported = userTypeSupported;
    }

    @Generated
    public static class OpenidProviderBuilder {
        @Generated
        private String issuer;
        @Generated
        private String signedJwksUri;
        @Generated
        private String organizationName;
        @Generated
        private String logoUri;
        @Generated
        private String authorizationEndpoint;
        @Generated
        private String tokenEndpoint;
        @Generated
        private String pushedAuthorizationRequestEndpoint;
        @Generated
        private String[] clientRegistrationTypesSupported;
        @Generated
        private String[] subjectTypesSupported;
        @Generated
        private String[] responseTypesSupported;
        @Generated
        private String[] scopesSupported;
        @Generated
        private String[] responseModesSupported;
        @Generated
        private String[] grantTypesSupported;
        @Generated
        private boolean requirePushedAuthorizationRequests;
        @Generated
        private String[] tokenEndpointAuthMethodsSupported;
        @Generated
        private RequestAuthenticationMethodsSupported requestAuthenticationMethodsSupported;
        @Generated
        private String[] idTokenSigningAlgValuesSupported;
        @Generated
        private String[] idTokenEncryptionAlgValuesSupported;
        @Generated
        private String[] idTokenEncryptionEncValuesSupported;
        @Generated
        private String userTypeSupported;

        @Generated
        OpenidProviderBuilder() {
        }

        @Generated
        public OpenidProviderBuilder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        @Generated
        public OpenidProviderBuilder signedJwksUri(String signedJwksUri) {
            this.signedJwksUri = signedJwksUri;
            return this;
        }

        @Generated
        public OpenidProviderBuilder organizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        @Generated
        public OpenidProviderBuilder logoUri(String logoUri) {
            this.logoUri = logoUri;
            return this;
        }

        @Generated
        public OpenidProviderBuilder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        @Generated
        public OpenidProviderBuilder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        @Generated
        public OpenidProviderBuilder pushedAuthorizationRequestEndpoint(String pushedAuthorizationRequestEndpoint) {
            this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
            return this;
        }

        @Generated
        public OpenidProviderBuilder clientRegistrationTypesSupported(String[] clientRegistrationTypesSupported) {
            this.clientRegistrationTypesSupported = clientRegistrationTypesSupported;
            return this;
        }

        @Generated
        public OpenidProviderBuilder subjectTypesSupported(String[] subjectTypesSupported) {
            this.subjectTypesSupported = subjectTypesSupported;
            return this;
        }

        @Generated
        public OpenidProviderBuilder responseTypesSupported(String[] responseTypesSupported) {
            this.responseTypesSupported = responseTypesSupported;
            return this;
        }

        @Generated
        public OpenidProviderBuilder scopesSupported(String[] scopesSupported) {
            this.scopesSupported = scopesSupported;
            return this;
        }

        @Generated
        public OpenidProviderBuilder responseModesSupported(String[] responseModesSupported) {
            this.responseModesSupported = responseModesSupported;
            return this;
        }

        @Generated
        public OpenidProviderBuilder grantTypesSupported(String[] grantTypesSupported) {
            this.grantTypesSupported = grantTypesSupported;
            return this;
        }

        @Generated
        public OpenidProviderBuilder requirePushedAuthorizationRequests(boolean requirePushedAuthorizationRequests) {
            this.requirePushedAuthorizationRequests = requirePushedAuthorizationRequests;
            return this;
        }

        @Generated
        public OpenidProviderBuilder tokenEndpointAuthMethodsSupported(String[] tokenEndpointAuthMethodsSupported) {
            this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
            return this;
        }

        @Generated
        public OpenidProviderBuilder requestAuthenticationMethodsSupported(RequestAuthenticationMethodsSupported requestAuthenticationMethodsSupported) {
            this.requestAuthenticationMethodsSupported = requestAuthenticationMethodsSupported;
            return this;
        }

        @Generated
        public OpenidProviderBuilder idTokenSigningAlgValuesSupported(String[] idTokenSigningAlgValuesSupported) {
            this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
            return this;
        }

        @Generated
        public OpenidProviderBuilder idTokenEncryptionAlgValuesSupported(String[] idTokenEncryptionAlgValuesSupported) {
            this.idTokenEncryptionAlgValuesSupported = idTokenEncryptionAlgValuesSupported;
            return this;
        }

        @Generated
        public OpenidProviderBuilder idTokenEncryptionEncValuesSupported(String[] idTokenEncryptionEncValuesSupported) {
            this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
            return this;
        }

        @Generated
        public OpenidProviderBuilder userTypeSupported(String userTypeSupported) {
            this.userTypeSupported = userTypeSupported;
            return this;
        }

        @Generated
        public OpenidProvider build() {
            return new OpenidProvider(this.issuer, this.signedJwksUri, this.organizationName, this.logoUri, this.authorizationEndpoint, this.tokenEndpoint, this.pushedAuthorizationRequestEndpoint, this.clientRegistrationTypesSupported, this.subjectTypesSupported, this.responseTypesSupported, this.scopesSupported, this.responseModesSupported, this.grantTypesSupported, this.requirePushedAuthorizationRequests, this.tokenEndpointAuthMethodsSupported, this.requestAuthenticationMethodsSupported, this.idTokenSigningAlgValuesSupported, this.idTokenEncryptionAlgValuesSupported, this.idTokenEncryptionEncValuesSupported, this.userTypeSupported);
        }

        @Generated
        public String toString() {
            return "OpenidProvider.OpenidProviderBuilder(issuer=" + this.issuer + ", signedJwksUri=" + this.signedJwksUri + ", organizationName=" + this.organizationName + ", logoUri=" + this.logoUri + ", authorizationEndpoint=" + this.authorizationEndpoint + ", tokenEndpoint=" + this.tokenEndpoint + ", pushedAuthorizationRequestEndpoint=" + this.pushedAuthorizationRequestEndpoint + ", clientRegistrationTypesSupported=" + Arrays.deepToString(this.clientRegistrationTypesSupported) + ", subjectTypesSupported=" + Arrays.deepToString(this.subjectTypesSupported) + ", responseTypesSupported=" + Arrays.deepToString(this.responseTypesSupported) + ", scopesSupported=" + Arrays.deepToString(this.scopesSupported) + ", responseModesSupported=" + Arrays.deepToString(this.responseModesSupported) + ", grantTypesSupported=" + Arrays.deepToString(this.grantTypesSupported) + ", requirePushedAuthorizationRequests=" + this.requirePushedAuthorizationRequests + ", tokenEndpointAuthMethodsSupported=" + Arrays.deepToString(this.tokenEndpointAuthMethodsSupported) + ", requestAuthenticationMethodsSupported=" + this.requestAuthenticationMethodsSupported + ", idTokenSigningAlgValuesSupported=" + Arrays.deepToString(this.idTokenSigningAlgValuesSupported) + ", idTokenEncryptionAlgValuesSupported=" + Arrays.deepToString(this.idTokenEncryptionAlgValuesSupported) + ", idTokenEncryptionEncValuesSupported=" + Arrays.deepToString(this.idTokenEncryptionEncValuesSupported) + ", userTypeSupported=" + this.userTypeSupported + ")";
        }
    }
}

