/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.idp.authentication.IdpJwtProcessor;
import de.gematik.idp.crypto.model.PkiIdentity;
import de.gematik.idp.data.FederationPrivKey;
import de.gematik.idp.data.FederationPubKey;
import de.gematik.idp.data.IdpJwksDocument;
import de.gematik.idp.data.IdpKeyDescriptor;
import de.gematik.idp.exceptions.IdpRuntimeException;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class JwtHelper {
    public static String signJson(IdpJwtProcessor jwtProcessor, ObjectMapper objectMapper, Object object, String typ) {
        try {
            return jwtProcessor.buildJws(objectMapper.writeValueAsString(object), Map.ofEntries(Map.entry("typ", typ)), false).getRawString();
        }
        catch (JsonProcessingException e) {
            throw new IdpRuntimeException("EntityStatement to json failed", (Exception)((Object)e));
        }
    }

    public static IdpJwksDocument getJwks(FederationPrivKey federationKey) {
        ArrayList<PkiIdentity> identities = new ArrayList<PkiIdentity>();
        identities.add(federationKey.getIdentity());
        return IdpJwksDocument.builder().keys(identities.stream().map(identity -> {
            IdpKeyDescriptor keyDesc = IdpKeyDescriptor.constructFromX509Certificate(identity.getCertificate(), identity.getKeyId(), false);
            keyDesc.setPublicKeyUse(identity.getUse().orElse(null));
            return keyDesc;
        }).toList()).build();
    }

    public static IdpJwksDocument getJwks(@NonNull FederationPubKey federationPubKey) {
        if (federationPubKey == null) {
            throw new NullPointerException("federationPubKey is marked non-null but is null");
        }
        ArrayList<PkiIdentity> identities = new ArrayList<PkiIdentity>();
        identities.add(federationPubKey.getIdentity());
        return IdpJwksDocument.builder().keys(identities.stream().map(identity -> {
            IdpKeyDescriptor keyDesc = IdpKeyDescriptor.constructFromX509Certificate(identity.getCertificate(), identity.getKeyId(), false);
            keyDesc.setPublicKeyUse(identity.getUse().orElse(null));
            return keyDesc;
        }).toList()).build();
    }

    @Generated
    private JwtHelper() {
    }
}

