/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.data;

import de.gematik.idp.crypto.model.PkiIdentity;
import de.gematik.idp.data.IdpKeyDescriptor;
import lombok.Generated;

public class FederationPubKey {
    private final PkiIdentity identity;
    private final String issuer;
    private final String type;
    private String url;

    public IdpKeyDescriptor buildJwk(boolean addX5C) {
        IdpKeyDescriptor keyDesc = IdpKeyDescriptor.constructFromX509Certificate(this.identity.getCertificate(), this.identity.getKeyId(), addX5C);
        keyDesc.setPublicKeyUse(this.identity.getUse().orElse(null));
        return keyDesc;
    }

    @Generated
    public FederationPubKey(PkiIdentity identity, String issuer, String type, String url) {
        this.identity = identity;
        this.issuer = issuer;
        this.type = type;
        this.url = url;
    }

    @Generated
    public FederationPubKey(PkiIdentity identity, String issuer, String type) {
        this.identity = identity;
        this.issuer = issuer;
        this.type = type;
    }

    @Generated
    public PkiIdentity getIdentity() {
        return this.identity;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }
}

