/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.authentication;

import de.gematik.idp.authentication.JwtBuilder;
import de.gematik.idp.brainPoolExtension.BrainpoolAlgorithmSuiteIdentifiers;
import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import de.gematik.idp.crypto.model.PkiIdentity;
import de.gematik.idp.exceptions.IdpJoseException;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.JsonWebToken;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

public class IdpJwtProcessor {
    private final X509Certificate certificate;
    private final String algorithm;
    private Optional<String> keyId;
    private PrivateKey privateKey;

    public IdpJwtProcessor(@NonNull PkiIdentity identity) {
        this(identity.getCertificate());
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        this.privateKey = identity.getPrivateKey();
        this.keyId = identity.getKeyId();
    }

    public IdpJwtProcessor(@NonNull X509Certificate certificate) {
        if (certificate == null) {
            throw new NullPointerException("certificate is marked non-null but is null");
        }
        this.certificate = certificate;
        if (certificate.getPublicKey() instanceof ECPublicKey) {
            this.algorithm = ((ECPublicKey)certificate.getPublicKey()).getParams() instanceof ECNamedCurveSpec && ((ECNamedCurveSpec)((ECPublicKey)certificate.getPublicKey()).getParams()).getName().equals("prime256v1") ? "ES256" : BrainpoolAlgorithmSuiteIdentifiers.BRAINPOOL256_USING_SHA256;
        } else if (certificate.getPublicKey() instanceof RSAPublicKey) {
            this.algorithm = "PS256";
        } else {
            throw new IdpCryptoException("Could not identify Public-Key: " + certificate.getPublicKey().getClass().toString());
        }
    }

    public JsonWebToken buildJwt(@NonNull JwtBuilder jwtBuilder) {
        Objects.requireNonNull(this.privateKey, "No private key supplied, cancelling JWT signing");
        Objects.requireNonNull(jwtBuilder, "No Descriptor supplied, cancelling JWT signing");
        this.keyId.ifPresent(keyIdValue -> jwtBuilder.addHeaderClaim(ClaimName.KEY_ID, keyIdValue));
        return jwtBuilder.setSignerKey(this.privateKey).setCertificate(this.certificate).buildJwt();
    }

    public JsonWebToken buildJws(@NonNull String payload, @NonNull Map<String, Object> headerClaims, boolean includeSignerCertificateInHeader) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (headerClaims == null) {
            throw new NullPointerException("headerClaims is marked non-null but is null");
        }
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(payload);
        jws.setKey((Key)this.privateKey);
        jws.setAlgorithmHeaderValue(this.algorithm);
        headerClaims.keySet().forEach(key -> jws.setHeader(key, headerClaims.get(key)));
        this.keyId.ifPresent(keyIdValue -> jws.setHeader(ClaimName.KEY_ID.getJoseName(), keyIdValue));
        if (includeSignerCertificateInHeader) {
            jws.setCertificateChainHeaderValue(new X509Certificate[]{this.certificate});
        }
        try {
            return new JsonWebToken(jws.getCompactSerialization());
        }
        catch (JoseException e) {
            throw new IdpJoseException((Exception)((Object)e));
        }
    }

    public void verifyAndThrowExceptionIfFail(@NonNull JsonWebToken jwt) {
        if (jwt == null) {
            throw new NullPointerException("jwt is marked non-null but is null");
        }
        jwt.verify(this.certificate.getPublicKey());
    }

    public String getHeaderDecoded(@NonNull JsonWebToken jwt) {
        if (jwt == null) {
            throw new NullPointerException("jwt is marked non-null but is null");
        }
        return jwt.getHeaderDecoded();
    }

    public String getPayloadDecoded(@NonNull JsonWebToken jwt) {
        if (jwt == null) {
            throw new NullPointerException("jwt is marked non-null but is null");
        }
        return jwt.getPayloadDecoded();
    }
}

