/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.authentication;

import de.gematik.idp.authentication.AuthenticationChallengeVerifier;
import de.gematik.idp.authentication.IdpJwtProcessor;
import de.gematik.idp.authentication.JwtBuilder;
import de.gematik.idp.crypto.CryptoLoader;
import de.gematik.idp.crypto.Nonce;
import de.gematik.idp.crypto.X509ClaimExtraction;
import de.gematik.idp.exceptions.IdpJoseException;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.IdpJwe;
import de.gematik.idp.token.JsonWebToken;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class AuthenticationTokenBuilder {
    private final IdpJwtProcessor jwtProcessor;
    private final Key encryptionKey;
    private final AuthenticationChallengeVerifier authenticationChallengeVerifier;
    private final String issuerUrl;

    public IdpJwe buildAuthenticationToken(X509Certificate clientCertificate, Map<String, Object> serverChallengeClaims, ZonedDateTime issueingTime) {
        Map<String, Object> claimsMap = this.extractClaimsFromCertificate(clientCertificate);
        claimsMap.put(ClaimName.CLIENT_ID.getJoseName(), serverChallengeClaims.get(ClaimName.CLIENT_ID.getJoseName()));
        claimsMap.put(ClaimName.REDIRECT_URI.getJoseName(), serverChallengeClaims.get(ClaimName.REDIRECT_URI.getJoseName()));
        claimsMap.put(ClaimName.NONCE.getJoseName(), serverChallengeClaims.get(ClaimName.NONCE.getJoseName()));
        claimsMap.put(ClaimName.CODE_CHALLENGE.getJoseName(), serverChallengeClaims.get(ClaimName.CODE_CHALLENGE.getJoseName()));
        claimsMap.put(ClaimName.CODE_CHALLENGE_METHOD.getJoseName(), serverChallengeClaims.get(ClaimName.CODE_CHALLENGE_METHOD.getJoseName()));
        claimsMap.put(ClaimName.ISSUER.getJoseName(), serverChallengeClaims.get(ClaimName.ISSUER.getJoseName()));
        claimsMap.put(ClaimName.RESPONSE_TYPE.getJoseName(), serverChallengeClaims.get(ClaimName.RESPONSE_TYPE.getJoseName()));
        claimsMap.put(ClaimName.STATE.getJoseName(), serverChallengeClaims.get(ClaimName.STATE.getJoseName()));
        claimsMap.put(ClaimName.SCOPE.getJoseName(), serverChallengeClaims.get(ClaimName.SCOPE.getJoseName()));
        claimsMap.put(ClaimName.ISSUED_AT.getJoseName(), issueingTime.toEpochSecond());
        claimsMap.put(ClaimName.TOKEN_TYPE.getJoseName(), "code");
        claimsMap.put(ClaimName.AUTH_TIME.getJoseName(), issueingTime.toEpochSecond());
        claimsMap.put(ClaimName.SERVER_NONCE.getJoseName(), Nonce.getNonceAsBase64UrlEncodedString((int)24));
        claimsMap.put(ClaimName.JWT_ID.getJoseName(), Nonce.getNonceAsHex((int)16));
        claimsMap.put(ClaimName.AUTHENTICATION_METHODS_REFERENCE.getJoseName(), serverChallengeClaims.getOrDefault(ClaimName.AUTHENTICATION_METHODS_REFERENCE.getJoseName(), List.of("mfa", "sc", "pin")));
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        headerMap.put(ClaimName.TYPE.getJoseName(), "JWT");
        return this.jwtProcessor.buildJwt(new JwtBuilder().addAllBodyClaims(claimsMap).addAllHeaderClaims(headerMap).expiresAt(issueingTime.plusMinutes(1L))).encrypt(this.encryptionKey);
    }

    private Map<String, Object> extractClaimsFromCertificate(X509Certificate clientCertificate) {
        try {
            return X509ClaimExtraction.extractClaimsFromCertificate((X509Certificate)clientCertificate);
        }
        catch (RuntimeException e) {
            throw new IdpJoseException("2020", e);
        }
    }

    public IdpJwe buildAuthenticationTokenFromSsoToken(JsonWebToken ssoToken, JsonWebToken challengeToken, ZonedDateTime issueingTime) {
        HashMap<String, Object> claimsMap = new HashMap<String, Object>();
        if (ssoToken.getBodyClaims().containsKey(ClaimName.CONFIRMATION.getJoseName())) {
            X509Certificate confirmationCertificate = this.extractConfirmationCertificate(ssoToken);
            claimsMap.putAll(this.extractClaimsFromCertificate(confirmationCertificate));
        } else {
            claimsMap.put(ClaimName.GIVEN_NAME.getJoseName(), this.extractClaimFromChallengeToken(ssoToken, ClaimName.GIVEN_NAME));
            claimsMap.put(ClaimName.FAMILY_NAME.getJoseName(), this.extractClaimFromChallengeToken(ssoToken, ClaimName.FAMILY_NAME));
            claimsMap.put(ClaimName.ID_NUMBER.getJoseName(), this.extractClaimFromChallengeToken(ssoToken, ClaimName.ID_NUMBER));
            claimsMap.put(ClaimName.ORGANIZATION_NAME.getJoseName(), this.extractClaimFromChallengeToken(ssoToken, ClaimName.ORGANIZATION_NAME));
            claimsMap.put(ClaimName.PROFESSION_OID.getJoseName(), this.extractClaimFromChallengeToken(ssoToken, ClaimName.PROFESSION_OID));
        }
        claimsMap.put(ClaimName.CODE_CHALLENGE.getJoseName(), this.extractClaimFromChallengeToken(challengeToken, ClaimName.CODE_CHALLENGE));
        claimsMap.put(ClaimName.CODE_CHALLENGE_METHOD.getJoseName(), this.extractClaimFromChallengeToken(challengeToken, ClaimName.CODE_CHALLENGE_METHOD));
        claimsMap.put(ClaimName.NONCE.getJoseName(), this.extractClaimFromChallengeToken(challengeToken, ClaimName.NONCE));
        claimsMap.put(ClaimName.CLIENT_ID.getJoseName(), this.extractClaimFromChallengeToken(challengeToken, ClaimName.CLIENT_ID));
        claimsMap.put(ClaimName.REDIRECT_URI.getJoseName(), this.extractClaimFromChallengeToken(challengeToken, ClaimName.REDIRECT_URI));
        claimsMap.put(ClaimName.SCOPE.getJoseName(), this.extractClaimFromChallengeToken(challengeToken, ClaimName.SCOPE));
        claimsMap.put(ClaimName.ISSUED_AT.getJoseName(), issueingTime.toEpochSecond());
        claimsMap.put(ClaimName.STATE.getJoseName(), this.extractClaimFromChallengeToken(challengeToken, ClaimName.STATE));
        claimsMap.put(ClaimName.RESPONSE_TYPE.getJoseName(), this.extractClaimFromChallengeToken(challengeToken, ClaimName.RESPONSE_TYPE));
        claimsMap.put(ClaimName.TOKEN_TYPE.getJoseName(), "code");
        claimsMap.put(ClaimName.AUTH_TIME.getJoseName(), ZonedDateTime.now().toEpochSecond());
        claimsMap.put(ClaimName.SERVER_NONCE.getJoseName(), Nonce.getNonceAsBase64UrlEncodedString((int)24));
        claimsMap.put(ClaimName.ISSUER.getJoseName(), this.extractClaimFromChallengeToken(challengeToken, ClaimName.ISSUER));
        claimsMap.put(ClaimName.JWT_ID.getJoseName(), Nonce.getNonceAsHex((int)16));
        HashMap<String, Object> headerClaims = new HashMap<String, Object>(ssoToken.getHeaderClaims());
        headerClaims.put(ClaimName.TYPE.getJoseName(), "JWT");
        return this.jwtProcessor.buildJwt(new JwtBuilder().replaceAllHeaderClaims(headerClaims).replaceAllBodyClaims(claimsMap).expiresAt(ZonedDateTime.now().plusHours(1L))).encrypt(this.encryptionKey);
    }

    public IdpJwe buildAuthenticationTokenFromSektoralIdToken(JsonWebToken idToken, ZonedDateTime issueingTime, Map<String, String> sessionData) {
        HashMap<String, Object> claimsMap = new HashMap<String, Object>();
        claimsMap.put(ClaimName.GIVEN_NAME.getJoseName(), this.extractClaimFromChallengeToken(idToken, ClaimName.GIVEN_NAME));
        claimsMap.put(ClaimName.FAMILY_NAME.getJoseName(), this.extractClaimFromChallengeToken(idToken, ClaimName.FAMILY_NAME));
        claimsMap.put(ClaimName.ID_NUMBER.getJoseName(), this.extractClaimFromChallengeToken(idToken, ClaimName.ID_NUMBER));
        claimsMap.put(ClaimName.PROFESSION_OID.getJoseName(), this.extractClaimFromChallengeToken(idToken, ClaimName.PROFESSION_OID));
        claimsMap.put(ClaimName.CODE_CHALLENGE.getJoseName(), sessionData.get(ClaimName.CODE_CHALLENGE.getJoseName()));
        claimsMap.put(ClaimName.CODE_CHALLENGE_METHOD.getJoseName(), sessionData.get(ClaimName.CODE_CHALLENGE_METHOD.getJoseName()));
        if (sessionData.get(ClaimName.NONCE.getJoseName()) != null) {
            claimsMap.put(ClaimName.NONCE.getJoseName(), sessionData.get(ClaimName.NONCE.getJoseName()));
        }
        claimsMap.put(ClaimName.CLIENT_ID.getJoseName(), sessionData.get(ClaimName.CLIENT_ID.getJoseName()));
        claimsMap.put(ClaimName.REDIRECT_URI.getJoseName(), sessionData.get(ClaimName.REDIRECT_URI.getJoseName()));
        claimsMap.put(ClaimName.SCOPE.getJoseName(), "openid e-rezept");
        claimsMap.put(ClaimName.ISSUED_AT.getJoseName(), issueingTime.toEpochSecond());
        claimsMap.put(ClaimName.STATE.getJoseName(), sessionData.get(ClaimName.STATE.getJoseName()));
        claimsMap.put(ClaimName.RESPONSE_TYPE.getJoseName(), sessionData.get(ClaimName.RESPONSE_TYPE.getJoseName()));
        claimsMap.put(ClaimName.TOKEN_TYPE.getJoseName(), "code");
        claimsMap.put(ClaimName.AUTH_TIME.getJoseName(), ZonedDateTime.now().toEpochSecond());
        claimsMap.put(ClaimName.SERVER_NONCE.getJoseName(), Nonce.getNonceAsBase64UrlEncodedString((int)24));
        claimsMap.put(ClaimName.ISSUER.getJoseName(), this.issuerUrl);
        claimsMap.put(ClaimName.JWT_ID.getJoseName(), Nonce.getNonceAsHex((int)16));
        claimsMap.put(ClaimName.AUTHENTICATION_METHODS_REFERENCE.getJoseName(), List.of("mfa"));
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        headerMap.put(ClaimName.TYPE.getJoseName(), "JWT");
        return this.jwtProcessor.buildJwt(new JwtBuilder().addAllHeaderClaims(headerMap).addAllBodyClaims(claimsMap).expiresAt(ZonedDateTime.now().plusHours(1L))).encrypt(this.encryptionKey);
    }

    private Object extractClaimFromChallengeToken(JsonWebToken challengeToken, ClaimName claimName) {
        return challengeToken.getBodyClaim(claimName).orElseThrow(() -> new IdpJoseException("Unexpected structure in Challenge-Token"));
    }

    private X509Certificate extractConfirmationCertificate(JsonWebToken ssoToken) {
        String certString = ssoToken.getBodyClaim(ClaimName.CONFIRMATION).filter(Map.class::isInstance).map(Map.class::cast).map(map -> map.get(ClaimName.X509_CERTIFICATE_CHAIN.getJoseName())).filter(List.class::isInstance).map(List.class::cast).filter(list -> !list.isEmpty()).map(list -> list.get(0)).map(Object::toString).orElseThrow(() -> new IdpJoseException("Unsupported cnf-Structure found: Could not extract confirmed Certificate!"));
        byte[] decode = Base64.getDecoder().decode(certString);
        return CryptoLoader.getCertificateFromPem((byte[])decode);
    }

    @Generated
    public static AuthenticationTokenBuilderBuilder builder() {
        return new AuthenticationTokenBuilderBuilder();
    }

    @Generated
    public IdpJwtProcessor getJwtProcessor() {
        return this.jwtProcessor;
    }

    @Generated
    public Key getEncryptionKey() {
        return this.encryptionKey;
    }

    @Generated
    public AuthenticationChallengeVerifier getAuthenticationChallengeVerifier() {
        return this.authenticationChallengeVerifier;
    }

    @Generated
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationTokenBuilder)) {
            return false;
        }
        AuthenticationTokenBuilder other = (AuthenticationTokenBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IdpJwtProcessor this$jwtProcessor = this.getJwtProcessor();
        IdpJwtProcessor other$jwtProcessor = other.getJwtProcessor();
        if (this$jwtProcessor == null ? other$jwtProcessor != null : !this$jwtProcessor.equals(other$jwtProcessor)) {
            return false;
        }
        Key this$encryptionKey = this.getEncryptionKey();
        Key other$encryptionKey = other.getEncryptionKey();
        if (this$encryptionKey == null ? other$encryptionKey != null : !this$encryptionKey.equals(other$encryptionKey)) {
            return false;
        }
        AuthenticationChallengeVerifier this$authenticationChallengeVerifier = this.getAuthenticationChallengeVerifier();
        AuthenticationChallengeVerifier other$authenticationChallengeVerifier = other.getAuthenticationChallengeVerifier();
        if (this$authenticationChallengeVerifier == null ? other$authenticationChallengeVerifier != null : !((Object)this$authenticationChallengeVerifier).equals(other$authenticationChallengeVerifier)) {
            return false;
        }
        String this$issuerUrl = this.getIssuerUrl();
        String other$issuerUrl = other.getIssuerUrl();
        return !(this$issuerUrl == null ? other$issuerUrl != null : !this$issuerUrl.equals(other$issuerUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationTokenBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IdpJwtProcessor $jwtProcessor = this.getJwtProcessor();
        result = result * 59 + ($jwtProcessor == null ? 43 : $jwtProcessor.hashCode());
        Key $encryptionKey = this.getEncryptionKey();
        result = result * 59 + ($encryptionKey == null ? 43 : $encryptionKey.hashCode());
        AuthenticationChallengeVerifier $authenticationChallengeVerifier = this.getAuthenticationChallengeVerifier();
        result = result * 59 + ($authenticationChallengeVerifier == null ? 43 : ((Object)$authenticationChallengeVerifier).hashCode());
        String $issuerUrl = this.getIssuerUrl();
        result = result * 59 + ($issuerUrl == null ? 43 : $issuerUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticationTokenBuilder(jwtProcessor=" + this.getJwtProcessor() + ", encryptionKey=" + this.getEncryptionKey() + ", authenticationChallengeVerifier=" + this.getAuthenticationChallengeVerifier() + ", issuerUrl=" + this.getIssuerUrl() + ")";
    }

    @Generated
    public AuthenticationTokenBuilder(IdpJwtProcessor jwtProcessor, Key encryptionKey, AuthenticationChallengeVerifier authenticationChallengeVerifier, String issuerUrl) {
        this.jwtProcessor = jwtProcessor;
        this.encryptionKey = encryptionKey;
        this.authenticationChallengeVerifier = authenticationChallengeVerifier;
        this.issuerUrl = issuerUrl;
    }

    @Generated
    public static class AuthenticationTokenBuilderBuilder {
        @Generated
        private IdpJwtProcessor jwtProcessor;
        @Generated
        private Key encryptionKey;
        @Generated
        private AuthenticationChallengeVerifier authenticationChallengeVerifier;
        @Generated
        private String issuerUrl;

        @Generated
        AuthenticationTokenBuilderBuilder() {
        }

        @Generated
        public AuthenticationTokenBuilderBuilder jwtProcessor(IdpJwtProcessor jwtProcessor) {
            this.jwtProcessor = jwtProcessor;
            return this;
        }

        @Generated
        public AuthenticationTokenBuilderBuilder encryptionKey(Key encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        @Generated
        public AuthenticationTokenBuilderBuilder authenticationChallengeVerifier(AuthenticationChallengeVerifier authenticationChallengeVerifier) {
            this.authenticationChallengeVerifier = authenticationChallengeVerifier;
            return this;
        }

        @Generated
        public AuthenticationTokenBuilderBuilder issuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        @Generated
        public AuthenticationTokenBuilder build() {
            return new AuthenticationTokenBuilder(this.jwtProcessor, this.encryptionKey, this.authenticationChallengeVerifier, this.issuerUrl);
        }

        @Generated
        public String toString() {
            return "AuthenticationTokenBuilder.AuthenticationTokenBuilderBuilder(jwtProcessor=" + this.jwtProcessor + ", encryptionKey=" + this.encryptionKey + ", authenticationChallengeVerifier=" + this.authenticationChallengeVerifier + ", issuerUrl=" + this.issuerUrl + ")";
        }
    }
}

