/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.client;

import de.gematik.idp.authentication.AuthenticationChallenge;
import de.gematik.idp.authentication.UriUtils;
import de.gematik.idp.client.IdpClientRuntimeException;
import de.gematik.idp.client.IdpTokenResult;
import de.gematik.idp.client.data.AuthenticationRequest;
import de.gematik.idp.client.data.AuthenticationResponse;
import de.gematik.idp.client.data.AuthorizationRequest;
import de.gematik.idp.client.data.AuthorizationResponse;
import de.gematik.idp.client.data.DiscoveryDocumentResponse;
import de.gematik.idp.client.data.TokenRequest;
import de.gematik.idp.crypto.CryptoLoader;
import de.gematik.idp.crypto.EcKeyUtility;
import de.gematik.idp.crypto.Nonce;
import de.gematik.idp.data.IdpErrorResponse;
import de.gematik.idp.error.IdpErrorType;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.IdpJwe;
import de.gematik.idp.token.JsonWebToken;
import java.net.URI;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kong.unirest.core.BodyPart;
import kong.unirest.core.GetRequest;
import kong.unirest.core.Header;
import kong.unirest.core.HttpRequest;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.JsonNode;
import kong.unirest.core.MultipartBody;
import kong.unirest.core.ObjectMapper;
import kong.unirest.core.Unirest;
import kong.unirest.core.json.JSONObject;
import kong.unirest.jackson.JacksonObjectMapper;
import lombok.Generated;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticatorClient.class);
    private static final String USER_AGENT = "IdP-Client";

    public AuthenticatorClient() {
        Unirest.config().reset();
        Unirest.config().followRedirects(false);
        Unirest.config().setObjectMapper((ObjectMapper)new JacksonObjectMapper());
    }

    public static Map<String, String> getAllHeaderElementsAsMap(HttpRequest request) {
        return request.getHeaders().all().stream().collect(Collectors.toMap(Header::getName, Header::getValue));
    }

    public static Map<String, Object> getAllFieldElementsAsMap(MultipartBody request) {
        return request.multiParts().stream().collect(Collectors.toMap(BodyPart::getName, BodyPart::getValue));
    }

    private static PublicKey getPublicKey(JSONObject keyObject) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return EcKeyUtility.genECPublicKey((String)"brainpoolP256r1", (String)keyObject.getString("x"), (String)keyObject.getString("y"));
    }

    public AuthorizationResponse doAuthorizationRequest(AuthorizationRequest authorizationRequest, UnaryOperator<GetRequest> beforeCallback, Consumer<HttpResponse<AuthenticationChallenge>> afterCallback) {
        String scope = String.join((CharSequence)" ", authorizationRequest.getScopes());
        GetRequest request = (GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)authorizationRequest.getLink()).queryString(ClaimName.CLIENT_ID.getJoseName(), (Object)authorizationRequest.getClientId())).queryString(ClaimName.RESPONSE_TYPE.getJoseName(), (Object)"code")).queryString(ClaimName.REDIRECT_URI.getJoseName(), (Object)authorizationRequest.getRedirectUri())).queryString(ClaimName.STATE.getJoseName(), (Object)authorizationRequest.getState())).queryString(ClaimName.CODE_CHALLENGE.getJoseName(), (Object)authorizationRequest.getCodeChallenge())).queryString(ClaimName.CODE_CHALLENGE_METHOD.getJoseName(), (Object)authorizationRequest.getCodeChallengeMethod())).queryString(ClaimName.SCOPE.getJoseName(), (Object)scope)).queryString("nonce", (Object)authorizationRequest.getNonce())).header("User-Agent", USER_AGENT)).header("Accept", "application/json");
        HttpResponse authorizationResponse = ((GetRequest)beforeCallback.apply(request)).asObject(AuthenticationChallenge.class);
        afterCallback.accept((HttpResponse<AuthenticationChallenge>)authorizationResponse);
        this.checkResponseForErrorsAndThrowIfAny(authorizationResponse);
        return AuthorizationResponse.builder().authenticationChallenge((AuthenticationChallenge)authorizationResponse.getBody()).build();
    }

    public AuthenticationResponse performAuthentication(AuthenticationRequest authenticationRequest, UnaryOperator<MultipartBody> beforeAuthenticationCallback, Consumer<HttpResponse<String>> afterAuthenticationCallback) {
        MultipartBody request = (MultipartBody)Unirest.post((String)authenticationRequest.getAuthenticationEndpointUrl()).field("signed_challenge", (Object)authenticationRequest.getSignedChallenge().getRawString()).contentType("application/x-www-form-urlencoded").header("User-Agent", USER_AGENT);
        HttpResponse loginResponse = ((MultipartBody)beforeAuthenticationCallback.apply(request)).asString();
        afterAuthenticationCallback.accept((HttpResponse<String>)loginResponse);
        this.checkResponseForErrorsAndThrowIfAny(loginResponse);
        String location = this.retrieveLocationFromResponse((HttpResponse<String>)loginResponse);
        return AuthenticationResponse.builder().code(UriUtils.extractParameterValue((String)location, (String)"code")).location(location).ssoToken(UriUtils.extractParameterValueOptional((String)location, (String)"ssotoken").orElse(null)).build();
    }

    private void checkResponseForErrorsAndThrowIfAny(HttpResponse<?> loginResponse) {
        if (loginResponse.getStatus() == 302) {
            this.checkForForwardingExceptionAndThrowIfPresent(loginResponse.getHeaders().getFirst("Location"));
        }
        if (loginResponse.getStatus() / 100 == 4) {
            IdpErrorResponse response = new IdpErrorResponse();
            try {
                response = (IdpErrorResponse)loginResponse.mapError(IdpErrorResponse.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IdpClientRuntimeException("Unexpected Server-Response " + loginResponse.getStatus() + " " + (String)loginResponse.mapError(String.class), Optional.ofNullable(response.getCode()), Optional.ofNullable(response.getError()));
        }
    }

    private void checkForForwardingExceptionAndThrowIfPresent(String location) {
        UriUtils.extractParameterValueOptional((String)location, (String)"error").ifPresent(errorCode -> {
            Optional gematikCode = Optional.empty();
            Optional<IdpErrorType> errorDescription = Optional.empty();
            try {
                gematikCode = UriUtils.extractParameterValueOptional((String)location, (String)"gematik_code");
                errorDescription = UriUtils.extractParameterValueOptional((String)location, (String)"error_description").flatMap(IdpErrorType::fromSerializationValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IdpClientRuntimeException("Server-Error with message: " + UriUtils.extractParameterValueOptional((String)location, (String)"gematik_code").map(code -> code + ": ").orElse("") + UriUtils.extractParameterValueOptional((String)location, (String)"error_description").orElse(errorCode), gematikCode, errorDescription);
        });
    }

    public AuthenticationResponse performAuthenticationWithSsoToken(AuthenticationRequest authenticationRequest, UnaryOperator<MultipartBody> beforeAuthenticationCallback, Consumer<HttpResponse<String>> afterAuthenticationCallback) {
        MultipartBody request = (MultipartBody)((MultipartBody)Unirest.post((String)authenticationRequest.getAuthenticationEndpointUrl()).field("ssotoken", (Object)authenticationRequest.getSsoToken()).field("unsigned_challenge", authenticationRequest.getChallengeToken().getRawString()).contentType("application/x-www-form-urlencoded").header("User-Agent", USER_AGENT)).header("Accept", "application/json");
        HttpResponse loginResponse = ((MultipartBody)beforeAuthenticationCallback.apply(request)).asString();
        afterAuthenticationCallback.accept((HttpResponse<String>)loginResponse);
        this.checkResponseForErrorsAndThrowIfAny(loginResponse);
        String location = this.retrieveLocationFromResponse((HttpResponse<String>)loginResponse);
        return AuthenticationResponse.builder().code(UriUtils.extractParameterValue((String)location, (String)"code")).location(location).build();
    }

    public AuthenticationResponse performAuthenticationWithAltAuth(AuthenticationRequest authenticationRequest, UnaryOperator<MultipartBody> beforeAuthenticationMapper, Consumer<HttpResponse<String>> afterAuthenticationCallback) {
        MultipartBody request = (MultipartBody)((MultipartBody)Unirest.post((String)authenticationRequest.getAuthenticationEndpointUrl()).field("encrypted_signed_authentication_data", (Object)authenticationRequest.getEncryptedSignedAuthenticationData().getRawString()).contentType("application/x-www-form-urlencoded").header("User-Agent", USER_AGENT)).header("Accept", "application/json");
        HttpResponse loginResponse = ((MultipartBody)beforeAuthenticationMapper.apply(request)).asString();
        afterAuthenticationCallback.accept((HttpResponse<String>)loginResponse);
        this.checkResponseForErrorsAndThrowIfAny(loginResponse);
        String location = this.retrieveLocationFromResponse((HttpResponse<String>)loginResponse);
        return AuthenticationResponse.builder().code(UriUtils.extractParameterValue((String)location, (String)"code")).location(location).build();
    }

    private String retrieveLocationFromResponse(HttpResponse<String> response) {
        if (response.getStatus() != 302) {
            throw new IdpClientRuntimeException("Unexpected status code in response: " + response.getStatus());
        }
        return response.getHeaders().getFirst("Location");
    }

    public IdpTokenResult retrieveAccessToken(TokenRequest tokenRequest, UnaryOperator<MultipartBody> beforeTokenCallback, Consumer<HttpResponse<JsonNode>> afterTokenCallback) {
        byte[] tokenKeyBytes = Nonce.randomBytes((int)32);
        SecretKeySpec tokenKey = new SecretKeySpec(tokenKeyBytes, "AES");
        IdpJwe keyVerifierToken = this.buildKeyVerifierToken(tokenKeyBytes, tokenRequest.getCodeVerifier(), tokenRequest.getIdpEnc());
        MultipartBody request = (MultipartBody)((MultipartBody)Unirest.post((String)tokenRequest.getTokenUrl()).field("grant_type", (Object)"authorization_code").field("client_id", tokenRequest.getClientId()).field("code", tokenRequest.getCode()).field("key_verifier", keyVerifierToken.getRawString()).field("redirect_uri", tokenRequest.getRedirectUrl()).contentType("application/x-www-form-urlencoded").header("User-Agent", USER_AGENT)).header("Accept", "application/json");
        HttpResponse tokenResponse = ((MultipartBody)beforeTokenCallback.apply(request)).asJson();
        afterTokenCallback.accept((HttpResponse<JsonNode>)tokenResponse);
        this.checkResponseForErrorsAndThrowIfAny(tokenResponse);
        JSONObject jsonObject = ((JsonNode)tokenResponse.getBody()).getObject();
        String tokenType = ((JsonNode)tokenResponse.getBody()).getObject().getString("token_type");
        int expiresIn = ((JsonNode)tokenResponse.getBody()).getObject().getInt("expires_in");
        return IdpTokenResult.builder().tokenType(tokenType).expiresIn(expiresIn).accessToken(this.decryptToken(tokenKey, jsonObject.get("access_token"))).idToken(this.decryptToken(tokenKey, jsonObject.get("id_token"))).ssoToken(tokenRequest.getSsoToken() == null ? null : new IdpJwe(tokenRequest.getSsoToken())).build();
    }

    private JsonWebToken decryptToken(SecretKey tokenKey, Object tokenValue) {
        return Optional.ofNullable(tokenValue).filter(String.class::isInstance).map(String.class::cast).map(IdpJwe::new).map(jwe -> jwe.decryptNestedJwt((Key)tokenKey)).orElseThrow(() -> new IdpClientRuntimeException("Unable to extract Access-Token from response!"));
    }

    private IdpJwe buildKeyVerifierToken(byte[] tokenKeyBytes, String codeVerifier, PublicKey idpEnc) {
        JwtClaims claims = new JwtClaims();
        claims.setStringClaim(ClaimName.TOKEN_KEY.getJoseName(), new String(Base64.getUrlEncoder().withoutPadding().encode(tokenKeyBytes)));
        claims.setStringClaim(ClaimName.CODE_VERIFIER.getJoseName(), codeVerifier);
        return IdpJwe.createWithPayloadAndEncryptWithKey((String)claims.toJson(), (Key)idpEnc, (String)"JSON");
    }

    public DiscoveryDocumentResponse retrieveDiscoveryDocument(String discoveryDocumentUrl, Optional<String> fixedIdpHost) {
        HttpResponse discoveryDocumentResponse = ((GetRequest)Unirest.get((String)this.patchIdpHost(discoveryDocumentUrl, fixedIdpHost)).header("User-Agent", USER_AGENT)).asString();
        JsonWebToken discoveryDocument = new JsonWebToken((String)discoveryDocumentResponse.getBody());
        Supplier<IdpClientRuntimeException> exceptionSupplier = () -> new IdpClientRuntimeException("Incomplete Discovery Document encountered!");
        return DiscoveryDocumentResponse.builder().authorizationEndpoint(this.patchIdpHost((String)discoveryDocument.getStringBodyClaim(ClaimName.AUTHORIZATION_ENDPOINT).orElseThrow(exceptionSupplier), fixedIdpHost)).tokenEndpoint(this.patchIdpHost((String)discoveryDocument.getStringBodyClaim(ClaimName.TOKEN_ENDPOINT).orElseThrow(exceptionSupplier), fixedIdpHost)).ssoEndpoint(this.patchIdpHost((String)discoveryDocument.getStringBodyClaim(ClaimName.SSO_ENDPOINT).orElseThrow(exceptionSupplier), fixedIdpHost)).discSig((X509Certificate)discoveryDocument.getClientCertificateFromHeader().orElseThrow(exceptionSupplier)).pairingEndpoint(this.patchIdpHost(discoveryDocument.getStringBodyClaim(ClaimName.URI_PAIR).orElse("<IDP DOES NOT SUPPORT ALTERNATIVE AUTHENTICATION>"), fixedIdpHost)).authPairEndpoint(this.patchIdpHost(discoveryDocument.getStringBodyClaim(ClaimName.AUTH_PAIR_ENDPOINT).orElse("<IDP DOES NOT SUPPORT ALTERNATIVE AUTHENTICATION>"), fixedIdpHost)).idpSig(this.retrieveServerCertFromLocation(this.patchIdpHost((String)discoveryDocument.getStringBodyClaim(ClaimName.URI_PUK_IDP_SIG).orElseThrow(exceptionSupplier), fixedIdpHost))).idpEnc(this.retrieveServerPuKFromLocation(this.patchIdpHost((String)discoveryDocument.getStringBodyClaim(ClaimName.URI_PUK_IDP_ENC).orElseThrow(exceptionSupplier), fixedIdpHost))).build();
    }

    private String patchIdpHost(String unpatchedUrl, Optional<String> fixedIdpHost) {
        if (fixedIdpHost.isEmpty()) {
            return unpatchedUrl;
        }
        try {
            URI newHostUri = new URI(fixedIdpHost.get());
            URI unpatchedUri = new URI(unpatchedUrl);
            if (!fixedIdpHost.get().contains("://")) {
                String patchedUri = unpatchedUri.getScheme() + "://" + String.valueOf(newHostUri) + unpatchedUri.getRawPath();
                log.info("Patching URL. Original: {}, Patch: {}, Result: {}", new Object[]{unpatchedUrl, fixedIdpHost.get(), patchedUri});
                return patchedUri;
            }
            String patchedUri = Optional.ofNullable(newHostUri.getScheme()).orElse(unpatchedUri.getScheme()) + "://" + Optional.ofNullable(newHostUri.getRawAuthority()).orElse(unpatchedUri.getRawAuthority()) + Optional.ofNullable(newHostUri.getPath()).orElse("") + unpatchedUri.getPath();
            log.info("Patching URL. Original: {}, Patch: {}, Result: {}", new Object[]{unpatchedUrl, fixedIdpHost.get(), patchedUri});
            return patchedUri;
        }
        catch (Exception e) {
            throw new IdpClientRuntimeException("Error while patching with template '" + fixedIdpHost.get() + "'", e);
        }
    }

    private X509Certificate retrieveServerCertFromLocation(String uri) {
        HttpResponse pukAuthResponse = ((GetRequest)Unirest.get((String)uri).header("User-Agent", USER_AGENT)).asJson();
        JSONObject keyObject = ((JsonNode)pukAuthResponse.getBody()).getObject();
        String verificationCertificate = keyObject.getJSONArray(ClaimName.X509_CERTIFICATE_CHAIN.getJoseName()).getString(0);
        return CryptoLoader.getCertificateFromPem((byte[])Base64.getDecoder().decode(verificationCertificate));
    }

    private PublicKey retrieveServerPuKFromLocation(String uri) {
        HttpResponse pukAuthResponse = ((GetRequest)Unirest.get((String)uri).header("User-Agent", USER_AGENT)).asJson();
        JSONObject keyObject = ((JsonNode)pukAuthResponse.getBody()).getObject();
        try {
            return AuthenticatorClient.getPublicKey(keyObject);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new IdpClientRuntimeException("Unable to construct public key from given uri '" + uri + "', got " + e.getMessage());
        }
    }
}

