/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.client;

import de.gematik.idp.authentication.AuthenticationChallenge;
import de.gematik.idp.authentication.AuthenticationChallengeBuilder;
import de.gematik.idp.authentication.AuthenticationResponse;
import de.gematik.idp.authentication.AuthenticationResponseBuilder;
import de.gematik.idp.authentication.AuthenticationTokenBuilder;
import de.gematik.idp.authentication.IdpJwtProcessor;
import de.gematik.idp.authentication.JwtBuilder;
import de.gematik.idp.brainPoolExtension.BrainpoolCurves;
import de.gematik.idp.client.IIdpClient;
import de.gematik.idp.client.IdpTokenResult;
import de.gematik.idp.crypto.model.PkiIdentity;
import de.gematik.idp.data.ScopeConfiguration;
import de.gematik.idp.data.UserConsentConfiguration;
import de.gematik.idp.data.UserConsentDescriptionTexts;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.AccessTokenBuilder;
import de.gematik.idp.token.IdpJoseObject;
import de.gematik.idp.token.IdpJwe;
import de.gematik.idp.token.JsonWebToken;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class MockIdpClient
implements IIdpClient {
    private static final String SERVER_SUB_SALT = "someArbitrarySubSaltValue";
    private final PkiIdentity serverIdentity;
    private final String clientId;
    private final boolean produceTokensWithInvalidSignature;
    private final boolean produceOnlyExpiredTokens;
    private final String uriIdpServer;
    private final HashMap<String, String> scopeToAudienceUrls = new HashMap();
    private AccessTokenBuilder accessTokenBuilder;
    private AuthenticationResponseBuilder authenticationResponseBuilder;
    private AuthenticationTokenBuilder authenticationTokenBuilder;
    private AuthenticationChallengeBuilder authenticationChallengeBuilder;
    private IdpJwtProcessor jwtProcessor;
    private SecretKeySpec encryptionKey;

    @Override
    public IdpTokenResult login(PkiIdentity clientIdentity) {
        this.assertThatMockIdClientIsInitialized();
        return IdpTokenResult.builder().accessToken(this.buildAccessToken(clientIdentity)).validUntil(LocalDateTime.now().plusMinutes(5L)).build();
    }

    private JsonWebToken buildAccessToken(PkiIdentity clientIdentity) {
        AuthenticationChallenge challenge = this.authenticationChallengeBuilder.buildAuthenticationChallenge(this.clientId, "placeholderValue", "foo", "foo", "openid e-rezept", "nonceValue");
        AuthenticationResponse authenticationResponse = this.authenticationResponseBuilder.buildResponseForChallenge(challenge, clientIdentity);
        IdpJwe authenticationToken = this.authenticationTokenBuilder.buildAuthenticationToken(clientIdentity.getCertificate(), authenticationResponse.getSignedChallenge().getBodyClaim(ClaimName.NESTED_JWT).map(Objects::toString).map(JsonWebToken::new).map(IdpJoseObject::getBodyClaims).orElseThrow(), ZonedDateTime.now());
        JsonWebToken accessToken = this.accessTokenBuilder.buildAccessToken(authenticationToken.decryptNestedJwt((Key)this.encryptionKey));
        if (this.produceOnlyExpiredTokens) {
            accessToken = this.resignToken(accessToken.getHeaderClaims(), accessToken.getBodyClaims(), ZonedDateTime.now().minusMinutes(10L));
        }
        if (this.produceTokensWithInvalidSignature) {
            List<String> strings = Arrays.asList(accessToken.getRawString().split("\\."));
            strings.set(2, strings.get(2) + "mvK");
            accessToken = new JsonWebToken(strings.stream().collect(Collectors.joining(".")));
        }
        return accessToken;
    }

    public JsonWebToken resignToken(Map<String, Object> headerClaims, Map<String, Object> bodyClaims, ZonedDateTime expiresAt) {
        Objects.requireNonNull(this.jwtProcessor, "jwtProcessor is null. Did you call initialize()?");
        return this.jwtProcessor.buildJwt(new JwtBuilder().addAllBodyClaims(bodyClaims).addAllHeaderClaims(headerClaims).expiresAt(expiresAt));
    }

    @Override
    public MockIdpClient initialize() {
        this.scopeToAudienceUrls.put("e-rezept", "https://erp-test.zentral.erp.splitdns.ti-dienste.de/");
        this.scopeToAudienceUrls.put("pairing", "https://idp-pairing-test.zentral.idp.splitdns.ti-dienste.de");
        ScopeConfiguration openidConfig = ScopeConfiguration.builder().description("Zugriff auf den ID-Token.").build();
        ScopeConfiguration pairingConfig = ScopeConfiguration.builder().audienceUrl("https://idp-pairing-test.zentral.idp.splitdns.ti-dienste.de").description("Zugriff auf die Daten f\u00fcr die biometrischer Authentisierung.").claimsToBeIncluded(List.of(ClaimName.ID_NUMBER)).build();
        ScopeConfiguration erezeptConfig = ScopeConfiguration.builder().audienceUrl("https://erp-test.zentral.erp.splitdns.ti-dienste.de/").description("Zugriff auf die E-Rezept-Funktionalit\u00e4t.").claimsToBeIncluded(List.of(ClaimName.GIVEN_NAME, ClaimName.FAMILY_NAME, ClaimName.ORGANIZATION_NAME, ClaimName.PROFESSION_OID, ClaimName.ID_NUMBER)).build();
        Optional<String> keyId = Optional.of("puk_idp_sig");
        this.jwtProcessor = new IdpJwtProcessor(this.serverIdentity, keyId);
        this.accessTokenBuilder = new AccessTokenBuilder(this.jwtProcessor, this.uriIdpServer, SERVER_SUB_SALT, this.scopeToAudienceUrls);
        this.authenticationChallengeBuilder = AuthenticationChallengeBuilder.builder().serverSigner(new IdpJwtProcessor(this.serverIdentity, keyId)).uriIdpServer(this.uriIdpServer).userConsentConfiguration(UserConsentConfiguration.builder().descriptionTexts(UserConsentDescriptionTexts.builder().claims(Collections.emptyMap()).build()).build()).scopesConfiguration(Map.of("openid", openidConfig, "erezept", erezeptConfig, "pairing", pairingConfig)).build();
        this.authenticationResponseBuilder = new AuthenticationResponseBuilder();
        this.encryptionKey = new SecretKeySpec(DigestUtils.sha256((String)"fdsa"), "AES");
        this.authenticationTokenBuilder = AuthenticationTokenBuilder.builder().jwtProcessor(this.jwtProcessor).encryptionKey((Key)this.encryptionKey).build();
        return this;
    }

    private void assertThatMockIdClientIsInitialized() {
        Objects.requireNonNull(this.accessTokenBuilder, "accessTokenBuilder is null. Did you call initialize()?");
        Objects.requireNonNull(this.authenticationTokenBuilder, "authenticationTokenBuilder is null. Did you call initialize()?");
        Objects.requireNonNull(this.clientId, "clientId is null. You have to set it!");
    }

    @Generated
    private static String $default$uriIdpServer() {
        return "https://idp.dev.gematik.solutions";
    }

    @Generated
    public static MockIdpClientBuilder builder() {
        return new MockIdpClientBuilder();
    }

    @Generated
    public MockIdpClientBuilder toBuilder() {
        return new MockIdpClientBuilder().serverIdentity(this.serverIdentity).clientId(this.clientId).produceTokensWithInvalidSignature(this.produceTokensWithInvalidSignature).produceOnlyExpiredTokens(this.produceOnlyExpiredTokens).uriIdpServer(this.uriIdpServer).accessTokenBuilder(this.accessTokenBuilder).authenticationResponseBuilder(this.authenticationResponseBuilder).authenticationTokenBuilder(this.authenticationTokenBuilder).authenticationChallengeBuilder(this.authenticationChallengeBuilder).jwtProcessor(this.jwtProcessor).encryptionKey(this.encryptionKey);
    }

    @Generated
    public PkiIdentity getServerIdentity() {
        return this.serverIdentity;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public boolean isProduceTokensWithInvalidSignature() {
        return this.produceTokensWithInvalidSignature;
    }

    @Generated
    public boolean isProduceOnlyExpiredTokens() {
        return this.produceOnlyExpiredTokens;
    }

    @Generated
    public String getUriIdpServer() {
        return this.uriIdpServer;
    }

    @Generated
    public HashMap<String, String> getScopeToAudienceUrls() {
        return this.scopeToAudienceUrls;
    }

    @Generated
    public AccessTokenBuilder getAccessTokenBuilder() {
        return this.accessTokenBuilder;
    }

    @Generated
    public AuthenticationResponseBuilder getAuthenticationResponseBuilder() {
        return this.authenticationResponseBuilder;
    }

    @Generated
    public AuthenticationTokenBuilder getAuthenticationTokenBuilder() {
        return this.authenticationTokenBuilder;
    }

    @Generated
    public AuthenticationChallengeBuilder getAuthenticationChallengeBuilder() {
        return this.authenticationChallengeBuilder;
    }

    @Generated
    public IdpJwtProcessor getJwtProcessor() {
        return this.jwtProcessor;
    }

    @Generated
    public SecretKeySpec getEncryptionKey() {
        return this.encryptionKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MockIdpClient)) {
            return false;
        }
        MockIdpClient other = (MockIdpClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isProduceTokensWithInvalidSignature() != other.isProduceTokensWithInvalidSignature()) {
            return false;
        }
        if (this.isProduceOnlyExpiredTokens() != other.isProduceOnlyExpiredTokens()) {
            return false;
        }
        PkiIdentity this$serverIdentity = this.getServerIdentity();
        PkiIdentity other$serverIdentity = other.getServerIdentity();
        if (this$serverIdentity == null ? other$serverIdentity != null : !this$serverIdentity.equals(other$serverIdentity)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$uriIdpServer = this.getUriIdpServer();
        String other$uriIdpServer = other.getUriIdpServer();
        if (this$uriIdpServer == null ? other$uriIdpServer != null : !this$uriIdpServer.equals(other$uriIdpServer)) {
            return false;
        }
        HashMap<String, String> this$scopeToAudienceUrls = this.getScopeToAudienceUrls();
        HashMap<String, String> other$scopeToAudienceUrls = other.getScopeToAudienceUrls();
        if (this$scopeToAudienceUrls == null ? other$scopeToAudienceUrls != null : !((Object)this$scopeToAudienceUrls).equals(other$scopeToAudienceUrls)) {
            return false;
        }
        AccessTokenBuilder this$accessTokenBuilder = this.getAccessTokenBuilder();
        AccessTokenBuilder other$accessTokenBuilder = other.getAccessTokenBuilder();
        if (this$accessTokenBuilder == null ? other$accessTokenBuilder != null : !this$accessTokenBuilder.equals(other$accessTokenBuilder)) {
            return false;
        }
        AuthenticationResponseBuilder this$authenticationResponseBuilder = this.getAuthenticationResponseBuilder();
        AuthenticationResponseBuilder other$authenticationResponseBuilder = other.getAuthenticationResponseBuilder();
        if (this$authenticationResponseBuilder == null ? other$authenticationResponseBuilder != null : !this$authenticationResponseBuilder.equals(other$authenticationResponseBuilder)) {
            return false;
        }
        AuthenticationTokenBuilder this$authenticationTokenBuilder = this.getAuthenticationTokenBuilder();
        AuthenticationTokenBuilder other$authenticationTokenBuilder = other.getAuthenticationTokenBuilder();
        if (this$authenticationTokenBuilder == null ? other$authenticationTokenBuilder != null : !this$authenticationTokenBuilder.equals(other$authenticationTokenBuilder)) {
            return false;
        }
        AuthenticationChallengeBuilder this$authenticationChallengeBuilder = this.getAuthenticationChallengeBuilder();
        AuthenticationChallengeBuilder other$authenticationChallengeBuilder = other.getAuthenticationChallengeBuilder();
        if (this$authenticationChallengeBuilder == null ? other$authenticationChallengeBuilder != null : !this$authenticationChallengeBuilder.equals(other$authenticationChallengeBuilder)) {
            return false;
        }
        IdpJwtProcessor this$jwtProcessor = this.getJwtProcessor();
        IdpJwtProcessor other$jwtProcessor = other.getJwtProcessor();
        if (this$jwtProcessor == null ? other$jwtProcessor != null : !this$jwtProcessor.equals(other$jwtProcessor)) {
            return false;
        }
        SecretKeySpec this$encryptionKey = this.getEncryptionKey();
        SecretKeySpec other$encryptionKey = other.getEncryptionKey();
        return !(this$encryptionKey == null ? other$encryptionKey != null : !((Object)this$encryptionKey).equals(other$encryptionKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MockIdpClient;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isProduceTokensWithInvalidSignature() ? 79 : 97);
        result = result * 59 + (this.isProduceOnlyExpiredTokens() ? 79 : 97);
        PkiIdentity $serverIdentity = this.getServerIdentity();
        result = result * 59 + ($serverIdentity == null ? 43 : $serverIdentity.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $uriIdpServer = this.getUriIdpServer();
        result = result * 59 + ($uriIdpServer == null ? 43 : $uriIdpServer.hashCode());
        HashMap<String, String> $scopeToAudienceUrls = this.getScopeToAudienceUrls();
        result = result * 59 + ($scopeToAudienceUrls == null ? 43 : ((Object)$scopeToAudienceUrls).hashCode());
        AccessTokenBuilder $accessTokenBuilder = this.getAccessTokenBuilder();
        result = result * 59 + ($accessTokenBuilder == null ? 43 : $accessTokenBuilder.hashCode());
        AuthenticationResponseBuilder $authenticationResponseBuilder = this.getAuthenticationResponseBuilder();
        result = result * 59 + ($authenticationResponseBuilder == null ? 43 : $authenticationResponseBuilder.hashCode());
        AuthenticationTokenBuilder $authenticationTokenBuilder = this.getAuthenticationTokenBuilder();
        result = result * 59 + ($authenticationTokenBuilder == null ? 43 : $authenticationTokenBuilder.hashCode());
        AuthenticationChallengeBuilder $authenticationChallengeBuilder = this.getAuthenticationChallengeBuilder();
        result = result * 59 + ($authenticationChallengeBuilder == null ? 43 : $authenticationChallengeBuilder.hashCode());
        IdpJwtProcessor $jwtProcessor = this.getJwtProcessor();
        result = result * 59 + ($jwtProcessor == null ? 43 : $jwtProcessor.hashCode());
        SecretKeySpec $encryptionKey = this.getEncryptionKey();
        result = result * 59 + ($encryptionKey == null ? 43 : ((Object)$encryptionKey).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MockIdpClient(serverIdentity=" + this.getServerIdentity() + ", clientId=" + this.getClientId() + ", produceTokensWithInvalidSignature=" + this.isProduceTokensWithInvalidSignature() + ", produceOnlyExpiredTokens=" + this.isProduceOnlyExpiredTokens() + ", uriIdpServer=" + this.getUriIdpServer() + ", scopeToAudienceUrls=" + this.getScopeToAudienceUrls() + ", accessTokenBuilder=" + this.getAccessTokenBuilder() + ", authenticationResponseBuilder=" + this.getAuthenticationResponseBuilder() + ", authenticationTokenBuilder=" + this.getAuthenticationTokenBuilder() + ", authenticationChallengeBuilder=" + this.getAuthenticationChallengeBuilder() + ", jwtProcessor=" + this.getJwtProcessor() + ", encryptionKey=" + this.getEncryptionKey() + ")";
    }

    @Generated
    public MockIdpClient(PkiIdentity serverIdentity, String clientId, boolean produceTokensWithInvalidSignature, boolean produceOnlyExpiredTokens, String uriIdpServer, AccessTokenBuilder accessTokenBuilder, AuthenticationResponseBuilder authenticationResponseBuilder, AuthenticationTokenBuilder authenticationTokenBuilder, AuthenticationChallengeBuilder authenticationChallengeBuilder, IdpJwtProcessor jwtProcessor, SecretKeySpec encryptionKey) {
        this.serverIdentity = serverIdentity;
        this.clientId = clientId;
        this.produceTokensWithInvalidSignature = produceTokensWithInvalidSignature;
        this.produceOnlyExpiredTokens = produceOnlyExpiredTokens;
        this.uriIdpServer = uriIdpServer;
        this.accessTokenBuilder = accessTokenBuilder;
        this.authenticationResponseBuilder = authenticationResponseBuilder;
        this.authenticationTokenBuilder = authenticationTokenBuilder;
        this.authenticationChallengeBuilder = authenticationChallengeBuilder;
        this.jwtProcessor = jwtProcessor;
        this.encryptionKey = encryptionKey;
    }

    static {
        Security.removeProvider("BC");
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        BrainpoolCurves.init();
    }

    @Generated
    public static class MockIdpClientBuilder {
        @Generated
        private PkiIdentity serverIdentity;
        @Generated
        private String clientId;
        @Generated
        private boolean produceTokensWithInvalidSignature;
        @Generated
        private boolean produceOnlyExpiredTokens;
        @Generated
        private boolean uriIdpServer$set;
        @Generated
        private String uriIdpServer$value;
        @Generated
        private AccessTokenBuilder accessTokenBuilder;
        @Generated
        private AuthenticationResponseBuilder authenticationResponseBuilder;
        @Generated
        private AuthenticationTokenBuilder authenticationTokenBuilder;
        @Generated
        private AuthenticationChallengeBuilder authenticationChallengeBuilder;
        @Generated
        private IdpJwtProcessor jwtProcessor;
        @Generated
        private SecretKeySpec encryptionKey;

        @Generated
        MockIdpClientBuilder() {
        }

        @Generated
        public MockIdpClientBuilder serverIdentity(PkiIdentity serverIdentity) {
            this.serverIdentity = serverIdentity;
            return this;
        }

        @Generated
        public MockIdpClientBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Generated
        public MockIdpClientBuilder produceTokensWithInvalidSignature(boolean produceTokensWithInvalidSignature) {
            this.produceTokensWithInvalidSignature = produceTokensWithInvalidSignature;
            return this;
        }

        @Generated
        public MockIdpClientBuilder produceOnlyExpiredTokens(boolean produceOnlyExpiredTokens) {
            this.produceOnlyExpiredTokens = produceOnlyExpiredTokens;
            return this;
        }

        @Generated
        public MockIdpClientBuilder uriIdpServer(String uriIdpServer) {
            this.uriIdpServer$value = uriIdpServer;
            this.uriIdpServer$set = true;
            return this;
        }

        @Generated
        public MockIdpClientBuilder accessTokenBuilder(AccessTokenBuilder accessTokenBuilder) {
            this.accessTokenBuilder = accessTokenBuilder;
            return this;
        }

        @Generated
        public MockIdpClientBuilder authenticationResponseBuilder(AuthenticationResponseBuilder authenticationResponseBuilder) {
            this.authenticationResponseBuilder = authenticationResponseBuilder;
            return this;
        }

        @Generated
        public MockIdpClientBuilder authenticationTokenBuilder(AuthenticationTokenBuilder authenticationTokenBuilder) {
            this.authenticationTokenBuilder = authenticationTokenBuilder;
            return this;
        }

        @Generated
        public MockIdpClientBuilder authenticationChallengeBuilder(AuthenticationChallengeBuilder authenticationChallengeBuilder) {
            this.authenticationChallengeBuilder = authenticationChallengeBuilder;
            return this;
        }

        @Generated
        public MockIdpClientBuilder jwtProcessor(IdpJwtProcessor jwtProcessor) {
            this.jwtProcessor = jwtProcessor;
            return this;
        }

        @Generated
        public MockIdpClientBuilder encryptionKey(SecretKeySpec encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        @Generated
        public MockIdpClient build() {
            String uriIdpServer$value = this.uriIdpServer$value;
            if (!this.uriIdpServer$set) {
                uriIdpServer$value = MockIdpClient.$default$uriIdpServer();
            }
            return new MockIdpClient(this.serverIdentity, this.clientId, this.produceTokensWithInvalidSignature, this.produceOnlyExpiredTokens, uriIdpServer$value, this.accessTokenBuilder, this.authenticationResponseBuilder, this.authenticationTokenBuilder, this.authenticationChallengeBuilder, this.jwtProcessor, this.encryptionKey);
        }

        @Generated
        public String toString() {
            return "MockIdpClient.MockIdpClientBuilder(serverIdentity=" + this.serverIdentity + ", clientId=" + this.clientId + ", produceTokensWithInvalidSignature=" + this.produceTokensWithInvalidSignature + ", produceOnlyExpiredTokens=" + this.produceOnlyExpiredTokens + ", uriIdpServer$value=" + this.uriIdpServer$value + ", accessTokenBuilder=" + this.accessTokenBuilder + ", authenticationResponseBuilder=" + this.authenticationResponseBuilder + ", authenticationTokenBuilder=" + this.authenticationTokenBuilder + ", authenticationChallengeBuilder=" + this.authenticationChallengeBuilder + ", jwtProcessor=" + this.jwtProcessor + ", encryptionKey=" + this.encryptionKey + ")";
        }
    }
}

