/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.client;

import de.gematik.idp.authentication.AuthenticationChallenge;
import de.gematik.idp.authentication.JwtBuilder;
import de.gematik.idp.authentication.UriUtils;
import de.gematik.idp.brainPoolExtension.BrainpoolAlgorithmSuiteIdentifiers;
import de.gematik.idp.brainPoolExtension.BrainpoolCurves;
import de.gematik.idp.client.AuthenticatorClient;
import de.gematik.idp.client.IIdpClient;
import de.gematik.idp.client.IdpClientRuntimeException;
import de.gematik.idp.client.IdpTokenResult;
import de.gematik.idp.client.data.AuthenticationRequest;
import de.gematik.idp.client.data.AuthenticationResponse;
import de.gematik.idp.client.data.AuthorizationRequest;
import de.gematik.idp.client.data.AuthorizationResponse;
import de.gematik.idp.client.data.DiscoveryDocumentResponse;
import de.gematik.idp.client.data.RegistrationData;
import de.gematik.idp.client.data.TokenRequest;
import de.gematik.idp.crypto.EcSignerUtility;
import de.gematik.idp.crypto.KeyAnalysis;
import de.gematik.idp.crypto.Nonce;
import de.gematik.idp.crypto.RsaSignerUtility;
import de.gematik.idp.crypto.model.PkiIdentity;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.field.ClientUtilities;
import de.gematik.idp.field.CodeChallengeMethod;
import de.gematik.idp.token.IdpJwe;
import de.gematik.idp.token.JsonWebToken;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.MultipartBody;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jose4j.jws.EcdsaUsingShaAlgorithm;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpClient
implements IIdpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdpClient.class);
    private static final Consumer NOOP_CONSUMER = o -> {};
    private final String clientId;
    private final String redirectUrl;
    private final String discoveryDocumentUrl;
    private final boolean shouldVerifyState;
    private Set<String> scopes;
    private UnaryOperator<GetRequest> beforeAuthorizationMapper;
    private Consumer<HttpResponse<AuthenticationChallenge>> afterAuthorizationCallback;
    private UnaryOperator<MultipartBody> beforeAuthenticationMapper;
    private Consumer<HttpResponse<String>> afterAuthenticationCallback;
    private UnaryOperator<MultipartBody> beforeTokenMapper;
    private Consumer<HttpResponse<JsonNode>> afterTokenCallback;
    private AuthenticatorClient authenticatorClient;
    private CodeChallengeMethod codeChallengeMethod;
    private UnaryOperator<AuthorizationResponse> authorizationResponseMapper;
    private UnaryOperator<AuthenticationResponse> authenticationResponseMapper;
    private String fixedIdpHost;
    private DiscoveryDocumentResponse discoveryDocumentResponse;

    private String signServerChallenge(String challengeToSign, X509Certificate certificate, UnaryOperator<byte[]> contentSigner) {
        JwtClaims claims = new JwtClaims();
        claims.setClaim(ClaimName.NESTED_JWT.getJoseName(), (Object)challengeToSign);
        JsonWebSignature jsonWebSignature = new JsonWebSignature();
        jsonWebSignature.setPayload(claims.toJson());
        jsonWebSignature.setHeader("typ", "JWT");
        jsonWebSignature.setHeader("cty", "NJWT");
        jsonWebSignature.setCertificateChainHeaderValue(new X509Certificate[]{certificate});
        if (KeyAnalysis.isEcKey((PublicKey)certificate.getPublicKey())) {
            jsonWebSignature.setAlgorithmHeaderValue(BrainpoolAlgorithmSuiteIdentifiers.BRAINPOOL256_USING_SHA256);
        } else {
            jsonWebSignature.setAlgorithmHeaderValue("PS256");
        }
        String signedJwt = jsonWebSignature.getHeaders().getEncodedHeader() + "." + jsonWebSignature.getEncodedPayload() + "." + Base64.getUrlEncoder().withoutPadding().encodeToString(this.getSignatureBytes(contentSigner, jsonWebSignature, sigData -> {
            if (certificate.getPublicKey() instanceof RSAPublicKey) {
                return sigData;
            }
            try {
                return EcdsaUsingShaAlgorithm.convertDerToConcatenated((byte[])sigData, (int)64);
            }
            catch (IOException e) {
                throw new IdpClientRuntimeException(e);
            }
        }));
        return new JsonWebToken(signedJwt).encrypt((Key)this.discoveryDocumentResponse.getIdpEnc()).getRawString();
    }

    private byte[] getSignatureBytes(UnaryOperator<byte[]> contentSigner, JsonWebSignature jsonWebSignature, UnaryOperator<byte[]> signatureStripper) {
        return (byte[])signatureStripper.apply((byte[])contentSigner.apply((jsonWebSignature.getHeaders().getEncodedHeader() + "." + jsonWebSignature.getEncodedPayload()).getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public IdpTokenResult login(PkiIdentity idpIdentity) {
        this.assertThatIdpIdentityIsValid(idpIdentity);
        return this.login(idpIdentity.getCertificate(), tbsData -> {
            if (idpIdentity.getPrivateKey() instanceof RSAPrivateKey) {
                return RsaSignerUtility.createRsaSignature((byte[])tbsData, (PrivateKey)idpIdentity.getPrivateKey());
            }
            return EcSignerUtility.createEcSignature((byte[])tbsData, (PrivateKey)idpIdentity.getPrivateKey());
        });
    }

    public IdpTokenResult login(X509Certificate certificate, UnaryOperator<byte[]> contentSigner) {
        String stringInTokenUrl;
        this.assertThatClientIsInitialized();
        String codeVerifier = ClientUtilities.generateCodeVerifier();
        String nonce = Nonce.getNonceAsBase64UrlEncodedString((int)24);
        String state = Nonce.getNonceAsBase64UrlEncodedString((int)24);
        LOGGER.debug("Performing Authorization with remote-URL '{}'", (Object)this.discoveryDocumentResponse.getAuthorizationEndpoint());
        AuthorizationResponse authorizationResponse = (AuthorizationResponse)this.authorizationResponseMapper.apply(this.authenticatorClient.doAuthorizationRequest(AuthorizationRequest.builder().clientId(this.clientId).link(this.discoveryDocumentResponse.getAuthorizationEndpoint()).codeChallenge(ClientUtilities.generateCodeChallenge((String)codeVerifier)).codeChallengeMethod(this.codeChallengeMethod).redirectUri(this.redirectUrl).state(state).scopes(this.scopes).nonce(nonce).build(), this.beforeAuthorizationMapper, this.afterAuthorizationCallback));
        LOGGER.debug("Performing Authentication with remote-URL '{}'", (Object)this.discoveryDocumentResponse.getAuthorizationEndpoint());
        AuthenticationResponse authenticationResponse = (AuthenticationResponse)this.authenticationResponseMapper.apply(this.authenticatorClient.performAuthentication(AuthenticationRequest.builder().authenticationEndpointUrl(this.discoveryDocumentResponse.getAuthorizationEndpoint()).signedChallenge(new IdpJwe(this.signServerChallenge(authorizationResponse.getAuthenticationChallenge().getChallenge().getRawString(), certificate, contentSigner))).build(), this.beforeAuthenticationMapper, this.afterAuthenticationCallback));
        if (this.shouldVerifyState && !state.equals(stringInTokenUrl = UriUtils.extractParameterValue((String)authenticationResponse.getLocation(), (String)"state"))) {
            throw new IdpClientRuntimeException("state-parameter unexpected changed");
        }
        LOGGER.debug("Performing getToken with remote-URL '{}'", (Object)this.discoveryDocumentResponse.getTokenEndpoint());
        return this.authenticatorClient.retrieveAccessToken(TokenRequest.builder().tokenUrl(this.discoveryDocumentResponse.getTokenEndpoint()).clientId(this.clientId).code(authenticationResponse.getCode()).ssoToken(authenticationResponse.getSsoToken()).redirectUrl(this.redirectUrl).codeVerifier(codeVerifier).idpEnc(this.discoveryDocumentResponse.getIdpEnc()).build(), this.beforeTokenMapper, this.afterTokenCallback);
    }

    public IdpTokenResult loginWithSsoToken(IdpJwe ssoToken) {
        String stringInTokenUrl;
        this.assertThatClientIsInitialized();
        String codeVerifier = ClientUtilities.generateCodeVerifier();
        String nonce = Nonce.getNonceAsBase64UrlEncodedString((int)24);
        String state = Nonce.getNonceAsBase64UrlEncodedString((int)24);
        LOGGER.debug("Performing Authorization with remote-URL '{}'", (Object)this.discoveryDocumentResponse.getAuthorizationEndpoint());
        AuthorizationResponse authorizationResponse = (AuthorizationResponse)this.authorizationResponseMapper.apply(this.authenticatorClient.doAuthorizationRequest(AuthorizationRequest.builder().clientId(this.clientId).link(this.discoveryDocumentResponse.getAuthorizationEndpoint()).codeChallenge(ClientUtilities.generateCodeChallenge((String)codeVerifier)).codeChallengeMethod(this.codeChallengeMethod).redirectUri(this.redirectUrl).state(state).scopes(this.scopes).nonce(nonce).build(), this.beforeAuthorizationMapper, this.afterAuthorizationCallback));
        String ssoChallengeEndpoint = this.discoveryDocumentResponse.getSsoEndpoint();
        LOGGER.debug("Performing Sso-Authentication with remote-URL '{}'", (Object)ssoChallengeEndpoint);
        AuthenticationResponse authenticationResponse = (AuthenticationResponse)this.authenticationResponseMapper.apply(this.authenticatorClient.performAuthenticationWithSsoToken(AuthenticationRequest.builder().authenticationEndpointUrl(ssoChallengeEndpoint).ssoToken(ssoToken.getRawString()).challengeToken(authorizationResponse.getAuthenticationChallenge().getChallenge()).build(), this.beforeAuthenticationMapper, this.afterAuthenticationCallback));
        if (this.shouldVerifyState && !state.equals(stringInTokenUrl = UriUtils.extractParameterValue((String)authenticationResponse.getLocation(), (String)"state"))) {
            throw new IdpClientRuntimeException("state-parameter unexpected changed");
        }
        LOGGER.debug("Performing getToken with remote-URL '{}'", (Object)this.discoveryDocumentResponse.getTokenEndpoint());
        return this.authenticatorClient.retrieveAccessToken(TokenRequest.builder().tokenUrl(this.discoveryDocumentResponse.getTokenEndpoint()).clientId(this.clientId).code(authenticationResponse.getCode()).ssoToken(ssoToken.getRawString()).redirectUrl(this.redirectUrl).codeVerifier(codeVerifier).idpEnc(this.discoveryDocumentResponse.getIdpEnc()).build(), this.beforeTokenMapper, this.afterTokenCallback);
    }

    public IdpTokenResult loginWithAltAuth(RegistrationData registrationData, PrivateKey privateKey) {
        String stringInTokenUrl;
        this.assertThatClientIsInitialized();
        String codeVerifier = ClientUtilities.generateCodeVerifier();
        String nonce = Nonce.getNonceAsBase64UrlEncodedString((int)24);
        String state = Nonce.getNonceAsBase64UrlEncodedString((int)24);
        LOGGER.debug("Performing Authorization with remote-URL '{}'", (Object)this.discoveryDocumentResponse.getAuthorizationEndpoint());
        AuthorizationResponse authorizationResponse = (AuthorizationResponse)this.authorizationResponseMapper.apply(this.authenticatorClient.doAuthorizationRequest(AuthorizationRequest.builder().clientId(this.clientId).link(this.discoveryDocumentResponse.getAuthorizationEndpoint()).codeChallenge(ClientUtilities.generateCodeChallenge((String)codeVerifier)).codeChallengeMethod(this.codeChallengeMethod).redirectUri(this.redirectUrl).state(state).scopes(this.scopes).nonce(nonce).build(), this.beforeAuthorizationMapper, this.afterAuthorizationCallback));
        JsonWebToken signedPairingData = new JsonWebToken(registrationData.getSignedPairingData());
        JsonWebToken signedAuthenticationData = new JwtBuilder().addBodyClaim(ClaimName.EXPIRES_AT, authorizationResponse.getAuthenticationChallenge().getChallenge().getBodyClaim(ClaimName.EXPIRES_AT).orElseThrow()).addBodyClaim(ClaimName.CHALLENGE_TOKEN, (Object)authorizationResponse.getAuthenticationChallenge().getChallenge().getRawString()).addBodyClaim(ClaimName.AUTHENTICATION_CERTIFICATE, (Object)registrationData.getAuthCert()).addBodyClaim(ClaimName.AUTHENTICATION_DATA_VERSION, (Object)"1.0").addBodyClaim(ClaimName.KEY_IDENTIFIER, signedPairingData.getBodyClaim(ClaimName.KEY_IDENTIFIER).orElseThrow()).addBodyClaim(ClaimName.DEVICE_INFORMATION, Map.of("name", registrationData.getDeviceInformation().getName(), "device_information_data_version", registrationData.getDeviceInformation().getDeviceInformationDataVersion(), "device_type", Map.of("device_type_data_version", registrationData.getDeviceInformation().getDeviceType().getDeviceTypeDataVersion(), "product", registrationData.getDeviceInformation().getDeviceType().getProduct(), "model", registrationData.getDeviceInformation().getDeviceType().getModel(), "os", registrationData.getDeviceInformation().getDeviceType().getOs(), "os_version", registrationData.getDeviceInformation().getDeviceType().getOsVersion(), "manufacturer", registrationData.getDeviceInformation().getDeviceType().getManufacturer()))).addBodyClaim(ClaimName.AUTHENTICATION_METHODS_REFERENCE, List.of("mfa", "hwk", "face")).setSignerKey((Key)privateKey).buildJwt();
        LOGGER.debug("Performing Authentication with remote-URL '{}'", (Object)this.discoveryDocumentResponse.getAuthorizationEndpoint());
        AuthenticationResponse authenticationResponse = (AuthenticationResponse)this.authenticationResponseMapper.apply(this.authenticatorClient.performAuthenticationWithAltAuth(AuthenticationRequest.builder().authenticationEndpointUrl(this.discoveryDocumentResponse.getAuthPairEndpoint()).encryptedSignedAuthenticationData(signedAuthenticationData.encrypt((Key)this.discoveryDocumentResponse.getIdpEnc())).build(), this.beforeAuthenticationMapper, this.afterAuthenticationCallback));
        if (this.shouldVerifyState && !state.equals(stringInTokenUrl = UriUtils.extractParameterValue((String)authenticationResponse.getLocation(), (String)"state"))) {
            throw new IdpClientRuntimeException("state-parameter unexpected changed");
        }
        LOGGER.debug("Performing getToken with remote-URL '{}'", (Object)this.discoveryDocumentResponse.getTokenEndpoint());
        return this.authenticatorClient.retrieveAccessToken(TokenRequest.builder().tokenUrl(this.discoveryDocumentResponse.getTokenEndpoint()).clientId(this.clientId).code(authenticationResponse.getCode()).ssoToken(authenticationResponse.getSsoToken()).redirectUrl(this.redirectUrl).codeVerifier(codeVerifier).idpEnc(this.discoveryDocumentResponse.getIdpEnc()).build(), this.beforeTokenMapper, this.afterTokenCallback);
    }

    private void assertThatIdpIdentityIsValid(PkiIdentity idpIdentity) {
        Objects.requireNonNull(idpIdentity);
        Objects.requireNonNull(idpIdentity.getCertificate());
        Objects.requireNonNull(idpIdentity.getPrivateKey());
    }

    private void assertThatClientIsInitialized() {
        LOGGER.debug("Verifying IDP-Client initialization...");
        if (this.discoveryDocumentResponse == null || StringUtils.isEmpty((CharSequence)this.discoveryDocumentResponse.getAuthorizationEndpoint()) || StringUtils.isEmpty((CharSequence)this.discoveryDocumentResponse.getTokenEndpoint())) {
            throw new IdpClientRuntimeException("IDP-Client not initialized correctly! Call .initialize() before performing an actual operation.");
        }
    }

    @Override
    public IdpClient initialize() {
        LOGGER.info("Initializing using url '{}'", (Object)this.discoveryDocumentUrl);
        this.discoveryDocumentResponse = this.authenticatorClient.retrieveDiscoveryDocument(this.discoveryDocumentUrl, Optional.ofNullable(this.fixedIdpHost));
        return this;
    }

    public void verifyAuthTokenToken(IdpTokenResult authToken) {
        authToken.getAccessToken().verify(this.discoveryDocumentResponse.getIdpSig().getPublicKey());
    }

    public void setBeforeAuthorizationCallback(Consumer<GetRequest> callback) {
        this.beforeAuthorizationMapper = this.toNoopIdentity(callback);
    }

    public void setBeforeAuthenticationCallback(Consumer<MultipartBody> callback) {
        this.beforeAuthenticationMapper = this.toNoopIdentity(callback);
    }

    public void setBeforeTokenCallback(Consumer<MultipartBody> callback) {
        this.beforeTokenMapper = this.toNoopIdentity(callback);
    }

    public <T> UnaryOperator<T> toNoopIdentity(Consumer<T> callback) {
        return t -> {
            callback.accept(t);
            return t;
        };
    }

    @Generated
    private static Set<String> $default$scopes() {
        return Set.of("openid", "e-rezept");
    }

    @Generated
    private static UnaryOperator<GetRequest> $default$beforeAuthorizationMapper() {
        return UnaryOperator.identity();
    }

    @Generated
    private static Consumer<HttpResponse<AuthenticationChallenge>> $default$afterAuthorizationCallback() {
        return NOOP_CONSUMER;
    }

    @Generated
    private static UnaryOperator<MultipartBody> $default$beforeAuthenticationMapper() {
        return UnaryOperator.identity();
    }

    @Generated
    private static Consumer<HttpResponse<String>> $default$afterAuthenticationCallback() {
        return NOOP_CONSUMER;
    }

    @Generated
    private static UnaryOperator<MultipartBody> $default$beforeTokenMapper() {
        return UnaryOperator.identity();
    }

    @Generated
    private static Consumer<HttpResponse<JsonNode>> $default$afterTokenCallback() {
        return NOOP_CONSUMER;
    }

    @Generated
    private static AuthenticatorClient $default$authenticatorClient() {
        return new AuthenticatorClient();
    }

    @Generated
    private static CodeChallengeMethod $default$codeChallengeMethod() {
        return CodeChallengeMethod.S256;
    }

    @Generated
    private static UnaryOperator<AuthorizationResponse> $default$authorizationResponseMapper() {
        return UnaryOperator.identity();
    }

    @Generated
    private static UnaryOperator<AuthenticationResponse> $default$authenticationResponseMapper() {
        return UnaryOperator.identity();
    }

    @Generated
    public static IdpClientBuilder builder() {
        return new IdpClientBuilder();
    }

    @Generated
    public IdpClientBuilder toBuilder() {
        return new IdpClientBuilder().clientId(this.clientId).redirectUrl(this.redirectUrl).discoveryDocumentUrl(this.discoveryDocumentUrl).shouldVerifyState(this.shouldVerifyState).scopes(this.scopes).beforeAuthorizationMapper(this.beforeAuthorizationMapper).afterAuthorizationCallback(this.afterAuthorizationCallback).beforeAuthenticationMapper(this.beforeAuthenticationMapper).afterAuthenticationCallback(this.afterAuthenticationCallback).beforeTokenMapper(this.beforeTokenMapper).afterTokenCallback(this.afterTokenCallback).authenticatorClient(this.authenticatorClient).codeChallengeMethod(this.codeChallengeMethod).authorizationResponseMapper(this.authorizationResponseMapper).authenticationResponseMapper(this.authenticationResponseMapper).fixedIdpHost(this.fixedIdpHost).discoveryDocumentResponse(this.discoveryDocumentResponse);
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @Generated
    public String getDiscoveryDocumentUrl() {
        return this.discoveryDocumentUrl;
    }

    @Generated
    public boolean isShouldVerifyState() {
        return this.shouldVerifyState;
    }

    @Generated
    public Set<String> getScopes() {
        return this.scopes;
    }

    @Generated
    public UnaryOperator<GetRequest> getBeforeAuthorizationMapper() {
        return this.beforeAuthorizationMapper;
    }

    @Generated
    public Consumer<HttpResponse<AuthenticationChallenge>> getAfterAuthorizationCallback() {
        return this.afterAuthorizationCallback;
    }

    @Generated
    public UnaryOperator<MultipartBody> getBeforeAuthenticationMapper() {
        return this.beforeAuthenticationMapper;
    }

    @Generated
    public Consumer<HttpResponse<String>> getAfterAuthenticationCallback() {
        return this.afterAuthenticationCallback;
    }

    @Generated
    public UnaryOperator<MultipartBody> getBeforeTokenMapper() {
        return this.beforeTokenMapper;
    }

    @Generated
    public Consumer<HttpResponse<JsonNode>> getAfterTokenCallback() {
        return this.afterTokenCallback;
    }

    @Generated
    public AuthenticatorClient getAuthenticatorClient() {
        return this.authenticatorClient;
    }

    @Generated
    public CodeChallengeMethod getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    @Generated
    public UnaryOperator<AuthorizationResponse> getAuthorizationResponseMapper() {
        return this.authorizationResponseMapper;
    }

    @Generated
    public UnaryOperator<AuthenticationResponse> getAuthenticationResponseMapper() {
        return this.authenticationResponseMapper;
    }

    @Generated
    public String getFixedIdpHost() {
        return this.fixedIdpHost;
    }

    @Generated
    public DiscoveryDocumentResponse getDiscoveryDocumentResponse() {
        return this.discoveryDocumentResponse;
    }

    @Generated
    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    @Generated
    public void setBeforeAuthorizationMapper(UnaryOperator<GetRequest> beforeAuthorizationMapper) {
        this.beforeAuthorizationMapper = beforeAuthorizationMapper;
    }

    @Generated
    public void setAfterAuthorizationCallback(Consumer<HttpResponse<AuthenticationChallenge>> afterAuthorizationCallback) {
        this.afterAuthorizationCallback = afterAuthorizationCallback;
    }

    @Generated
    public void setBeforeAuthenticationMapper(UnaryOperator<MultipartBody> beforeAuthenticationMapper) {
        this.beforeAuthenticationMapper = beforeAuthenticationMapper;
    }

    @Generated
    public void setAfterAuthenticationCallback(Consumer<HttpResponse<String>> afterAuthenticationCallback) {
        this.afterAuthenticationCallback = afterAuthenticationCallback;
    }

    @Generated
    public void setBeforeTokenMapper(UnaryOperator<MultipartBody> beforeTokenMapper) {
        this.beforeTokenMapper = beforeTokenMapper;
    }

    @Generated
    public void setAfterTokenCallback(Consumer<HttpResponse<JsonNode>> afterTokenCallback) {
        this.afterTokenCallback = afterTokenCallback;
    }

    @Generated
    public void setAuthenticatorClient(AuthenticatorClient authenticatorClient) {
        this.authenticatorClient = authenticatorClient;
    }

    @Generated
    public void setCodeChallengeMethod(CodeChallengeMethod codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    @Generated
    public void setAuthorizationResponseMapper(UnaryOperator<AuthorizationResponse> authorizationResponseMapper) {
        this.authorizationResponseMapper = authorizationResponseMapper;
    }

    @Generated
    public void setAuthenticationResponseMapper(UnaryOperator<AuthenticationResponse> authenticationResponseMapper) {
        this.authenticationResponseMapper = authenticationResponseMapper;
    }

    @Generated
    public void setFixedIdpHost(String fixedIdpHost) {
        this.fixedIdpHost = fixedIdpHost;
    }

    @Generated
    public void setDiscoveryDocumentResponse(DiscoveryDocumentResponse discoveryDocumentResponse) {
        this.discoveryDocumentResponse = discoveryDocumentResponse;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdpClient)) {
            return false;
        }
        IdpClient other = (IdpClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isShouldVerifyState() != other.isShouldVerifyState()) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$redirectUrl = this.getRedirectUrl();
        String other$redirectUrl = other.getRedirectUrl();
        if (this$redirectUrl == null ? other$redirectUrl != null : !this$redirectUrl.equals(other$redirectUrl)) {
            return false;
        }
        String this$discoveryDocumentUrl = this.getDiscoveryDocumentUrl();
        String other$discoveryDocumentUrl = other.getDiscoveryDocumentUrl();
        if (this$discoveryDocumentUrl == null ? other$discoveryDocumentUrl != null : !this$discoveryDocumentUrl.equals(other$discoveryDocumentUrl)) {
            return false;
        }
        Set<String> this$scopes = this.getScopes();
        Set<String> other$scopes = other.getScopes();
        if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
            return false;
        }
        UnaryOperator<GetRequest> this$beforeAuthorizationMapper = this.getBeforeAuthorizationMapper();
        UnaryOperator<GetRequest> other$beforeAuthorizationMapper = other.getBeforeAuthorizationMapper();
        if (this$beforeAuthorizationMapper == null ? other$beforeAuthorizationMapper != null : !this$beforeAuthorizationMapper.equals(other$beforeAuthorizationMapper)) {
            return false;
        }
        Consumer<HttpResponse<AuthenticationChallenge>> this$afterAuthorizationCallback = this.getAfterAuthorizationCallback();
        Consumer<HttpResponse<AuthenticationChallenge>> other$afterAuthorizationCallback = other.getAfterAuthorizationCallback();
        if (this$afterAuthorizationCallback == null ? other$afterAuthorizationCallback != null : !this$afterAuthorizationCallback.equals(other$afterAuthorizationCallback)) {
            return false;
        }
        UnaryOperator<MultipartBody> this$beforeAuthenticationMapper = this.getBeforeAuthenticationMapper();
        UnaryOperator<MultipartBody> other$beforeAuthenticationMapper = other.getBeforeAuthenticationMapper();
        if (this$beforeAuthenticationMapper == null ? other$beforeAuthenticationMapper != null : !this$beforeAuthenticationMapper.equals(other$beforeAuthenticationMapper)) {
            return false;
        }
        Consumer<HttpResponse<String>> this$afterAuthenticationCallback = this.getAfterAuthenticationCallback();
        Consumer<HttpResponse<String>> other$afterAuthenticationCallback = other.getAfterAuthenticationCallback();
        if (this$afterAuthenticationCallback == null ? other$afterAuthenticationCallback != null : !this$afterAuthenticationCallback.equals(other$afterAuthenticationCallback)) {
            return false;
        }
        UnaryOperator<MultipartBody> this$beforeTokenMapper = this.getBeforeTokenMapper();
        UnaryOperator<MultipartBody> other$beforeTokenMapper = other.getBeforeTokenMapper();
        if (this$beforeTokenMapper == null ? other$beforeTokenMapper != null : !this$beforeTokenMapper.equals(other$beforeTokenMapper)) {
            return false;
        }
        Consumer<HttpResponse<JsonNode>> this$afterTokenCallback = this.getAfterTokenCallback();
        Consumer<HttpResponse<JsonNode>> other$afterTokenCallback = other.getAfterTokenCallback();
        if (this$afterTokenCallback == null ? other$afterTokenCallback != null : !this$afterTokenCallback.equals(other$afterTokenCallback)) {
            return false;
        }
        AuthenticatorClient this$authenticatorClient = this.getAuthenticatorClient();
        AuthenticatorClient other$authenticatorClient = other.getAuthenticatorClient();
        if (this$authenticatorClient == null ? other$authenticatorClient != null : !this$authenticatorClient.equals(other$authenticatorClient)) {
            return false;
        }
        CodeChallengeMethod this$codeChallengeMethod = this.getCodeChallengeMethod();
        CodeChallengeMethod other$codeChallengeMethod = other.getCodeChallengeMethod();
        if (this$codeChallengeMethod == null ? other$codeChallengeMethod != null : !this$codeChallengeMethod.equals(other$codeChallengeMethod)) {
            return false;
        }
        UnaryOperator<AuthorizationResponse> this$authorizationResponseMapper = this.getAuthorizationResponseMapper();
        UnaryOperator<AuthorizationResponse> other$authorizationResponseMapper = other.getAuthorizationResponseMapper();
        if (this$authorizationResponseMapper == null ? other$authorizationResponseMapper != null : !this$authorizationResponseMapper.equals(other$authorizationResponseMapper)) {
            return false;
        }
        UnaryOperator<AuthenticationResponse> this$authenticationResponseMapper = this.getAuthenticationResponseMapper();
        UnaryOperator<AuthenticationResponse> other$authenticationResponseMapper = other.getAuthenticationResponseMapper();
        if (this$authenticationResponseMapper == null ? other$authenticationResponseMapper != null : !this$authenticationResponseMapper.equals(other$authenticationResponseMapper)) {
            return false;
        }
        String this$fixedIdpHost = this.getFixedIdpHost();
        String other$fixedIdpHost = other.getFixedIdpHost();
        if (this$fixedIdpHost == null ? other$fixedIdpHost != null : !this$fixedIdpHost.equals(other$fixedIdpHost)) {
            return false;
        }
        DiscoveryDocumentResponse this$discoveryDocumentResponse = this.getDiscoveryDocumentResponse();
        DiscoveryDocumentResponse other$discoveryDocumentResponse = other.getDiscoveryDocumentResponse();
        return !(this$discoveryDocumentResponse == null ? other$discoveryDocumentResponse != null : !((Object)this$discoveryDocumentResponse).equals(other$discoveryDocumentResponse));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IdpClient;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShouldVerifyState() ? 79 : 97);
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $redirectUrl = this.getRedirectUrl();
        result = result * 59 + ($redirectUrl == null ? 43 : $redirectUrl.hashCode());
        String $discoveryDocumentUrl = this.getDiscoveryDocumentUrl();
        result = result * 59 + ($discoveryDocumentUrl == null ? 43 : $discoveryDocumentUrl.hashCode());
        Set<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        UnaryOperator<GetRequest> $beforeAuthorizationMapper = this.getBeforeAuthorizationMapper();
        result = result * 59 + ($beforeAuthorizationMapper == null ? 43 : $beforeAuthorizationMapper.hashCode());
        Consumer<HttpResponse<AuthenticationChallenge>> $afterAuthorizationCallback = this.getAfterAuthorizationCallback();
        result = result * 59 + ($afterAuthorizationCallback == null ? 43 : $afterAuthorizationCallback.hashCode());
        UnaryOperator<MultipartBody> $beforeAuthenticationMapper = this.getBeforeAuthenticationMapper();
        result = result * 59 + ($beforeAuthenticationMapper == null ? 43 : $beforeAuthenticationMapper.hashCode());
        Consumer<HttpResponse<String>> $afterAuthenticationCallback = this.getAfterAuthenticationCallback();
        result = result * 59 + ($afterAuthenticationCallback == null ? 43 : $afterAuthenticationCallback.hashCode());
        UnaryOperator<MultipartBody> $beforeTokenMapper = this.getBeforeTokenMapper();
        result = result * 59 + ($beforeTokenMapper == null ? 43 : $beforeTokenMapper.hashCode());
        Consumer<HttpResponse<JsonNode>> $afterTokenCallback = this.getAfterTokenCallback();
        result = result * 59 + ($afterTokenCallback == null ? 43 : $afterTokenCallback.hashCode());
        AuthenticatorClient $authenticatorClient = this.getAuthenticatorClient();
        result = result * 59 + ($authenticatorClient == null ? 43 : $authenticatorClient.hashCode());
        CodeChallengeMethod $codeChallengeMethod = this.getCodeChallengeMethod();
        result = result * 59 + ($codeChallengeMethod == null ? 43 : $codeChallengeMethod.hashCode());
        UnaryOperator<AuthorizationResponse> $authorizationResponseMapper = this.getAuthorizationResponseMapper();
        result = result * 59 + ($authorizationResponseMapper == null ? 43 : $authorizationResponseMapper.hashCode());
        UnaryOperator<AuthenticationResponse> $authenticationResponseMapper = this.getAuthenticationResponseMapper();
        result = result * 59 + ($authenticationResponseMapper == null ? 43 : $authenticationResponseMapper.hashCode());
        String $fixedIdpHost = this.getFixedIdpHost();
        result = result * 59 + ($fixedIdpHost == null ? 43 : $fixedIdpHost.hashCode());
        DiscoveryDocumentResponse $discoveryDocumentResponse = this.getDiscoveryDocumentResponse();
        result = result * 59 + ($discoveryDocumentResponse == null ? 43 : ((Object)$discoveryDocumentResponse).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IdpClient(clientId=" + this.getClientId() + ", redirectUrl=" + this.getRedirectUrl() + ", discoveryDocumentUrl=" + this.getDiscoveryDocumentUrl() + ", shouldVerifyState=" + this.isShouldVerifyState() + ", scopes=" + this.getScopes() + ", beforeAuthorizationMapper=" + this.getBeforeAuthorizationMapper() + ", afterAuthorizationCallback=" + this.getAfterAuthorizationCallback() + ", beforeAuthenticationMapper=" + this.getBeforeAuthenticationMapper() + ", afterAuthenticationCallback=" + this.getAfterAuthenticationCallback() + ", beforeTokenMapper=" + this.getBeforeTokenMapper() + ", afterTokenCallback=" + this.getAfterTokenCallback() + ", authenticatorClient=" + this.getAuthenticatorClient() + ", codeChallengeMethod=" + this.getCodeChallengeMethod() + ", authorizationResponseMapper=" + this.getAuthorizationResponseMapper() + ", authenticationResponseMapper=" + this.getAuthenticationResponseMapper() + ", fixedIdpHost=" + this.getFixedIdpHost() + ", discoveryDocumentResponse=" + this.getDiscoveryDocumentResponse() + ")";
    }

    @Generated
    public IdpClient(String clientId, String redirectUrl, String discoveryDocumentUrl, boolean shouldVerifyState, Set<String> scopes, UnaryOperator<GetRequest> beforeAuthorizationMapper, Consumer<HttpResponse<AuthenticationChallenge>> afterAuthorizationCallback, UnaryOperator<MultipartBody> beforeAuthenticationMapper, Consumer<HttpResponse<String>> afterAuthenticationCallback, UnaryOperator<MultipartBody> beforeTokenMapper, Consumer<HttpResponse<JsonNode>> afterTokenCallback, AuthenticatorClient authenticatorClient, CodeChallengeMethod codeChallengeMethod, UnaryOperator<AuthorizationResponse> authorizationResponseMapper, UnaryOperator<AuthenticationResponse> authenticationResponseMapper, String fixedIdpHost, DiscoveryDocumentResponse discoveryDocumentResponse) {
        this.clientId = clientId;
        this.redirectUrl = redirectUrl;
        this.discoveryDocumentUrl = discoveryDocumentUrl;
        this.shouldVerifyState = shouldVerifyState;
        this.scopes = scopes;
        this.beforeAuthorizationMapper = beforeAuthorizationMapper;
        this.afterAuthorizationCallback = afterAuthorizationCallback;
        this.beforeAuthenticationMapper = beforeAuthenticationMapper;
        this.afterAuthenticationCallback = afterAuthenticationCallback;
        this.beforeTokenMapper = beforeTokenMapper;
        this.afterTokenCallback = afterTokenCallback;
        this.authenticatorClient = authenticatorClient;
        this.codeChallengeMethod = codeChallengeMethod;
        this.authorizationResponseMapper = authorizationResponseMapper;
        this.authenticationResponseMapper = authenticationResponseMapper;
        this.fixedIdpHost = fixedIdpHost;
        this.discoveryDocumentResponse = discoveryDocumentResponse;
    }

    static {
        Security.removeProvider("BC");
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        BrainpoolCurves.init();
    }

    @Generated
    public static class IdpClientBuilder {
        @Generated
        private String clientId;
        @Generated
        private String redirectUrl;
        @Generated
        private String discoveryDocumentUrl;
        @Generated
        private boolean shouldVerifyState;
        @Generated
        private boolean scopes$set;
        @Generated
        private Set<String> scopes$value;
        @Generated
        private boolean beforeAuthorizationMapper$set;
        @Generated
        private UnaryOperator<GetRequest> beforeAuthorizationMapper$value;
        @Generated
        private boolean afterAuthorizationCallback$set;
        @Generated
        private Consumer<HttpResponse<AuthenticationChallenge>> afterAuthorizationCallback$value;
        @Generated
        private boolean beforeAuthenticationMapper$set;
        @Generated
        private UnaryOperator<MultipartBody> beforeAuthenticationMapper$value;
        @Generated
        private boolean afterAuthenticationCallback$set;
        @Generated
        private Consumer<HttpResponse<String>> afterAuthenticationCallback$value;
        @Generated
        private boolean beforeTokenMapper$set;
        @Generated
        private UnaryOperator<MultipartBody> beforeTokenMapper$value;
        @Generated
        private boolean afterTokenCallback$set;
        @Generated
        private Consumer<HttpResponse<JsonNode>> afterTokenCallback$value;
        @Generated
        private boolean authenticatorClient$set;
        @Generated
        private AuthenticatorClient authenticatorClient$value;
        @Generated
        private boolean codeChallengeMethod$set;
        @Generated
        private CodeChallengeMethod codeChallengeMethod$value;
        @Generated
        private boolean authorizationResponseMapper$set;
        @Generated
        private UnaryOperator<AuthorizationResponse> authorizationResponseMapper$value;
        @Generated
        private boolean authenticationResponseMapper$set;
        @Generated
        private UnaryOperator<AuthenticationResponse> authenticationResponseMapper$value;
        @Generated
        private String fixedIdpHost;
        @Generated
        private DiscoveryDocumentResponse discoveryDocumentResponse;

        @Generated
        IdpClientBuilder() {
        }

        @Generated
        public IdpClientBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Generated
        public IdpClientBuilder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        @Generated
        public IdpClientBuilder discoveryDocumentUrl(String discoveryDocumentUrl) {
            this.discoveryDocumentUrl = discoveryDocumentUrl;
            return this;
        }

        @Generated
        public IdpClientBuilder shouldVerifyState(boolean shouldVerifyState) {
            this.shouldVerifyState = shouldVerifyState;
            return this;
        }

        @Generated
        public IdpClientBuilder scopes(Set<String> scopes) {
            this.scopes$value = scopes;
            this.scopes$set = true;
            return this;
        }

        @Generated
        public IdpClientBuilder beforeAuthorizationMapper(UnaryOperator<GetRequest> beforeAuthorizationMapper) {
            this.beforeAuthorizationMapper$value = beforeAuthorizationMapper;
            this.beforeAuthorizationMapper$set = true;
            return this;
        }

        @Generated
        public IdpClientBuilder afterAuthorizationCallback(Consumer<HttpResponse<AuthenticationChallenge>> afterAuthorizationCallback) {
            this.afterAuthorizationCallback$value = afterAuthorizationCallback;
            this.afterAuthorizationCallback$set = true;
            return this;
        }

        @Generated
        public IdpClientBuilder beforeAuthenticationMapper(UnaryOperator<MultipartBody> beforeAuthenticationMapper) {
            this.beforeAuthenticationMapper$value = beforeAuthenticationMapper;
            this.beforeAuthenticationMapper$set = true;
            return this;
        }

        @Generated
        public IdpClientBuilder afterAuthenticationCallback(Consumer<HttpResponse<String>> afterAuthenticationCallback) {
            this.afterAuthenticationCallback$value = afterAuthenticationCallback;
            this.afterAuthenticationCallback$set = true;
            return this;
        }

        @Generated
        public IdpClientBuilder beforeTokenMapper(UnaryOperator<MultipartBody> beforeTokenMapper) {
            this.beforeTokenMapper$value = beforeTokenMapper;
            this.beforeTokenMapper$set = true;
            return this;
        }

        @Generated
        public IdpClientBuilder afterTokenCallback(Consumer<HttpResponse<JsonNode>> afterTokenCallback) {
            this.afterTokenCallback$value = afterTokenCallback;
            this.afterTokenCallback$set = true;
            return this;
        }

        @Generated
        public IdpClientBuilder authenticatorClient(AuthenticatorClient authenticatorClient) {
            this.authenticatorClient$value = authenticatorClient;
            this.authenticatorClient$set = true;
            return this;
        }

        @Generated
        public IdpClientBuilder codeChallengeMethod(CodeChallengeMethod codeChallengeMethod) {
            this.codeChallengeMethod$value = codeChallengeMethod;
            this.codeChallengeMethod$set = true;
            return this;
        }

        @Generated
        public IdpClientBuilder authorizationResponseMapper(UnaryOperator<AuthorizationResponse> authorizationResponseMapper) {
            this.authorizationResponseMapper$value = authorizationResponseMapper;
            this.authorizationResponseMapper$set = true;
            return this;
        }

        @Generated
        public IdpClientBuilder authenticationResponseMapper(UnaryOperator<AuthenticationResponse> authenticationResponseMapper) {
            this.authenticationResponseMapper$value = authenticationResponseMapper;
            this.authenticationResponseMapper$set = true;
            return this;
        }

        @Generated
        public IdpClientBuilder fixedIdpHost(String fixedIdpHost) {
            this.fixedIdpHost = fixedIdpHost;
            return this;
        }

        @Generated
        public IdpClientBuilder discoveryDocumentResponse(DiscoveryDocumentResponse discoveryDocumentResponse) {
            this.discoveryDocumentResponse = discoveryDocumentResponse;
            return this;
        }

        @Generated
        public IdpClient build() {
            Set<String> scopes$value = this.scopes$value;
            if (!this.scopes$set) {
                scopes$value = IdpClient.$default$scopes();
            }
            UnaryOperator<GetRequest> beforeAuthorizationMapper$value = this.beforeAuthorizationMapper$value;
            if (!this.beforeAuthorizationMapper$set) {
                beforeAuthorizationMapper$value = IdpClient.$default$beforeAuthorizationMapper();
            }
            Consumer<HttpResponse<AuthenticationChallenge>> afterAuthorizationCallback$value = this.afterAuthorizationCallback$value;
            if (!this.afterAuthorizationCallback$set) {
                afterAuthorizationCallback$value = IdpClient.$default$afterAuthorizationCallback();
            }
            UnaryOperator<MultipartBody> beforeAuthenticationMapper$value = this.beforeAuthenticationMapper$value;
            if (!this.beforeAuthenticationMapper$set) {
                beforeAuthenticationMapper$value = IdpClient.$default$beforeAuthenticationMapper();
            }
            Consumer<HttpResponse<String>> afterAuthenticationCallback$value = this.afterAuthenticationCallback$value;
            if (!this.afterAuthenticationCallback$set) {
                afterAuthenticationCallback$value = IdpClient.$default$afterAuthenticationCallback();
            }
            UnaryOperator<MultipartBody> beforeTokenMapper$value = this.beforeTokenMapper$value;
            if (!this.beforeTokenMapper$set) {
                beforeTokenMapper$value = IdpClient.$default$beforeTokenMapper();
            }
            Consumer<HttpResponse<JsonNode>> afterTokenCallback$value = this.afterTokenCallback$value;
            if (!this.afterTokenCallback$set) {
                afterTokenCallback$value = IdpClient.$default$afterTokenCallback();
            }
            AuthenticatorClient authenticatorClient$value = this.authenticatorClient$value;
            if (!this.authenticatorClient$set) {
                authenticatorClient$value = IdpClient.$default$authenticatorClient();
            }
            CodeChallengeMethod codeChallengeMethod$value = this.codeChallengeMethod$value;
            if (!this.codeChallengeMethod$set) {
                codeChallengeMethod$value = IdpClient.$default$codeChallengeMethod();
            }
            UnaryOperator<AuthorizationResponse> authorizationResponseMapper$value = this.authorizationResponseMapper$value;
            if (!this.authorizationResponseMapper$set) {
                authorizationResponseMapper$value = IdpClient.$default$authorizationResponseMapper();
            }
            UnaryOperator<AuthenticationResponse> authenticationResponseMapper$value = this.authenticationResponseMapper$value;
            if (!this.authenticationResponseMapper$set) {
                authenticationResponseMapper$value = IdpClient.$default$authenticationResponseMapper();
            }
            return new IdpClient(this.clientId, this.redirectUrl, this.discoveryDocumentUrl, this.shouldVerifyState, scopes$value, beforeAuthorizationMapper$value, afterAuthorizationCallback$value, beforeAuthenticationMapper$value, afterAuthenticationCallback$value, beforeTokenMapper$value, afterTokenCallback$value, authenticatorClient$value, codeChallengeMethod$value, authorizationResponseMapper$value, authenticationResponseMapper$value, this.fixedIdpHost, this.discoveryDocumentResponse);
        }

        @Generated
        public String toString() {
            return "IdpClient.IdpClientBuilder(clientId=" + this.clientId + ", redirectUrl=" + this.redirectUrl + ", discoveryDocumentUrl=" + this.discoveryDocumentUrl + ", shouldVerifyState=" + this.shouldVerifyState + ", scopes$value=" + this.scopes$value + ", beforeAuthorizationMapper$value=" + this.beforeAuthorizationMapper$value + ", afterAuthorizationCallback$value=" + this.afterAuthorizationCallback$value + ", beforeAuthenticationMapper$value=" + this.beforeAuthenticationMapper$value + ", afterAuthenticationCallback$value=" + this.afterAuthenticationCallback$value + ", beforeTokenMapper$value=" + this.beforeTokenMapper$value + ", afterTokenCallback$value=" + this.afterTokenCallback$value + ", authenticatorClient$value=" + this.authenticatorClient$value + ", codeChallengeMethod$value=" + this.codeChallengeMethod$value + ", authorizationResponseMapper$value=" + this.authorizationResponseMapper$value + ", authenticationResponseMapper$value=" + this.authenticationResponseMapper$value + ", fixedIdpHost=" + this.fixedIdpHost + ", discoveryDocumentResponse=" + this.discoveryDocumentResponse + ")";
        }
    }
}

