/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.idp.authentication.JwtBuilder;
import de.gematik.idp.client.IdpClientRuntimeException;
import de.gematik.idp.client.data.DeviceInformation;
import de.gematik.idp.client.data.DeviceType;
import de.gematik.idp.client.data.DiscoveryDocumentResponse;
import de.gematik.idp.client.data.RegistrationData;
import de.gematik.idp.crypto.model.PkiIdentity;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.IdpJwe;
import de.gematik.idp.token.JsonWebToken;
import java.security.Key;
import java.security.KeyPair;
import java.util.Base64;
import java.util.List;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.MultipartBody;
import kong.unirest.Unirest;
import lombok.Generated;

public class BiometrieClient {
    private static final String USER_AGENT = "IdP-Client";
    private static final String BEARER = "Bearer ";
    private final DiscoveryDocumentResponse discoveryDocumentResponse;
    private JsonWebToken accessToken;

    public RegistrationData insertPairing(PkiIdentity identity, KeyPair keyPairToRegister) {
        JsonWebToken signedPairingData = new JwtBuilder().setSignerKey((Key)identity.getPrivateKey()).addBodyClaim(ClaimName.AUTH_CERT_SUBJECT_PUBLIC_KEY_INFO, (Object)Base64.getUrlEncoder().withoutPadding().encodeToString(identity.getCertificate().getPublicKey().getEncoded())).addBodyClaim(ClaimName.DEVICE_PRODUCT, (Object)"meinPhone").addBodyClaim(ClaimName.CERTIFICATE_SERIALNUMBER, (Object)identity.getCertificate().getSerialNumber().toString()).addBodyClaim(ClaimName.KEY_IDENTIFIER, (Object)"seIdVomPhoneHerGeneriert").addBodyClaim(ClaimName.SE_SUBJECT_PUBLIC_KEY_INFO, (Object)Base64.getUrlEncoder().withoutPadding().encodeToString(keyPairToRegister.getPublic().getEncoded())).addBodyClaim(ClaimName.CERTIFICATE_ISSUER, (Object)Base64.getUrlEncoder().withoutPadding().encodeToString(identity.getCertificate().getIssuerX500Principal().getEncoded())).addBodyClaim(ClaimName.PAIRING_DATA_VERSION, (Object)"1.0").addBodyClaim(ClaimName.CERTIFICATE_NOT_AFTER, (Object)identity.getCertificate().getNotAfter().toInstant().getEpochSecond()).buildJwt();
        return this.insertPairing(RegistrationData.builder().authCert(Base64.getUrlEncoder().withoutPadding().encodeToString(identity.getCertificate().getEncoded())).signedPairingData(signedPairingData.getRawString()).deviceInformation(DeviceInformation.builder().deviceType(DeviceType.builder().build()).build()).build());
    }

    public RegistrationData insertPairing(RegistrationData biometrieData) {
        try {
            String payload = new ObjectMapper().writeValueAsString((Object)biometrieData);
            HttpResponse response = ((MultipartBody)((MultipartBody)((MultipartBody)Unirest.post((String)this.getPairingEndpoint()).field("encrypted_registration_data", (Object)IdpJwe.createWithPayloadAndEncryptWithKey((String)payload, (Key)this.discoveryDocumentResponse.getIdpEnc(), (String)"JSON").getRawString()).header("Authorization", this.buildAuthorizationHeader())).header("User-Agent", USER_AGENT)).header("Content-Type", "application/x-www-form-urlencoded")).asString();
            if (!response.isSuccess()) {
                throw new IdpClientRuntimeException("Error during registration: " + (String)response.getBody());
            }
            return biometrieData;
        }
        catch (JsonProcessingException e) {
            throw new IdpClientRuntimeException((Exception)((Object)e));
        }
    }

    private String buildAuthorizationHeader() {
        return BEARER + this.accessToken.encrypt((Key)this.discoveryDocumentResponse.getIdpEnc()).getRawString();
    }

    private String getPairingEndpoint() {
        return this.discoveryDocumentResponse.getPairingEndpoint();
    }

    public List<RegistrationData> getAllPairings() {
        HttpResponse response = ((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)this.getPairingEndpoint()).header("Authorization", this.buildAuthorizationHeader())).header("User-Agent", USER_AGENT)).header("Content-Type", "application/json")).asObject((GenericType)new GenericType<List<RegistrationData>>(){});
        if (response.getStatus() != 200) {
            throw new IdpClientRuntimeException("Unexpected Server-Response " + response.getStatus());
        }
        return (List)response.getBody();
    }

    public boolean deleteAllPairingsForKvnr(String kvnr) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.delete((String)(this.getPairingEndpoint() + "/" + kvnr)).header("Authorization", BEARER + this.accessToken.getRawString())).header("User-Agent", USER_AGENT)).header("Accept", "application/json")).asString();
        return response.getStatus() == 200;
    }

    @Generated
    BiometrieClient(DiscoveryDocumentResponse discoveryDocumentResponse, JsonWebToken accessToken) {
        this.discoveryDocumentResponse = discoveryDocumentResponse;
        this.accessToken = accessToken;
    }

    @Generated
    public static BiometrieClientBuilder builder() {
        return new BiometrieClientBuilder();
    }

    @Generated
    public DiscoveryDocumentResponse getDiscoveryDocumentResponse() {
        return this.discoveryDocumentResponse;
    }

    @Generated
    public JsonWebToken getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public void setAccessToken(JsonWebToken accessToken) {
        this.accessToken = accessToken;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiometrieClient)) {
            return false;
        }
        BiometrieClient other = (BiometrieClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DiscoveryDocumentResponse this$discoveryDocumentResponse = this.getDiscoveryDocumentResponse();
        DiscoveryDocumentResponse other$discoveryDocumentResponse = other.getDiscoveryDocumentResponse();
        if (this$discoveryDocumentResponse == null ? other$discoveryDocumentResponse != null : !((Object)this$discoveryDocumentResponse).equals(other$discoveryDocumentResponse)) {
            return false;
        }
        JsonWebToken this$accessToken = this.getAccessToken();
        JsonWebToken other$accessToken = other.getAccessToken();
        return !(this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BiometrieClient;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DiscoveryDocumentResponse $discoveryDocumentResponse = this.getDiscoveryDocumentResponse();
        result = result * 59 + ($discoveryDocumentResponse == null ? 43 : ((Object)$discoveryDocumentResponse).hashCode());
        JsonWebToken $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BiometrieClient(discoveryDocumentResponse=" + this.getDiscoveryDocumentResponse() + ", accessToken=" + this.getAccessToken() + ")";
    }

    @Generated
    public static class BiometrieClientBuilder {
        @Generated
        private DiscoveryDocumentResponse discoveryDocumentResponse;
        @Generated
        private JsonWebToken accessToken;

        @Generated
        BiometrieClientBuilder() {
        }

        @Generated
        public BiometrieClientBuilder discoveryDocumentResponse(DiscoveryDocumentResponse discoveryDocumentResponse) {
            this.discoveryDocumentResponse = discoveryDocumentResponse;
            return this;
        }

        @Generated
        public BiometrieClientBuilder accessToken(JsonWebToken accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Generated
        public BiometrieClient build() {
            return new BiometrieClient(this.discoveryDocumentResponse, this.accessToken);
        }

        @Generated
        public String toString() {
            return "BiometrieClient.BiometrieClientBuilder(discoveryDocumentResponse=" + this.discoveryDocumentResponse + ", accessToken=" + this.accessToken + ")";
        }
    }
}

