/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.fhir.snapshots.helper;

import de.gematik.fhir.snapshots.helper.ZipSlipProtect;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import lombok.Generated;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TARGZ {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TARGZ.class);

    public static void compress(final Path sourceDirectory, String outputDirectory) throws IOException {
        TARGZ.validateDirectory(sourceDirectory);
        String tarFileName = TARGZ.getTarFileName(sourceDirectory, outputDirectory);
        try (OutputStream fileOutputStream = Files.newOutputStream(Paths.get(tarFileName, new String[0]), new OpenOption[0]);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             GzipCompressorOutputStream gzipOutputStream = new GzipCompressorOutputStream((OutputStream)bufferedOutputStream);
             final TarArchiveOutputStream tarOutputStream = new TarArchiveOutputStream((OutputStream)gzipOutputStream);){
            TARGZ.configureTarOutputStream(tarOutputStream);
            Files.walkFileTree(sourceDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    if (!attributes.isSymbolicLink()) {
                        Path targetFile = sourceDirectory.relativize(file);
                        TARGZ.addFileToTar(file, targetFile, tarOutputStream);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    log.error("Unable to tar.gz : {}", (Object)file, (Object)exc);
                    return FileVisitResult.CONTINUE;
                }
            });
            tarOutputStream.finish();
        }
    }

    public static void decompress(String inputFileName, File outputDirectory) throws IOException {
        try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(inputFileName)));){
            TarArchiveEntry entry;
            while ((entry = tarInputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String currentEntryName = entry.getName();
                File currentFile = ZipSlipProtect.newFile(outputDirectory, currentEntryName);
                File parent = currentFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try (FileOutputStream outputFileStream = new FileOutputStream(currentFile);){
                    IOUtils.copy((InputStream)tarInputStream, (OutputStream)outputFileStream);
                }
            }
        }
    }

    private static void validateDirectory(Path source) throws IOException {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            throw new IOException("Please provide a directory.");
        }
    }

    private static String getTarFileName(Path sourceDirectory, String outputDirectory) {
        return outputDirectory + sourceDirectory.getFileName().toString() + ".tgz";
    }

    private static void configureTarOutputStream(TarArchiveOutputStream tOut) {
        tOut.setLongFileMode(2);
    }

    private static void addFileToTar(Path file, Path targetFile, TarArchiveOutputStream tOut) throws IOException {
        TarArchiveEntry tarEntry = new TarArchiveEntry(file.toFile(), targetFile.toString());
        tarEntry.setModTime(0L);
        tarEntry.setUserName("defaultUser");
        tarEntry.setGroupName("defaultGroup");
        tarEntry.setUserId(1000);
        tarEntry.setGroupId(1000);
        tOut.putArchiveEntry(tarEntry);
        Files.copy(file, (OutputStream)tOut);
        tOut.closeArchiveEntry();
    }

    @Generated
    private TARGZ() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

