/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.fhir.snapshots.helper;

import java.util.Comparator;
import java.util.Objects;
import lombok.NonNull;

public class PackageVersion
implements Comparable<PackageVersion> {
    private final String version;

    public PackageVersion(String version) {
        this.version = version;
    }

    @Override
    public int compareTo(@NonNull PackageVersion other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return Comparator.comparing(v -> v.version).compare(this, other);
    }

    public String toString() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PackageVersion that = (PackageVersion)obj;
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    public boolean matchesWildcard(String wildcardVersion) {
        return this.version.startsWith(wildcardVersion.substring(0, wildcardVersion.length() - 1));
    }
}

