/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.fhir.snapshots.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.fhir.snapshots.PackageReference;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DependencyGenerator.class);

    public List<String> generateListOfDependenciesFor(String filename, String packageFolderPath) throws IOException {
        List<String> dependencyList = this.getDependencyList(filename, packageFolderPath);
        if (!dependencyList.isEmpty()) {
            return dependencyList;
        }
        throw new IllegalArgumentException(String.format("Could not generate dependencies for %s", filename));
    }

    private List<String> getDependencyList(String filename, String packageFolderPath) throws IOException {
        ArrayList<String> dependencyList = new ArrayList<String>();
        dependencyList.add(filename);
        boolean newDependenciesAdded = true;
        while (newDependenciesAdded) {
            ArrayList<String> currentDependencyList = new ArrayList<String>(dependencyList);
            newDependenciesAdded = false;
            for (String s : currentDependencyList) {
                int initialSize = dependencyList.size();
                this.getDependenciesFromPackageJson(packageFolderPath, dependencyList, s);
                if (dependencyList.size() <= initialSize) continue;
                newDependenciesAdded = true;
            }
        }
        return dependencyList;
    }

    private void getDependenciesFromPackageJson(String packageFolderPath, List<String> dependencyList, String filename) throws IOException {
        List<PackageReference> additionalRefs = this.getDependenciesFor(packageFolderPath + File.separator + filename);
        for (PackageReference pr : additionalRefs) {
            String packageFilename = this.getPackageFilename(pr, packageFolderPath);
            if (dependencyList.contains(packageFilename)) continue;
            dependencyList.add(packageFilename);
        }
    }

    private String getPackageFilename(PackageReference pr, String packageFolderPath) {
        String packageFilename;
        if (pr.getPackageVersion().toLowerCase().endsWith("x")) {
            packageFilename = pr.getWildcardPackageFilename(packageFolderPath);
            if (StringUtils.isEmpty((CharSequence)packageFilename)) {
                throw new IllegalArgumentException(String.format("Wildcard version '%s' has been found for package name '%s'. But no matching packages were found in '%s'", pr.getPackageVersion(), pr.getPackageName(), packageFolderPath));
            }
        } else {
            packageFilename = String.format("%s-%s.tgz", pr.getPackageName(), pr.getPackageVersion()).toLowerCase();
        }
        return packageFilename;
    }

    private List<PackageReference> getDependenciesFor(String tgzFilePath) throws IOException {
        ArrayList<PackageReference> dependencies = new ArrayList<PackageReference>();
        try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(tgzFilePath))));){
            TarArchiveEntry entry;
            while ((entry = tarInputStream.getNextEntry()) != null) {
                if (!entry.getName().equals("package/package.json")) continue;
                ObjectMapper objectMapper = new ObjectMapper();
                String jsonContent = new String(tarInputStream.readAllBytes());
                JsonNode jsonNode = objectMapper.readTree(jsonContent);
                JsonNode dependenciesNode = jsonNode.get("dependencies");
                if (dependenciesNode != null) {
                    dependenciesNode.fields().forEachRemaining(dependencyEntry -> {
                        String packageName = (String)dependencyEntry.getKey();
                        String version = ((JsonNode)dependencyEntry.getValue()).asText();
                        if (!"hl7.fhir.r4.core".equals(packageName)) {
                            dependencies.add(new PackageReference(packageName, version));
                        }
                    });
                }
                break;
            }
        }
        return dependencies;
    }

    @Generated
    public DependencyGenerator() {
    }
}

