/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.fhir.snapshots;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import de.gematik.fhir.snapshots.helper.DependencyGenerator;
import de.gematik.fhir.snapshots.helper.FixedSnapshotGeneratingValidationSupport;
import de.gematik.fhir.snapshots.helper.NpmPackageLoader;
import de.gematik.fhir.snapshots.helper.TARGZ;
import de.gematik.fhir.snapshots.helper.ZipSlipProtect;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.hl7.fhir.common.hapi.validation.support.PrePopulatedValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnapshotGenerator.class);
    private static final FhirContext fhirContext = FhirContext.forR4();
    private final DependencyGenerator dependencyGenerator = new DependencyGenerator();
    private final Map<String, IBaseResource> currentPatches = new HashMap<String, IBaseResource>();
    private IValidationSupport snapshotGeneratingValidationSupport;
    private ValidationSupportChain chain;
    private String currentPackageName = "";
    private static final String PACKAGE_FOLDER_PREFIX = "package/";

    public void generateSnapshots(String packageFolderPath, String outputFolder, String tempDir) throws IOException {
        this.generateSnapshots(packageFolderPath, outputFolder, new ArrayList<String>(), tempDir);
    }

    public void generateSnapshots(String packageFolderPath, String outputFolder, Collection<String> packagesForSnapshotGeneration, String tempDir) throws IOException {
        File packageFolder = new File(packageFolderPath);
        File[] tgzFiles = packageFolder.listFiles((dir, name) -> name.endsWith(".tgz"));
        if (tgzFiles == null || tgzFiles.length == 0) {
            log.warn("No FHIR packages found at: {}", (Object)packageFolderPath);
            return;
        }
        List allPackageNames = Arrays.stream(tgzFiles).map(File::getName).collect(Collectors.toList());
        ArrayList<String> packagesToGenerate = new ArrayList<String>(packagesForSnapshotGeneration);
        if (packagesToGenerate.isEmpty()) {
            packagesToGenerate.addAll(allPackageNames);
        }
        for (String packageName : allPackageNames) {
            if (!packagesToGenerate.contains(packageName)) {
                log.info("Skipping package: {} (not specified for snapshot generation)", (Object)packageName);
                continue;
            }
            log.info("Starting snapshot generation for {}", (Object)packageName);
            List<String> dependencies = this.dependencyGenerator.generateListOfDependenciesFor(packageName, packageFolderPath);
            this.generateSnapshotsAndCompressAsTgz(packageFolderPath, outputFolder, packageName, dependencies, tempDir);
        }
    }

    private void generateSnapshotsAndCompressAsTgz(String sourceDir, String outputDir, String filename, List<String> dependencies, String tempDir) throws IOException {
        this.setupSupportChain(dependencies, sourceDir);
        this.decompressPackage(sourceDir, filename, tempDir);
        this.readStructureDefinitionsFromTgz(sourceDir, filename, tempDir);
        this.compressPackage(outputDir, tempDir);
        log.info("Finished snapshot generation for {}", (Object)filename);
    }

    private void setupSupportChain(List<String> dependencies, String sourceDir) throws IOException {
        IValidationSupport npmPackageSupport = new NpmPackageLoader().loadPackagesAndCreatePrePopulatedValidationSupport(fhirContext, dependencies, sourceDir);
        this.getPatches(dependencies, sourceDir);
        PrePopulatedValidationSupport patchesSupport = new PrePopulatedValidationSupport(fhirContext);
        for (Map.Entry<String, IBaseResource> entry : this.currentPatches.entrySet()) {
            log.info("Applying patch for {}", (Object)entry.getValue());
            patchesSupport.addResource(entry.getValue());
        }
        IValidationSupport validationSupport = fhirContext.getValidationSupport();
        this.snapshotGeneratingValidationSupport = new FixedSnapshotGeneratingValidationSupport(fhirContext);
        this.chain = new ValidationSupportChain(new IValidationSupport[]{patchesSupport, npmPackageSupport, validationSupport, this.snapshotGeneratingValidationSupport});
    }

    private void getPatches(List<String> dependencies, String sourceDir) throws IOException {
        this.currentPatches.clear();
        for (String currentPackageFilename : dependencies) {
            this.getPatchesFor(currentPackageFilename.replace(".tgz", ""), sourceDir);
        }
    }

    private void getPatchesFor(String currentPackage, String sourceDir) throws IOException {
        File[] directoryListing;
        File directory = new File(sourceDir + "patches/" + currentPackage);
        if (directory.exists() && (directoryListing = directory.listFiles()) != null) {
            for (File child : directoryListing) {
                if (!child.getName().endsWith(".json")) continue;
                try (FileInputStream inputStream = new FileInputStream(child);){
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    IBaseResource patch = fhirContext.newJsonParser().parseResource((Reader)reader);
                    this.currentPatches.put(child.getName(), patch);
                }
            }
        }
    }

    private void decompressPackage(String sourceDir, String fileName, String tempDirPath) throws IOException {
        this.currentPackageName = fileName.replaceAll(".tgz", "");
        File tempDir = new File(tempDirPath + this.currentPackageName);
        FileUtils.deleteDirectory((File)tempDir);
        TARGZ.decompress(sourceDir + fileName, tempDir);
    }

    private void compressPackage(String outputDir, String tempDir) throws IOException {
        Path source = Paths.get(tempDir + this.currentPackageName, new String[0]);
        Files.createDirectories(Paths.get(outputDir, new String[0]), new FileAttribute[0]);
        TARGZ.compress(source, outputDir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readStructureDefinitionsFromTgz(String sourceDir, String filename, String tempDir) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(sourceDir + filename);
             GzipCompressorInputStream gzipInputStream = new GzipCompressorInputStream((InputStream)fileInputStream);
             TarArchiveInputStream tarInputStream = new TarArchiveInputStream((InputStream)gzipInputStream);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)tarInputStream, StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            TarArchiveEntry currentEntry = tarInputStream.getNextEntry();
            while (currentEntry != null) {
                String currentEntryName = currentEntry.getName();
                log.debug("Processing " + currentEntryName);
                try {
                    this.createSnapshotIfStructureDefinitionAndWrite(tempDir, currentEntryName, bufferedReader);
                    currentEntry = tarInputStream.getNextEntry();
                }
                catch (Exception e) {
                    log.error("Could not create a snapshot for " + currentEntryName + " (" + filename + ")", (Throwable)e);
                    throw e;
                    return;
                }
            }
        }
    }

    private void createSnapshotIfStructureDefinitionAndWrite(String tempDir, String currentEntryName, BufferedReader bufferedReader) throws IOException {
        if (currentEntryName.startsWith(PACKAGE_FOLDER_PREFIX) && !currentEntryName.substring(PACKAGE_FOLDER_PREFIX.length()).contains("/") && currentEntryName.endsWith(".json")) {
            File destDir = new File(tempDir + this.currentPackageName);
            File newFile = ZipSlipProtect.newFile(destDir, currentEntryName);
            if (SnapshotGenerator.fileShouldBeIgnored(currentEntryName)) {
                String resourceFileName = currentEntryName.replace(PACKAGE_FOLDER_PREFIX, "");
                IBaseResource originalResource = fhirContext.newJsonParser().parseResource((Reader)bufferedReader);
                IBaseResource patchedResource = this.currentPatches.getOrDefault(resourceFileName, null);
                if (patchedResource == null && !(originalResource instanceof StructureDefinition)) {
                    return;
                }
                if (patchedResource != null && !(originalResource instanceof StructureDefinition)) {
                    SnapshotGenerator.writeResource(patchedResource, newFile);
                    return;
                }
                IBaseResource patchOrOriginalStructureDefinition = patchedResource != null ? patchedResource : originalResource;
                this.logGeneratingSnapshotFor(newFile.getName());
                IBaseResource snapshot = this.generateSnapshot(patchOrOriginalStructureDefinition);
                SnapshotGenerator.writeResource(snapshot, newFile);
            }
        }
    }

    private static boolean fileShouldBeIgnored(String currentEntryName) {
        return !currentEntryName.equals("package/package.json") && !currentEntryName.equals("package/.index.json");
    }

    private static void writeResource(IBaseResource resource, File newFile) throws IOException {
        FileUtils.write((File)newFile, (CharSequence)fhirContext.newJsonParser().setPrettyPrint(true).encodeResourceToString(resource), (Charset)StandardCharsets.UTF_8);
    }

    private IBaseResource generateSnapshot(IBaseResource resource) {
        return this.snapshotGeneratingValidationSupport.generateSnapshot(new ValidationSupportContext((IValidationSupport)this.chain), resource, null, null, null);
    }

    private void logGeneratingSnapshotFor(String currentFileName) {
        String packageAndProfile = String.format("(%s) %s", this.currentPackageName, currentFileName.replace("/package/", ""));
        log.info("Generating snapshot for: {}", (Object)packageAndProfile);
    }

    @Generated
    public SnapshotGenerator() {
    }
}

