/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.fhir.snapshots;

import de.gematik.fhir.snapshots.helper.PackageVersion;
import java.io.File;
import lombok.Generated;

public class PackageReference {
    private String packageName;
    private String packageVersion;

    public String getWildcardPackageFilename(String packageFolderPath) {
        File folder = new File(packageFolderPath);
        File[] files = folder.listFiles((dir, name) -> name.matches(this.packageName + "-\\d+\\.\\d+\\.\\d+\\.tgz"));
        String highestVersionFilename = "";
        PackageVersion highestVersion = null;
        if (files != null) {
            for (File file : files) {
                String filename = file.getName();
                String versionString = filename.substring(this.packageName.length() + 1, filename.length() - 4);
                PackageVersion version = new PackageVersion(versionString);
                if (!version.matchesWildcard(this.packageVersion) || highestVersion != null && version.compareTo(highestVersion) <= 0) continue;
                highestVersion = version;
                highestVersionFilename = filename;
            }
        }
        return highestVersionFilename;
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public String getPackageVersion() {
        return this.packageVersion;
    }

    @Generated
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Generated
    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackageReference)) {
            return false;
        }
        PackageReference other = (PackageReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$packageVersion = this.getPackageVersion();
        String other$packageVersion = other.getPackageVersion();
        return !(this$packageVersion == null ? other$packageVersion != null : !this$packageVersion.equals(other$packageVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PackageReference;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $packageVersion = this.getPackageVersion();
        result = result * 59 + ($packageVersion == null ? 43 : $packageVersion.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PackageReference(packageName=" + this.getPackageName() + ", packageVersion=" + this.getPackageVersion() + ")";
    }

    @Generated
    public PackageReference(String packageName, String packageVersion) {
        this.packageName = packageName;
        this.packageVersion = packageVersion;
    }
}

