/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.fhir.snapshots.helper;

import java.io.File;
import java.io.IOException;

public final class ZipSlipProtect {
    public static File newFile(File destDir, String currentEntryName) throws IOException {
        File destFile = new File(destDir, currentEntryName);
        String destDirPath = destDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new SecurityException("Entry is outside of the target dir: " + currentEntryName);
        }
        return destFile;
    }

    private ZipSlipProtect() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

