/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.fhir.snapshots.helper;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.DataFormatException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.hl7.fhir.common.hapi.validation.support.PrePopulatedValidationSupport;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomNpmPackageValidationSupport
extends PrePopulatedValidationSupport {
    private static final Logger log = LoggerFactory.getLogger(CustomNpmPackageValidationSupport.class);
    private static final String PACKAGE = "package";

    public CustomNpmPackageValidationSupport(@Nonnull FhirContext theFhirContext) {
        super(theFhirContext);
    }

    public void loadPackageFromPath(String dirPath) throws IOException {
        this.loadPackageFromInputStream(new FileInputStream(dirPath));
    }

    public void loadPackageFromInputStream(InputStream is) throws IOException {
        try (InputStream inputStream = is;){
            NpmPackage pkg = NpmPackage.fromPackage((InputStream)is);
            if (pkg.getFolders().containsKey(PACKAGE)) {
                this.loadResourcesFromPackage(pkg);
                this.loadBinariesFromPackage(pkg);
            }
        }
    }

    private void loadResourcesFromPackage(NpmPackage thePackage) {
        NpmPackage.NpmPackageFolder packageFolder = (NpmPackage.NpmPackageFolder)thePackage.getFolders().get(PACKAGE);
        for (String nextFile : packageFolder.listFiles()) {
            if (!nextFile.toLowerCase(Locale.US).endsWith(".json")) continue;
            String input = new String((byte[])packageFolder.getContent().get(nextFile), StandardCharsets.UTF_8);
            try {
                IBaseResource resource = this.getFhirContext().newJsonParser().parseResource(input);
                super.addResource(resource);
            }
            catch (Exception e) {
                throw new DataFormatException("Something went wrong with " + nextFile, (Throwable)e);
            }
        }
    }

    private void loadBinariesFromPackage(NpmPackage thePackage) throws IOException {
        List binaries = thePackage.list("other");
        for (String binaryName : binaries) {
            this.addBinary(TextFile.streamToBytes((InputStream)thePackage.load("other", binaryName)), binaryName);
        }
    }
}

