/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.utils;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlElementDecl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLInputFactory;
import lombok.Generated;
import lombok.NonNull;

public final class XmlUtils {
    private static final String OBJECT_FACTORY_CLASS_NAME = "ObjectFactory";
    private static final AtomicReference<Object> xmlInputFactory = new AtomicReference();
    private static final AtomicReference<Object> datatypeFactory = new AtomicReference();

    public static byte[] marshal(@NonNull Object xmlObject) {
        Objects.requireNonNull(xmlObject, "xmlObject is marked non-null but is null");
        JAXBContext jaxbCtx = JAXBContext.newInstance((Class[])new Class[]{xmlObject.getClass()});
        Marshaller jaxbMarshaller = jaxbCtx.createMarshaller();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (jaxbCtx.createJAXBIntrospector().isElement(xmlObject)) {
            jaxbMarshaller.marshal(xmlObject, (OutputStream)outputStream);
        } else {
            jaxbMarshaller.marshal(XmlUtils.toJaxbElement(xmlObject), (OutputStream)outputStream);
        }
        return outputStream.toByteArray();
    }

    public static <T> T unmarshal(@NonNull Class<T> objectType, @NonNull InputStream marshalledObject) {
        Objects.requireNonNull(objectType, "objectType is marked non-null but is null");
        Objects.requireNonNull(marshalledObject, "marshalledObject is marked non-null but is null");
        Unmarshaller jaxbUnmarshaller = JAXBContext.newInstance((Class[])new Class[]{objectType}).createUnmarshaller();
        return (T)jaxbUnmarshaller.unmarshal(XmlUtils.xmlInputFactory().createXMLStreamReader(marshalledObject), objectType).getValue();
    }

    public static <T> T unmarshal(@NonNull Class<T> objectType, byte[] marshalledObject) {
        Objects.requireNonNull(objectType, "objectType is marked non-null but is null");
        return XmlUtils.unmarshal(objectType, new ByteArrayInputStream(marshalledObject));
    }

    public static XMLGregorianCalendar fromLocalDate(LocalDate date) {
        return Optional.ofNullable(date).map(d -> d.atStartOfDay(ZoneId.systemDefault())).map(GregorianCalendar::from).map(gc -> XmlUtils.datatypeFactory().newXMLGregorianCalendar((GregorianCalendar)gc)).orElse(null);
    }

    private static XMLInputFactory newXmlInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        return factory;
    }

    private static <T> JAXBElement<T> toJaxbElement(@NonNull T xmlObject) {
        Objects.requireNonNull(xmlObject, "xmlObject is marked non-null but is null");
        Class<?> objClass = xmlObject.getClass();
        String pckg = objClass.getPackageName();
        Object objFac = objClass.getClassLoader().loadClass(pckg + ".ObjectFactory").getConstructor(new Class[0]).newInstance(new Object[0]);
        Method jaxbElementMethod = Arrays.stream(objFac.getClass().getDeclaredMethods()).filter(method -> method.isAnnotationPresent(XmlElementDecl.class)).filter(method -> {
            Type patt6870$temp = method.getGenericReturnType();
            if (patt6870$temp instanceof ParameterizedType) {
                ParameterizedType returnType = (ParameterizedType)patt6870$temp;
                return returnType.getRawType().equals(JAXBElement.class) && returnType.getActualTypeArguments().length == 1 && Arrays.stream(returnType.getActualTypeArguments()).allMatch(typeArg -> typeArg.equals(objClass));
            }
            return false;
        }).filter(method -> {
            Class<?>[] prmTypes = method.getParameterTypes();
            return prmTypes.length == 1 && Arrays.stream(prmTypes).allMatch(prmType -> prmType.equals(objClass));
        }).findFirst().orElseThrow(() -> new NoSuchElementException("No JAXBElement factory method found for class " + objClass));
        Object result = jaxbElementMethod.invoke(objFac, xmlObject);
        return (JAXBElement)result;
    }

    @Generated
    private XmlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static XMLInputFactory xmlInputFactory() {
        Object value = xmlInputFactory.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = xmlInputFactory;
            synchronized (atomicReference) {
                value = xmlInputFactory.get();
                if (value == null) {
                    XMLInputFactory actualValue = XmlUtils.newXmlInputFactory();
                    value = actualValue == null ? xmlInputFactory : actualValue;
                    xmlInputFactory.set(value);
                }
            }
        }
        return (XMLInputFactory)(value == xmlInputFactory ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static DatatypeFactory datatypeFactory() {
        Object value = datatypeFactory.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = datatypeFactory;
            synchronized (atomicReference) {
                value = datatypeFactory.get();
                if (value == null) {
                    DatatypeFactory actualValue = DatatypeFactory.newDefaultInstance();
                    value = actualValue == null ? datatypeFactory : actualValue;
                    datatypeFactory.set(value);
                }
            }
        }
        return (DatatypeFactory)(value == datatypeFactory ? null : value);
    }
}

