/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.utils;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.isismtt.x509.AdmissionSyntax;
import org.bouncycastle.asn1.isismtt.x509.Admissions;
import org.bouncycastle.asn1.isismtt.x509.ProfessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateUtils.class);
    private static final String ADMISSION_IDENTIFIER_ID = ISISMTTObjectIdentifiers.id_isismtt_at_admission.getId();
    private static final String CERTIFICATE_TYPE_X509 = "X.509";

    public static X509Certificate toX509Certificate(byte[] encoded) {
        CertificateFactory certFactory = CertificateFactory.getInstance(CERTIFICATE_TYPE_X509);
        ByteArrayInputStream certStream = new ByteArrayInputStream(encoded);
        return (X509Certificate)certFactory.generateCertificate(certStream);
    }

    public static String getTelematikIdFromCertificate(@NonNull X509Certificate certificate) {
        Objects.requireNonNull(certificate, "certificate is marked non-null but is null");
        ProfessionInfo professionInfo = CertificateUtils.getProfessionInfoFromCertificate(certificate);
        return Optional.ofNullable(professionInfo).map(ProfessionInfo::getRegistrationNumber).orElseGet(() -> {
            log.warn("No telematikId could be found in certificate {}", (Object)certificate);
            return null;
        });
    }

    private static ProfessionInfo getProfessionInfoFromCertificate(@NonNull X509Certificate certificate) {
        Objects.requireNonNull(certificate, "certificate is marked non-null but is null");
        byte[] extensionValue = certificate.getExtensionValue(ADMISSION_IDENTIFIER_ID);
        return CertificateUtils.getProfessionInfoFromAdmissionExtension(extensionValue);
    }

    private static ProfessionInfo getProfessionInfoFromAdmissionExtension(byte[] extensionValue) {
        return Optional.ofNullable(extensionValue).filter(extVal -> ((byte[])extVal).length > 2).map(ASN1OctetString::getInstance).map(asn1Octet -> ASN1Sequence.getInstance((Object)asn1Octet.getOctets())).map(AdmissionSyntax::getInstance).map(AdmissionSyntax::getContentsOfAdmissions).stream().flatMap(Arrays::stream).map(Admissions::getProfessionInfos).flatMap(Arrays::stream).findFirst().orElse(null);
    }

    @Generated
    private CertificateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

