/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.konnektor.conversion;

import de.gematik.epa.dto.request.Confidentiality;
import de.gematik.epa.dto.request.FolderCode;
import de.gematik.epa.dto.request.PermissionHcpoRequest;
import de.gematik.epa.ihe.model.simple.AuthorInstitution;
import de.gematik.epa.utils.StringUtils;
import de.gematik.epa.utils.XmlUtils;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import telematik.ws.conn.cardservice.xsd.v8_1.CardInfoType;
import telematik.ws.conn.phrs.phrmanagementservice.xsd.v2_0.AuthorizationConfidentialityEnum;
import telematik.ws.conn.phrs.phrmanagementservice.xsd.v2_0.AuthorizationConfiguration;
import telematik.ws.conn.phrs.phrmanagementservice.xsd.v2_0.DocumentCategoryEnum;
import telematik.ws.conn.phrs.phrmanagementservice.xsd.v2_0.GetAuthorizationState;
import telematik.ws.conn.phrs.phrmanagementservice.xsd.v2_0.RequestFacilityAuthorization;
import telematik.ws.conn.phrs.phrservice.xsd.v2_0.ContextHeader;

public final class PermissionUtils {
    public static final String PS_USER_AGENT = "PS (Simulation)/1.0.0/gematik GmbH";

    public static RequestFacilityAuthorization createRequestFacilityAuthorizationRequest(@NonNull PermissionHcpoRequest permissionHcpoRequest, @NonNull AuthorInstitution leiInstitution, @NonNull CardInfoType egkInfo, @NonNull ContextHeader contextHeader) {
        Objects.requireNonNull(permissionHcpoRequest, "permissionHcpoRequest is marked non-null but is null");
        Objects.requireNonNull(leiInstitution, "leiInstitution is marked non-null but is null");
        Objects.requireNonNull(egkInfo, "egkInfo is marked non-null but is null");
        Objects.requireNonNull(contextHeader, "contextHeader is marked non-null but is null");
        RequestFacilityAuthorization requestFacilityAuthorization = new RequestFacilityAuthorization();
        requestFacilityAuthorization.setContext(contextHeader.getContext());
        requestFacilityAuthorization.setRecordIdentifier(contextHeader.getRecordIdentifier());
        requestFacilityAuthorization.setEhcHandle(egkInfo.getCardHandle());
        requestFacilityAuthorization.setInsurantName(PermissionUtils.insurantNameOf(egkInfo.getCardHolderName()));
        requestFacilityAuthorization.setOrganizationName(leiInstitution.name());
        requestFacilityAuthorization.setAuthorizationConfiguration(PermissionUtils.authorizationConfigurationOf(permissionHcpoRequest));
        return requestFacilityAuthorization;
    }

    public static GetAuthorizationState createRequestGetAuthorizationStateRequest(@NonNull ContextHeader contextHeader) {
        Objects.requireNonNull(contextHeader, "contextHeader is marked non-null but is null");
        GetAuthorizationState requestGetAuthorizationState = new GetAuthorizationState();
        requestGetAuthorizationState.setContext(contextHeader.getContext());
        requestGetAuthorizationState.setRecordIdentifier(contextHeader.getRecordIdentifier());
        requestGetAuthorizationState.setUserAgent(PS_USER_AGENT);
        return requestGetAuthorizationState;
    }

    private static RequestFacilityAuthorization.InsurantName insurantNameOf(@NonNull String fullName) {
        Objects.requireNonNull(fullName, "fullName is marked non-null but is null");
        RequestFacilityAuthorization.InsurantName insurantName = new RequestFacilityAuthorization.InsurantName();
        Pair<String, String> names = StringUtils.getLastAndFirstName(fullName);
        insurantName.setNachname((String)names.getRight());
        insurantName.setVorname((String)names.getLeft());
        return insurantName;
    }

    private static AuthorizationConfiguration authorizationConfigurationOf(@NonNull PermissionHcpoRequest permissionHcpoRequest) {
        Objects.requireNonNull(permissionHcpoRequest, "permissionHcpoRequest is marked non-null but is null");
        AuthorizationConfiguration authorizationConfiguration = new AuthorizationConfiguration();
        authorizationConfiguration.setAuthorizationConfidentiality(Optional.ofNullable(permissionHcpoRequest.authorizedConfidentiality()).map(Confidentiality::getName).map(AuthorizationConfidentialityEnum::fromValue).orElse(AuthorizationConfidentialityEnum.NORMAL));
        authorizationConfiguration.setExpirationDate(Optional.ofNullable(XmlUtils.fromLocalDate(permissionHcpoRequest.expirationDate())).orElse(XmlUtils.fromLocalDate(LocalDate.now().plusDays(7L))));
        authorizationConfiguration.setDocumentCategoryList(PermissionUtils.documentCategoryListOf(permissionHcpoRequest.folderCodes()));
        return authorizationConfiguration;
    }

    private static AuthorizationConfiguration.DocumentCategoryList documentCategoryListOf(Collection<FolderCode> folderCodes) {
        AuthorizationConfiguration.DocumentCategoryList documentCategoryList = new AuthorizationConfiguration.DocumentCategoryList();
        documentCategoryList.getDocumentCategoryElement().addAll(Optional.ofNullable(folderCodes).stream().flatMap(Collection::stream).map(fc -> DocumentCategoryEnum.fromValue((String)fc.getName())).toList());
        return documentCategoryList;
    }

    @Generated
    private PermissionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

