/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.konnektor.client;

import de.gematik.epa.konnektor.KonnektorContextProvider;
import de.gematik.epa.konnektor.KonnektorInterfaceProvider;
import de.gematik.epa.konnektor.KonnektorUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import telematik.ws.conn.cardservice.xsd.v8_1.CardInfoType;
import telematik.ws.conn.cardservicecommon.xsd.v2_0.CardTypeType;
import telematik.ws.conn.eventservice.wsdl.v6_1.EventServicePortType;
import telematik.ws.conn.eventservice.xsd.v6_1.GetCards;
import telematik.ws.conn.eventservice.xsd.v6_1.GetCardsResponse;
import telematik.ws.conn.eventservice.xsd.v6_1.ObjectFactory;

public class EventServiceClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventServiceClient.class);
    private final AtomicReference<Object> eventService = new AtomicReference();
    private final AtomicReference<Object> contextProvider = new AtomicReference();

    public GetCardsResponse getSmbInfo() {
        GetCards request = this.buildGetCards(true, CardTypeType.SM_B);
        return this.getCards(request);
    }

    public CardInfoType getEgkInfoToKvnr(@NonNull String kvnr) {
        Objects.requireNonNull(kvnr, "kvnr is marked non-null but is null");
        GetCards request = this.buildGetCards(true, CardTypeType.EGK);
        GetCardsResponse response = this.getCards(request);
        KonnektorUtils.logWarningIfPresent(log, response.getStatus(), KonnektorUtils.warnMsgWithOperationName("getCards"));
        return response.getCards().getCard().stream().filter(ci -> kvnr.equals(ci.getKvnr())).findFirst().orElse(null);
    }

    public GetCardsResponse getCards(@NonNull GetCards request) {
        Objects.requireNonNull(request, "request is marked non-null but is null");
        return this.eventService().getCards(request);
    }

    private GetCards buildGetCards(boolean mandantWide, CardTypeType cardType) {
        GetCards getCardsRequest = new ObjectFactory().createGetCards();
        getCardsRequest.setCardType(cardType);
        getCardsRequest.setContext(this.contextProvider().getContext());
        getCardsRequest.setMandantWide(Boolean.valueOf(mandantWide));
        return getCardsRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    EventServicePortType eventService() {
        Object value = this.eventService.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.eventService;
            synchronized (atomicReference) {
                value = this.eventService.get();
                if (value == null) {
                    EventServicePortType actualValue = KonnektorInterfaceProvider.defaultInstance().getKonnektorInterfaceAssembly().eventService();
                    value = actualValue == null ? this.eventService : actualValue;
                    this.eventService.set(value);
                }
            }
        }
        return (EventServicePortType)(value == this.eventService ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    KonnektorContextProvider contextProvider() {
        Object value = this.contextProvider.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.contextProvider;
            synchronized (atomicReference) {
                value = this.contextProvider.get();
                if (value == null) {
                    KonnektorContextProvider actualValue = KonnektorContextProvider.defaultInstance();
                    value = actualValue == null ? this.contextProvider : actualValue;
                    this.contextProvider.set(value);
                }
            }
        }
        return (KonnektorContextProvider)(value == this.contextProvider ? null : value);
    }
}

