/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.konnektor.client;

import de.gematik.epa.konnektor.KonnektorContextProvider;
import de.gematik.epa.konnektor.KonnektorInterfaceProvider;
import de.gematik.epa.utils.CertificateUtils;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import lombok.NonNull;
import telematik.ws.conn.cardservice.xsd.v8_1.CardInfoType;
import telematik.ws.conn.certificateservice.wsdl.v6_0.CertificateServicePortType;
import telematik.ws.conn.certificateservice.xsd.v6_0.ObjectFactory;
import telematik.ws.conn.certificateservice.xsd.v6_0.ReadCardCertificate;
import telematik.ws.conn.certificateservice.xsd.v6_0.ReadCardCertificateResponse;
import telematik.ws.conn.certificateservicecommon.xsd.v2_0.CertRefEnum;
import telematik.ws.conn.certificateservicecommon.xsd.v2_0.X509DataInfoListType;

public class CertificateServiceClient {
    private final AtomicReference<Object> certificateService = new AtomicReference();
    private final AtomicReference<Object> contextProvider = new AtomicReference();

    public ReadCardCertificateResponse readCardCertificate(@NonNull ReadCardCertificate request) {
        Objects.requireNonNull(request, "request is marked non-null but is null");
        return this.certificateService().readCardCertificate(request);
    }

    public String getTelematikIdToCard(@NonNull CardInfoType card) {
        Objects.requireNonNull(card, "card is marked non-null but is null");
        ReadCardCertificate cardCertRequest = this.buildReadCardCertificateRequest(card, CertRefEnum.C_AUT);
        ReadCardCertificateResponse cardCertResponse = this.readCardCertificate(cardCertRequest);
        byte[] certificate = Optional.ofNullable(cardCertResponse).map(ReadCardCertificateResponse::getX509DataInfoList).map(X509DataInfoListType::getX509DataInfo).stream().flatMap(Collection::stream).map(X509DataInfoListType.X509DataInfo::getX509Data).map(X509DataInfoListType.X509DataInfo.X509Data::getX509Certificate).findFirst().orElseThrow(() -> new NoSuchElementException("No AUT certificate in readCardCertificate response for card: " + card));
        X509Certificate cert = Objects.requireNonNull(CertificateUtils.toX509Certificate(certificate), "AUT certificate data could not be decoded as X509 certificate");
        return CertificateUtils.getTelematikIdFromCertificate(cert);
    }

    private ReadCardCertificate buildReadCardCertificateRequest(CardInfoType cardInfo, CertRefEnum certRef) {
        ReadCardCertificate.CertRefList certRefList = new ObjectFactory().createReadCardCertificateCertRefList();
        certRefList.getCertRef().add(certRef);
        ReadCardCertificate readCardCertificateRequest = new ObjectFactory().createReadCardCertificate();
        readCardCertificateRequest.setCardHandle(cardInfo.getCardHandle());
        readCardCertificateRequest.setCertRefList(certRefList);
        readCardCertificateRequest.setContext(this.contextProvider().getContext());
        return readCardCertificateRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    CertificateServicePortType certificateService() {
        Object value = this.certificateService.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.certificateService;
            synchronized (atomicReference) {
                value = this.certificateService.get();
                if (value == null) {
                    CertificateServicePortType actualValue = KonnektorInterfaceProvider.defaultInstance().getKonnektorInterfaceAssembly().certificateService();
                    value = actualValue == null ? this.certificateService : actualValue;
                    this.certificateService.set(value);
                }
            }
        }
        return (CertificateServicePortType)(value == this.certificateService ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    KonnektorContextProvider contextProvider() {
        Object value = this.contextProvider.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.contextProvider;
            synchronized (atomicReference) {
                value = this.contextProvider.get();
                if (value == null) {
                    KonnektorContextProvider actualValue = KonnektorContextProvider.defaultInstance();
                    value = actualValue == null ? this.contextProvider : actualValue;
                    this.contextProvider.set(value);
                }
            }
        }
        return (KonnektorContextProvider)(value == this.contextProvider ? null : value);
    }
}

