/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.konnektor;

import de.gematik.epa.data.SmbInformation;
import de.gematik.epa.ihe.model.simple.AuthorInstitution;
import de.gematik.epa.konnektor.client.CertificateServiceClient;
import de.gematik.epa.konnektor.client.EventServiceClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import telematik.ws.conn.cardservice.xsd.v8_1.CardInfoType;

public class SmbInformationProvider {
    private static final AtomicReference<Object> defaultInstance = new AtomicReference();
    private final AtomicReference<Object> eventServiceClient = new AtomicReference();
    private final AtomicReference<Object> certificateServiceClient = new AtomicReference();
    private final Map<String, SmbInformation> knownSmb = new ConcurrentHashMap<String, SmbInformation>();

    public List<SmbInformation> getSmbInformations() {
        List insertedSmbs = this.eventServiceClient().getSmbInfo().getCards().getCard();
        List<CardInfoType> unknownSmbs = insertedSmbs.stream().filter(cardInfo -> !this.knownSmb.containsKey(cardInfo.getIccsn())).toList();
        unknownSmbs.stream().map(this::retrieveSmbInformation).forEach(smbInfo -> this.knownSmb.put(smbInfo.iccsn(), (SmbInformation)smbInfo));
        return insertedSmbs.stream().map(cardInfo -> this.knownSmb.get(cardInfo.getIccsn())).toList();
    }

    public List<AuthorInstitution> getAuthorInstitutions() {
        return this.getSmbInformations().stream().map(SmbInformationProvider::smbInformationToAuthorInstitution).toList();
    }

    public AuthorInstitution getOneAuthorInstitution() {
        return this.getAuthorInstitutions().stream().findFirst().orElse(null);
    }

    private SmbInformation retrieveSmbInformation(CardInfoType cardInfo) {
        String telematikId = this.certificateServiceClient().getTelematikIdToCard(cardInfo);
        return new SmbInformation(telematikId, cardInfo.getIccsn(), cardInfo.getCardHolderName());
    }

    private static AuthorInstitution smbInformationToAuthorInstitution(SmbInformation smbInfo) {
        return new AuthorInstitution(smbInfo.cardHolderName(), smbInfo.telematikId());
    }

    @Generated
    private SmbInformationProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static SmbInformationProvider defaultInstance() {
        Object value = defaultInstance.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = defaultInstance;
            synchronized (atomicReference) {
                value = defaultInstance.get();
                if (value == null) {
                    SmbInformationProvider actualValue = new SmbInformationProvider();
                    value = actualValue == null ? defaultInstance : actualValue;
                    defaultInstance.set(value);
                }
            }
        }
        return (SmbInformationProvider)(value == defaultInstance ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public EventServiceClient eventServiceClient() {
        Object value = this.eventServiceClient.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.eventServiceClient;
            synchronized (atomicReference) {
                value = this.eventServiceClient.get();
                if (value == null) {
                    EventServiceClient actualValue = new EventServiceClient();
                    value = actualValue == null ? this.eventServiceClient : actualValue;
                    this.eventServiceClient.set(value);
                }
            }
        }
        return (EventServiceClient)(value == this.eventServiceClient ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public CertificateServiceClient certificateServiceClient() {
        Object value = this.certificateServiceClient.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.certificateServiceClient;
            synchronized (atomicReference) {
                value = this.certificateServiceClient.get();
                if (value == null) {
                    CertificateServiceClient actualValue = new CertificateServiceClient();
                    value = actualValue == null ? this.certificateServiceClient : actualValue;
                    this.certificateServiceClient.set(value);
                }
            }
        }
        return (CertificateServiceClient)(value == this.certificateServiceClient ? null : value);
    }
}

