/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.konnektor;

import de.gematik.epa.dto.response.AuthorizedApplication;
import de.gematik.epa.dto.response.GetAuthorizationStateResponseDTO;
import de.gematik.epa.dto.response.ResponseDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import telematik.ws.conn.connectorcommon.xsd.v5_0.Status;
import telematik.ws.conn.phrs.phrmanagementservice.xsd.v2_0.GetAuthorizationStateResponse;
import telematik.ws.tel.error.telematikerror.xsd.v2_0.Error;

public final class KonnektorUtils {
    public static final String STATUS_OK = "OK";
    public static final String STATUS_WARNING = "Warning";
    private static final UnaryOperator<String> stdWarningLogIntro = operation -> "The Konnektor" + operation + " responded with a warning! Warning:";

    public static String warnMsgWithOperationName(@NonNull String operationName) {
        Objects.requireNonNull(operationName, "operationName is marked non-null but is null");
        return (String)stdWarningLogIntro.apply(" operation " + operationName);
    }

    public static void logWarning(@NonNull Logger logger, @NonNull Status konnektorStatus, String message) {
        Objects.requireNonNull(logger, "logger is marked non-null but is null");
        Objects.requireNonNull(konnektorStatus, "konnektorStatus is marked non-null but is null");
        if (logger.isWarnEnabled()) {
            String msgIntro = Optional.ofNullable(message).map(msg -> msg + ": ").orElse((String)stdWarningLogIntro.apply(""));
            logger.warn("{}\t{}", (Object)msgIntro, (Object)konnektorStatus.getError());
        }
    }

    public static void logWarning(Logger logger, Status konnektorStatus) {
        KonnektorUtils.logWarning(logger, konnektorStatus, null);
    }

    public static void logWarningIfPresent(@NonNull Logger logger, @NonNull Status konnektorStatus, String message) {
        Objects.requireNonNull(logger, "logger is marked non-null but is null");
        Objects.requireNonNull(konnektorStatus, "konnektorStatus is marked non-null but is null");
        if (STATUS_WARNING.equals(konnektorStatus.getResult())) {
            KonnektorUtils.logWarning(logger, konnektorStatus, message);
        }
    }

    public static void logWarningIfPresent(@NonNull Logger logger, @NonNull Status konnektorStatus) {
        Objects.requireNonNull(logger, "logger is marked non-null but is null");
        Objects.requireNonNull(konnektorStatus, "konnektorStatus is marked non-null but is null");
        KonnektorUtils.logWarningIfPresent(logger, konnektorStatus, null);
    }

    public static ResponseDTO fromStatus(@NonNull Status status) {
        Objects.requireNonNull(status, "status is marked non-null but is null");
        return new ResponseDTO(Boolean.valueOf(true), (String)Optional.ofNullable(status.getError()).map(Error::toString).orElse(null));
    }

    public static ResponseDTO fromThrowable(@NonNull Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is marked non-null but is null");
        StringBuilder statusMsgBuilder = new StringBuilder().append(throwable);
        return new ResponseDTO(Boolean.valueOf(false), KonnektorUtils.appendCauses(throwable, statusMsgBuilder).toString());
    }

    public static GetAuthorizationStateResponseDTO getAuthorizationStateResponse(@NonNull GetAuthorizationStateResponse response) {
        List authorizedApplicationList;
        Objects.requireNonNull(response, "response is marked non-null but is null");
        ArrayList authorizedApplications = new ArrayList();
        GetAuthorizationStateResponse.AuthorizationStatusList authorizationStatusList = response.getAuthorizationStatusList();
        if (authorizationStatusList != null && (authorizedApplicationList = authorizationStatusList.getAuthorizedApplication()) != null) {
            authorizedApplicationList.forEach(authorizedApplicationType -> {
                AuthorizedApplication authorizedApplication = new AuthorizedApplication(authorizedApplicationType.getApplicationName(), authorizedApplicationType.getValidTo().toGregorianCalendar().toZonedDateTime().toLocalDate());
                authorizedApplications.add(authorizedApplication);
            });
        }
        return new GetAuthorizationStateResponseDTO(Boolean.valueOf(true), (String)Optional.ofNullable(response.getStatus().getError()).map(Error::toString).orElse(null), authorizedApplications);
    }

    private static StringBuilder appendCauses(Throwable throwable, StringBuilder builder) {
        Throwable cause = throwable.getCause();
        while (Objects.nonNull(cause)) {
            builder.append(";\t").append(cause);
            cause = cause.getCause();
        }
        return builder;
    }

    @Generated
    private KonnektorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

