/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.konnektor;

import de.gematik.epa.context.ContextHeaderAdapter;
import de.gematik.epa.context.ContextHeaderBuilder;
import de.gematik.epa.context.RecordIdentifierImpl;
import de.gematik.epa.data.Context;
import de.gematik.epa.konnektor.KonnektorInterfaceProvider;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import lombok.NonNull;
import telematik.ws.conn.connectorcontext.xsd.v2_0.ContextType;
import telematik.ws.conn.phrs.phrmanagementservice.wsdl.v2_0.PHRManagementServicePortType;
import telematik.ws.conn.phrs.phrmanagementservice.xsd.v2_0.GetHomeCommunityID;
import telematik.ws.conn.phrs.phrmanagementservice.xsd.v2_0.ObjectFactory;
import telematik.ws.conn.phrs.phrservice.xsd.v2_0.ContextHeader;
import telematik.ws.fd.phr.phrcommon.xsd.v1_1.InsurantIdType;

public class KonnektorContextProvider {
    private static final AtomicReference<Object> defaultInstance = new AtomicReference();
    private static final AtomicReference<Object> defaultRootId = new AtomicReference();
    private final ThreadLocal<ContextHeaderAdapter> contextHeader = new ThreadLocal();
    private final Map<String, String> hcidCache = new ConcurrentHashMap<String, String>();
    private final AtomicReference<Object> phrManagementService = new AtomicReference();
    private Context konnektorContext;

    public ContextHeaderAdapter createContextHeader(@NonNull String kvnr) {
        Objects.requireNonNull(kvnr, "kvnr is marked non-null but is null");
        ContextHeaderBuilder contextHeaderBuilder = new ContextHeaderBuilder().mandantId(this.konnektorContext.mandantId()).clientSystemId(this.konnektorContext.clientSystemId()).workplaceId(this.konnektorContext.workplaceId()).userId(this.konnektorContext.userId()).extension(kvnr).root(KonnektorContextProvider.defaultRootId());
        contextHeaderBuilder.homeCommunity(this.getHcid(contextHeaderBuilder));
        this.contextHeader.set(contextHeaderBuilder.buildContextHeader());
        return this.getContextHeader();
    }

    public ContextHeaderAdapter getContextHeader() {
        return this.contextHeader.get();
    }

    public ContextType getContext() {
        return Optional.ofNullable(this.getContextHeader()).map(ContextHeader::getContext).or(() -> Optional.ofNullable(this.konnektorContext()).map(konCtx -> new ContextHeaderBuilder().workplaceId(konCtx.workplaceId()).clientSystemId(konCtx.clientSystemId()).mandantId(konCtx.mandantId()).userId(konCtx.userId()).buildContext())).orElseThrow(() -> new MissingResourceException("No context has been set at the ContextProvider", this.getClass().getSimpleName(), "konnektorContext"));
    }

    public RecordIdentifierImpl getRecordIdentifier() {
        return Optional.ofNullable(this.getContextHeader()).map(ContextHeaderAdapter::getRecordIdentifier).orElseThrow(() -> new MissingResourceException("No contextHeader has been created at the ContextProvider", this.getClass().getSimpleName(), "contextHeader"));
    }

    public void removeContextHeader() {
        this.contextHeader.remove();
    }

    private String getHcid(ContextHeaderBuilder contextHeaderBuilder) {
        return this.hcidCache.computeIfAbsent(contextHeaderBuilder.extension(), absentKvnrIdentifier -> {
            GetHomeCommunityID getHomeCommunityIDRequest = new ObjectFactory().createGetHomeCommunityID();
            getHomeCommunityIDRequest.setInsurantID((InsurantIdType)contextHeaderBuilder.buildInsurantId());
            getHomeCommunityIDRequest.setContext(contextHeaderBuilder.buildContext());
            return this.phrManagementService().getHomeCommunityID(getHomeCommunityIDRequest).getHomeCommunityID();
        });
    }

    @Generated
    public KonnektorContextProvider() {
    }

    @Generated
    public Context konnektorContext() {
        return this.konnektorContext;
    }

    @Generated
    public KonnektorContextProvider konnektorContext(Context konnektorContext) {
        this.konnektorContext = konnektorContext;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KonnektorContextProvider)) {
            return false;
        }
        KonnektorContextProvider other = (KonnektorContextProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ThreadLocal<ContextHeaderAdapter> this$contextHeader = this.contextHeader();
        ThreadLocal<ContextHeaderAdapter> other$contextHeader = other.contextHeader();
        if (this$contextHeader == null ? other$contextHeader != null : !this$contextHeader.equals(other$contextHeader)) {
            return false;
        }
        Map<String, String> this$hcidCache = this.hcidCache();
        Map<String, String> other$hcidCache = other.hcidCache();
        if (this$hcidCache == null ? other$hcidCache != null : !((Object)this$hcidCache).equals(other$hcidCache)) {
            return false;
        }
        PHRManagementServicePortType this$phrManagementService = this.phrManagementService();
        PHRManagementServicePortType other$phrManagementService = other.phrManagementService();
        if (this$phrManagementService == null ? other$phrManagementService != null : !this$phrManagementService.equals(other$phrManagementService)) {
            return false;
        }
        Context this$konnektorContext = this.konnektorContext();
        Context other$konnektorContext = other.konnektorContext();
        return !(this$konnektorContext == null ? other$konnektorContext != null : !((Object)this$konnektorContext).equals(other$konnektorContext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KonnektorContextProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ThreadLocal<ContextHeaderAdapter> $contextHeader = this.contextHeader();
        result = result * 59 + ($contextHeader == null ? 43 : $contextHeader.hashCode());
        Map<String, String> $hcidCache = this.hcidCache();
        result = result * 59 + ($hcidCache == null ? 43 : ((Object)$hcidCache).hashCode());
        PHRManagementServicePortType $phrManagementService = this.phrManagementService();
        result = result * 59 + ($phrManagementService == null ? 43 : $phrManagementService.hashCode());
        Context $konnektorContext = this.konnektorContext();
        result = result * 59 + ($konnektorContext == null ? 43 : ((Object)$konnektorContext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KonnektorContextProvider(contextHeader=" + this.contextHeader() + ", hcidCache=" + this.hcidCache() + ", phrManagementService=" + this.phrManagementService() + ", konnektorContext=" + this.konnektorContext() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static KonnektorContextProvider defaultInstance() {
        Object value = defaultInstance.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = defaultInstance;
            synchronized (atomicReference) {
                value = defaultInstance.get();
                if (value == null) {
                    KonnektorContextProvider actualValue = new KonnektorContextProvider();
                    value = actualValue == null ? defaultInstance : actualValue;
                    defaultInstance.set(value);
                }
            }
        }
        return (KonnektorContextProvider)(value == defaultInstance ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static String defaultRootId() {
        Object value = defaultRootId.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = defaultRootId;
            synchronized (atomicReference) {
                value = defaultRootId.get();
                if (value == null) {
                    String actualValue = new InsurantIdType().getRoot();
                    value = actualValue == null ? defaultRootId : actualValue;
                    defaultRootId.set(value);
                }
            }
        }
        return (String)(value == defaultRootId ? null : value);
    }

    @Generated
    protected ThreadLocal<ContextHeaderAdapter> contextHeader() {
        return this.contextHeader;
    }

    @Generated
    protected Map<String, String> hcidCache() {
        return this.hcidCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    protected PHRManagementServicePortType phrManagementService() {
        Object value = this.phrManagementService.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.phrManagementService;
            synchronized (atomicReference) {
                value = this.phrManagementService.get();
                if (value == null) {
                    PHRManagementServicePortType actualValue = KonnektorInterfaceProvider.defaultInstance().getKonnektorInterfaceAssembly().phrManagementService();
                    value = actualValue == null ? this.phrManagementService : actualValue;
                    this.phrManagementService.set(value);
                }
            }
        }
        return (PHRManagementServicePortType)(value == this.phrManagementService ? null : value);
    }
}

