/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.config;

import de.gematik.epa.config.DefaultdataInterface;
import de.gematik.epa.data.AuthorInstitutionConfiguration;
import de.gematik.epa.data.AuthorPerson;
import de.gematik.epa.data.SubmissionSetAuthorConfiguration;
import de.gematik.epa.ihe.model.Author;
import de.gematik.epa.ihe.model.document.DocumentInterface;
import de.gematik.epa.ihe.model.document.DocumentMetadata;
import de.gematik.epa.ihe.model.simple.AuthorInstitution;
import de.gematik.epa.konnektor.SmbInformationProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import lombok.NonNull;

public class DefaultdataProvider
implements DefaultdataInterface {
    private static final AtomicReference<Object> defaultInstance = new AtomicReference();
    private DefaultdataInterface defaultdata;

    public Author getSubmissionSetAuthor(List<? extends DocumentInterface> documents) {
        Author firstDocumentAuthor = this.getFirstValidAuthorFromDocuments(documents);
        if (Optional.ofNullable(this.submissionSetAuthorConfiguration()).map(SubmissionSetAuthorConfiguration::useFirstDocumentAuthor).orElse(true).booleanValue()) {
            return firstDocumentAuthor;
        }
        return this.getSubmissionSetAuthorFromConfig(firstDocumentAuthor);
    }

    private Author getSubmissionSetAuthorFromConfig(Author firstDocumentAuthor) {
        AuthorInstitution authorInstitution = this.getAuthorInstitutionFromConfig();
        AuthorPerson authorPerson = Optional.ofNullable(this.submissionSetAuthorConfiguration()).map(SubmissionSetAuthorConfiguration::authorPerson).orElse(new AuthorPerson(null, null, null, null, null, null));
        String authorRole = Optional.ofNullable(firstDocumentAuthor).map(Author::authorRole).stream().flatMap(Collection::stream).findFirst().or(() -> Optional.ofNullable(this.submissionSetAuthorConfiguration()).map(SubmissionSetAuthorConfiguration::authorRoleDefault)).orElse(null);
        return new Author(authorPerson.identifier(), authorPerson.familyName(), authorPerson.givenName(), authorPerson.otherName(), authorPerson.nameAffix(), authorPerson.title(), Collections.singletonList(authorInstitution), Collections.singletonList(authorRole), null, null);
    }

    private AuthorInstitution getAuthorInstitutionFromConfig() {
        if (Optional.ofNullable(this.submissionSetAuthorConfiguration()).map(SubmissionSetAuthorConfiguration::authorInstitutionConfiguration).map(AuthorInstitutionConfiguration::retrieveFromSmb).orElse(true).booleanValue()) {
            return SmbInformationProvider.defaultInstance().getOneAuthorInstitution();
        }
        return Optional.ofNullable(this.submissionSetAuthorConfiguration()).map(SubmissionSetAuthorConfiguration::authorInstitutionConfiguration).map(AuthorInstitutionConfiguration::authorInstitution).orElse(null);
    }

    private Author getFirstValidAuthorFromDocuments(@NonNull List<? extends DocumentInterface> documents) {
        Objects.requireNonNull(documents, "documents is marked non-null but is null");
        return documents.stream().map(DocumentInterface::documentMetadata).map(DocumentMetadata::author).flatMap(Collection::stream).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static DefaultdataProvider defaultInstance() {
        Object value = defaultInstance.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = defaultInstance;
            synchronized (atomicReference) {
                value = defaultInstance.get();
                if (value == null) {
                    DefaultdataProvider actualValue = new DefaultdataProvider();
                    value = actualValue == null ? defaultInstance : actualValue;
                    defaultInstance.set(value);
                }
            }
        }
        return (DefaultdataProvider)(value == defaultInstance ? null : value);
    }

    @Generated
    public DefaultdataInterface defaultdata() {
        return this.defaultdata;
    }

    @Generated
    public DefaultdataProvider defaultdata(DefaultdataInterface defaultdata) {
        this.defaultdata = defaultdata;
        return this;
    }

    @Override
    @Generated
    public SubmissionSetAuthorConfiguration submissionSetAuthorConfiguration() {
        return this.defaultdata().submissionSetAuthorConfiguration();
    }
}

