/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.api.impl;

import de.gematik.epa.api.PermissionApi;
import de.gematik.epa.context.ContextHeaderAdapter;
import de.gematik.epa.dto.request.GetAuthorizationStateRequest;
import de.gematik.epa.dto.request.PermissionHcpoRequest;
import de.gematik.epa.dto.response.GetAuthorizationStateResponseDTO;
import de.gematik.epa.dto.response.ResponseDTO;
import de.gematik.epa.ihe.model.simple.AuthorInstitution;
import de.gematik.epa.konnektor.KonnektorContextProvider;
import de.gematik.epa.konnektor.KonnektorUtils;
import de.gematik.epa.konnektor.SmbInformationProvider;
import de.gematik.epa.konnektor.client.EventServiceClient;
import de.gematik.epa.konnektor.client.PhrManagementClient;
import de.gematik.epa.konnektor.conversion.PermissionUtils;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import telematik.ws.conn.cardservice.xsd.v8_1.CardInfoType;
import telematik.ws.conn.phrs.phrmanagementservice.xsd.v2_0.GetAuthorizationState;
import telematik.ws.conn.phrs.phrmanagementservice.xsd.v2_0.GetAuthorizationStateResponse;
import telematik.ws.conn.phrs.phrmanagementservice.xsd.v2_0.RequestFacilityAuthorization;
import telematik.ws.conn.phrs.phrmanagementservice.xsd.v2_0.RequestFacilityAuthorizationResponse;

public class PermissionApiImpl
implements PermissionApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PermissionApiImpl.class);
    private final KonnektorContextProvider contextProvider;
    private final EventServiceClient eventServiceClient;
    private final SmbInformationProvider smbInformationProvider;
    private final PhrManagementClient phrMgmtClient;

    public ResponseDTO permissionHcpo(PermissionHcpoRequest request) {
        try {
            log.info("Running operation permissionHcpo");
            ContextHeaderAdapter contextHeader = Objects.requireNonNull(this.contextProvider.createContextHeader(request.kvnr()), "No contextHeader could be created using KVNR " + Objects.toString(request.kvnr(), "null"));
            CardInfoType egkInfo = Objects.requireNonNull(this.eventServiceClient.getEgkInfoToKvnr(request.kvnr()), "No egkInfo could be retrieved for KVNR " + Objects.toString(request.kvnr(), "null"));
            AuthorInstitution leiInstitutionInfo = Objects.requireNonNull(this.smbInformationProvider.getOneAuthorInstitution(), "No Leistungserbringer Institution information could be retrieved");
            RequestFacilityAuthorization konRequest = PermissionUtils.createRequestFacilityAuthorizationRequest(request, leiInstitutionInfo, egkInfo, contextHeader);
            RequestFacilityAuthorizationResponse konResponse = this.phrMgmtClient.requestFacilityAuthorization(konRequest);
            return KonnektorUtils.fromStatus(konResponse.getStatus());
        }
        catch (Exception e) {
            log.error("The operation permissionHcpo failed because an exception was thrown", (Throwable)e);
            return KonnektorUtils.fromThrowable(e);
        }
    }

    public GetAuthorizationStateResponseDTO getAuthorizationState(GetAuthorizationStateRequest request) {
        try {
            log.info("Running operation getAuthorizationState");
            ContextHeaderAdapter contextHeader = Objects.requireNonNull(this.contextProvider.createContextHeader(request.kvnr()), "No contextHeader could be created using KVNR " + Objects.toString(request.kvnr(), "null"));
            GetAuthorizationState konRequest = PermissionUtils.createRequestGetAuthorizationStateRequest(contextHeader);
            GetAuthorizationStateResponse konResponse = this.phrMgmtClient.requestGetAuthorizationState(konRequest);
            return KonnektorUtils.getAuthorizationStateResponse(konResponse);
        }
        catch (Exception e) {
            log.error("The operation GetAuthorizationState failed because an exception was thrown", (Throwable)e);
            return new GetAuthorizationStateResponseDTO(KonnektorUtils.fromThrowable(e));
        }
    }

    @Generated
    public PermissionApiImpl(KonnektorContextProvider contextProvider, EventServiceClient eventServiceClient, SmbInformationProvider smbInformationProvider, PhrManagementClient phrMgmtClient) {
        this.contextProvider = contextProvider;
        this.eventServiceClient = eventServiceClient;
        this.smbInformationProvider = smbInformationProvider;
        this.phrMgmtClient = phrMgmtClient;
    }

    @Generated
    public KonnektorContextProvider contextProvider() {
        return this.contextProvider;
    }

    @Generated
    public EventServiceClient eventServiceClient() {
        return this.eventServiceClient;
    }

    @Generated
    public SmbInformationProvider smbInformationProvider() {
        return this.smbInformationProvider;
    }

    @Generated
    public PhrManagementClient phrMgmtClient() {
        return this.phrMgmtClient;
    }
}

