/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.api.impl;

import de.gematik.epa.api.DocumentsApi;
import de.gematik.epa.config.DefaultdataProvider;
import de.gematik.epa.context.ContextHeaderAdapter;
import de.gematik.epa.conversion.AdhocQueryUtils;
import de.gematik.epa.conversion.DeleteObjectsUtils;
import de.gematik.epa.conversion.ProvideAndRegisterUtils;
import de.gematik.epa.conversion.ResponseUtils;
import de.gematik.epa.conversion.RetrieveDocumentsUtils;
import de.gematik.epa.dto.request.DeleteObjectsRequestDTO;
import de.gematik.epa.dto.request.FindRequestDTO;
import de.gematik.epa.dto.request.PutDocumentsRequestDTO;
import de.gematik.epa.dto.request.ReplaceDocumentsRequestDTO;
import de.gematik.epa.dto.request.RetrieveDocumentsRequestDTO;
import de.gematik.epa.dto.response.FindObjectsResponseDTO;
import de.gematik.epa.dto.response.ResponseDTO;
import de.gematik.epa.dto.response.RetrieveDocumentsResponseDTO;
import de.gematik.epa.ihe.model.document.DocumentInterface;
import de.gematik.epa.ihe.model.request.DeleteObjectsRequest;
import de.gematik.epa.ihe.model.request.DocumentReplaceRequest;
import de.gematik.epa.ihe.model.request.DocumentSubmissionRequest;
import de.gematik.epa.ihe.model.request.FindRequest;
import de.gematik.epa.ihe.model.request.RetrieveDocumentsRequest;
import de.gematik.epa.ihe.model.request.SubmissionRequestInterface;
import de.gematik.epa.ihe.model.response.ProxyFindResponse;
import de.gematik.epa.ihe.model.response.ProxyResponse;
import de.gematik.epa.ihe.model.response.RetrieveDocumentsResponse;
import de.gematik.epa.ihe.model.simple.RecordIdentifier;
import de.gematik.epa.ihe.model.simple.SubmissionSetMetadata;
import de.gematik.epa.konnektor.KonnektorContextProvider;
import de.gematik.epa.konnektor.KonnektorInterfaceProvider;
import de.gematik.epa.konnektor.KonnektorUtils;
import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import oasis.names.tc.ebxml_regrep.xsd.lcm._3.RemoveObjectsRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import telematik.ws.conn.phrs.phrservice.wsdl.v2_0.PHRServicePortType;
import telematik.ws.conn.phrs.phrservice.xsd.v2_0.ContextHeader;

public class DocumentApiImpl
implements DocumentsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentApiImpl.class);
    private final AtomicReference<Object> interfaceProvider = new AtomicReference();
    private final AtomicReference<Object> contextProvider = new AtomicReference();
    private final AtomicReference<Object> defaultdataProvider = new AtomicReference();
    private final AtomicReference<Object> phrServiceClient = new AtomicReference();

    public ResponseDTO putDocuments(PutDocumentsRequestDTO request) {
        try {
            log.info("Running operation putDocuments");
            ContextHeaderAdapter contextHeader = this.contextProvider().createContextHeader(request.kvnr());
            ProvideAndRegisterDocumentSetRequestType provideAndRegisterRequest = ProvideAndRegisterUtils.toProvideAndRegisterDocumentSetRequest((SubmissionRequestInterface)this.getDocumentSubmissionRequest(request, contextHeader));
            RegistryResponseType provideAndRegisterResponse = this.phrServiceClient().documentRepositoryProvideAndRegisterDocumentSetB((ContextHeader)contextHeader, provideAndRegisterRequest);
            return this.toResponseDto(provideAndRegisterResponse);
        }
        catch (Exception e) {
            log.error("Operation putDocuments failed with an exception", (Throwable)e);
            return KonnektorUtils.fromThrowable(e);
        }
    }

    public RetrieveDocumentsResponseDTO getDocuments(RetrieveDocumentsRequestDTO request) {
        try {
            log.info("Running operation getDocuments");
            ContextHeaderAdapter contextHeader = this.contextProvider().createContextHeader(request.kvnr());
            RetrieveDocumentSetRequestType iheRequest = RetrieveDocumentsUtils.toRetrieveDocumentSetRequest((RetrieveDocumentsRequest)this.toRetrieveDocumentsRequest(request, contextHeader));
            RetrieveDocumentSetResponseType iheResponse = this.phrServiceClient().documentRepositoryRetrieveDocumentSet((ContextHeader)contextHeader, iheRequest);
            return this.toRetrieveDocumentsResponseDto(iheResponse);
        }
        catch (Exception e) {
            log.error("Operation getDocuments failed with an exception", (Throwable)e);
            return this.toRetrieveDocumentsResponseDto(KonnektorUtils.fromThrowable(e));
        }
    }

    public ResponseDTO deleteObjects(DeleteObjectsRequestDTO request) {
        try {
            log.info("Running operation deleteObjects");
            ContextHeaderAdapter contextHeader = this.contextProvider().createContextHeader(request.kvnr());
            RemoveObjectsRequest iheRequest = DeleteObjectsUtils.toRemoveObjectsRequest((DeleteObjectsRequest)this.toDeleteObjectRequest(request));
            RegistryResponseType iheResponse = this.phrServiceClient().documentRegistryDeleteDocumentSet((ContextHeader)contextHeader, iheRequest);
            return this.toResponseDto(iheResponse);
        }
        catch (Exception e) {
            log.error("Operation deleteObjects failed with an exception", (Throwable)e);
            return KonnektorUtils.fromThrowable(e);
        }
    }

    public FindObjectsResponseDTO find(FindRequestDTO dto) {
        try {
            log.info("Running operation find");
            ContextHeaderAdapter contextHeader = this.contextProvider().createContextHeader(dto.kvnr());
            FindRequest request = this.toFindRequest(dto, contextHeader);
            AdhocQueryRequest fmRequestBody = AdhocQueryUtils.generateFindRequestBody((FindRequest)request);
            AdhocQueryResponse fmResponse = this.phrServiceClient().documentRegistryRegistryStoredQuery((ContextHeader)contextHeader, fmRequestBody);
            return this.getFindResponseDTO(ResponseUtils.toProxyFindResponse((AdhocQueryResponse)fmResponse));
        }
        catch (Exception e) {
            log.error("Operation find failed with an exception", (Throwable)e);
            return this.toFindObjectsResponseDto(KonnektorUtils.fromThrowable(e));
        }
    }

    public ResponseDTO replaceDocuments(ReplaceDocumentsRequestDTO request) {
        try {
            log.info("Running operation replaceDocuments");
            ContextHeaderAdapter contextHeader = this.contextProvider().createContextHeader(request.kvnr());
            ProvideAndRegisterDocumentSetRequestType provideAndRegisterRequest = ProvideAndRegisterUtils.toProvideAndRegisterDocumentSetRequest((SubmissionRequestInterface)this.getDocumentReplaceRequest(request, contextHeader));
            RegistryResponseType provideAndRegisterResponse = this.phrServiceClient().documentRepositoryProvideAndRegisterDocumentSetB((ContextHeader)contextHeader, provideAndRegisterRequest);
            return this.toResponseDto(provideAndRegisterResponse);
        }
        catch (Exception e) {
            log.error("Operation replaceDocuments failed with an exception", (Throwable)e);
            return KonnektorUtils.fromThrowable(e);
        }
    }

    private FindObjectsResponseDTO getFindResponseDTO(ProxyFindResponse proxyFindResponse) {
        return new FindObjectsResponseDTO(proxyFindResponse.success(), proxyFindResponse.statusMessage(), proxyFindResponse.registryObjectLists());
    }

    private ResponseDTO getResponseDTO(ProxyResponse proxyResponse) {
        return new ResponseDTO(proxyResponse.success(), proxyResponse.statusMessage());
    }

    private RetrieveDocumentsResponseDTO toRetrieveDocumentsResponseDto(RetrieveDocumentSetResponseType iheResponse) {
        RetrieveDocumentsResponse proxyResponse = ResponseUtils.toRetrieveDocumentResponse((RetrieveDocumentSetResponseType)iheResponse);
        return new RetrieveDocumentsResponseDTO(proxyResponse.success(), proxyResponse.statusMessage(), proxyResponse.documents());
    }

    private RetrieveDocumentsResponseDTO toRetrieveDocumentsResponseDto(ResponseDTO responseDTO) {
        return new RetrieveDocumentsResponseDTO(responseDTO.success(), responseDTO.statusMessage(), List.of());
    }

    private ResponseDTO toResponseDto(RegistryResponseType iheResponse) {
        ProxyResponse proxyResponse = ResponseUtils.toProxyResponse((RegistryResponseType)iheResponse);
        return this.getResponseDTO(proxyResponse);
    }

    private FindObjectsResponseDTO toFindObjectsResponseDto(ResponseDTO responseDTO) {
        return new FindObjectsResponseDTO(responseDTO.success(), responseDTO.statusMessage(), null);
    }

    private FindRequest toFindRequest(FindRequestDTO dto, ContextHeaderAdapter contextHeader) {
        return new FindRequest((RecordIdentifier)contextHeader.getRecordIdentifier(), dto.returnType(), dto.query(), dto.queryData());
    }

    private DocumentSubmissionRequest getDocumentSubmissionRequest(PutDocumentsRequestDTO request, ContextHeaderAdapter contextHeader) {
        return new DocumentSubmissionRequest((RecordIdentifier)contextHeader.getRecordIdentifier(), request.documentSets(), this.getSubmissionSetMetadata(request.documentSets()));
    }

    private DocumentReplaceRequest getDocumentReplaceRequest(ReplaceDocumentsRequestDTO request, ContextHeaderAdapter contextHeader) {
        return new DocumentReplaceRequest((RecordIdentifier)contextHeader.getRecordIdentifier(), request.documentSets(), this.getSubmissionSetMetadata(request.documentSets()));
    }

    private SubmissionSetMetadata getSubmissionSetMetadata(List<? extends DocumentInterface> documentSet) {
        return new SubmissionSetMetadata(Collections.singletonList(this.defaultdataProvider().getSubmissionSetAuthor(documentSet)), null, LocalDateTime.now(), null, null, null);
    }

    private RetrieveDocumentsRequest toRetrieveDocumentsRequest(RetrieveDocumentsRequestDTO psRequest, ContextHeader contextHeader) {
        return new RetrieveDocumentsRequest(contextHeader.getRecordIdentifier().getHomeCommunityId(), psRequest.documentUniqueIds());
    }

    private DeleteObjectsRequest toDeleteObjectRequest(DeleteObjectsRequestDTO psRequest) {
        return new DeleteObjectsRequest(psRequest.entryUUIDs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    protected KonnektorInterfaceProvider interfaceProvider() {
        Object value = this.interfaceProvider.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.interfaceProvider;
            synchronized (atomicReference) {
                value = this.interfaceProvider.get();
                if (value == null) {
                    KonnektorInterfaceProvider actualValue = KonnektorInterfaceProvider.defaultInstance();
                    value = actualValue == null ? this.interfaceProvider : actualValue;
                    this.interfaceProvider.set(value);
                }
            }
        }
        return (KonnektorInterfaceProvider)(value == this.interfaceProvider ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    protected KonnektorContextProvider contextProvider() {
        Object value = this.contextProvider.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.contextProvider;
            synchronized (atomicReference) {
                value = this.contextProvider.get();
                if (value == null) {
                    KonnektorContextProvider actualValue = KonnektorContextProvider.defaultInstance();
                    value = actualValue == null ? this.contextProvider : actualValue;
                    this.contextProvider.set(value);
                }
            }
        }
        return (KonnektorContextProvider)(value == this.contextProvider ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    protected DefaultdataProvider defaultdataProvider() {
        Object value = this.defaultdataProvider.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.defaultdataProvider;
            synchronized (atomicReference) {
                value = this.defaultdataProvider.get();
                if (value == null) {
                    DefaultdataProvider actualValue = DefaultdataProvider.defaultInstance();
                    value = actualValue == null ? this.defaultdataProvider : actualValue;
                    this.defaultdataProvider.set(value);
                }
            }
        }
        return (DefaultdataProvider)(value == this.defaultdataProvider ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    protected PHRServicePortType phrServiceClient() {
        Object value = this.phrServiceClient.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.phrServiceClient;
            synchronized (atomicReference) {
                value = this.phrServiceClient.get();
                if (value == null) {
                    PHRServicePortType actualValue = this.interfaceProvider().getKonnektorInterfaceAssembly().phrService();
                    value = actualValue == null ? this.phrServiceClient : actualValue;
                    this.phrServiceClient.set(value);
                }
            }
        }
        return (PHRServicePortType)(value == this.phrServiceClient ? null : value);
    }
}

