/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.ps.utils;

import de.gematik.epa.utils.ThrowingPredicate;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SpringUtils {
    public static Resource findReadableResource(@NonNull ResourceLoader resourceLoader, @NonNull String resourcePath) {
        Objects.requireNonNull(resourceLoader, "resourceLoader is marked non-null but is null");
        Objects.requireNonNull(resourcePath, "resourcePath is marked non-null but is null");
        return Optional.ofNullable(SpringUtils.getReadableFileResource((ResourceLoader)resourceLoader, (String)resourcePath)).or(() -> Optional.ofNullable(SpringUtils.getReadableFileResource((ResourceLoader)resourceLoader, (String)("classpath:" + resourcePath)))).or(() -> Optional.ofNullable(SpringUtils.findReadableFileResource((String)resourcePath))).orElseThrow(() -> new MissingResourceException("Resource " + resourcePath + " could not be found", resourcePath, resourcePath));
    }

    private static Resource getReadableFileResource(ResourceLoader resourceLoader, String resourcePath) {
        Resource resource = resourceLoader.getResource(resourcePath);
        if (resource.exists() && resource.isReadable()) {
            return resource;
        }
        return null;
    }

    private static Resource findReadableFileResource(String resourcePath) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources("classpath:**");
        return Arrays.stream(resources).filter(resource -> Objects.nonNull(resource.getFilename())).filter((Predicate<Resource>)((ThrowingPredicate)resource -> resource.getURL().toString().endsWith(resourcePath))).filter(Resource::isReadable).findFirst().orElse(null);
    }

    @Generated
    private SpringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

