/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.ps.konnektor.impl;

import de.gematik.epa.konnektor.KonnektorContextProvider;
import de.gematik.epa.konnektor.KonnektorInterfaceAssembly;
import de.gematik.epa.konnektor.KonnektorInterfaceProvider;
import de.gematik.epa.ps.konnektor.config.BasicAuthenticationConfig;
import de.gematik.epa.ps.konnektor.config.KonnektorConfiguration;
import de.gematik.epa.ps.konnektor.config.KonnektorConnectionConfiguration;
import de.gematik.epa.ps.konnektor.config.ProxyAddressConfig;
import de.gematik.epa.ps.konnektor.config.TlsConfig;
import de.gematik.epa.ps.konnektor.impl.KonnektorInterfaceAssemblyRecord;
import de.gematik.epa.ps.konnektor.impl.KonnektorInterfaceImplGenerator;
import de.gematik.epa.ps.konnektor.impl.xml.ObjectFactory;
import de.gematik.epa.ps.konnektor.interceptors.HomeCommunityBlockOutInterceptor;
import de.gematik.epa.ps.konnektor.interceptors.MtomConfigOutInterceptor;
import de.gematik.epa.ps.utils.SpringUtils;
import jakarta.annotation.PostConstruct;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import lombok.Generated;
import lombok.NonNull;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import telematik.ws.conn.SdsApi;
import telematik.ws.conn.cardservice.wsdl.v8_1.CardService;
import telematik.ws.conn.cardservice.wsdl.v8_1.CardServicePortType;
import telematik.ws.conn.certificateservice.wsdl.v6_0.CertificateService;
import telematik.ws.conn.certificateservice.wsdl.v6_0.CertificateServicePortType;
import telematik.ws.conn.eventservice.wsdl.v6_1.EventService;
import telematik.ws.conn.eventservice.wsdl.v6_1.EventServicePortType;
import telematik.ws.conn.phrs.phrmanagementservice.wsdl.v2_0.PHRManagementService;
import telematik.ws.conn.phrs.phrmanagementservice.wsdl.v2_0.PHRManagementServicePortType;
import telematik.ws.conn.phrs.phrservice.wsdl.v2_0.PHRService;
import telematik.ws.conn.phrs.phrservice.wsdl.v2_0.PHRServicePortType;
import telematik.ws.conn.servicedirectory.xsd.v3_1.ConnectorServices;
import telematik.ws.conn.serviceinformation.xsd.v2_0.EndpointType;
import telematik.ws.conn.signatureservice.wsdl.v7_5.SignatureService;
import telematik.ws.conn.signatureservice.wsdl.v7_5.SignatureServicePortType;

@Configuration
@Profile(value={"!test"})
public class KonnektorInterfaceImplGenerator
implements KonnektorInterfaceProvider.KonnektorInterfaceProviderCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KonnektorInterfaceImplGenerator.class);
    public static final String HTTPS_PROTOCOL = "https";
    protected final KonnektorConfiguration konnektorConfiguration;
    protected final ResourceLoader resourceLoader;
    private final KonnektorContextProvider konnektorContextProvider;
    private final KonnektorInterfaceProvider konnektorInterfaceProvider;
    private final AtomicReference<Object> isTlsPreferred = new AtomicReference();
    private ConnectorServices connectorServices;
    private HomeCommunityBlockOutInterceptor homeCommunityBlockOutInterceptor;
    private MtomConfigOutInterceptor mtomConfigOutInterceptor;

    @Autowired
    public KonnektorInterfaceImplGenerator(KonnektorConfiguration konnektorConfiguration, ResourceLoader resourceLoader, KonnektorContextProvider konnektorContextProvider, KonnektorInterfaceProvider konnektorInterfaceProvider) {
        this.konnektorConfiguration = konnektorConfiguration;
        this.resourceLoader = resourceLoader;
        this.konnektorContextProvider = konnektorContextProvider;
        this.konnektorInterfaceProvider = konnektorInterfaceProvider;
    }

    public KonnektorInterfaceImplGenerator(KonnektorConfiguration konnektorConfiguration, ResourceLoader resourceLoader) {
        this(konnektorConfiguration, resourceLoader, KonnektorContextProvider.defaultInstance(), KonnektorInterfaceProvider.defaultInstance());
    }

    @PostConstruct
    void initialize() {
        this.konnektorContextProvider.konnektorContext(this.konnektorConfiguration.context());
        this.konnektorInterfaceProvider.setKonnektorInterfaceProviderCallback((KonnektorInterfaceProvider.KonnektorInterfaceProviderCallback)this);
    }

    public KonnektorInterfaceAssembly provideInterfaceAssembly() {
        return new KonnektorInterfaceAssemblyRecord(this.phrService(), this.pHRManagementService(), this.eventService(), this.cardService(), this.certificateService(), this.signatureService());
    }

    @Bean
    public ConnectorServices connectorServices() {
        return Optional.ofNullable(this.connectorServices).orElseGet(() -> {
            this.connectorServices = this.sdsApi().getConnectorSds();
            return this.connectorServices;
        });
    }

    @Bean
    public LoggingFeature loggingFeature() {
        LoggingFeature feature = new LoggingFeature();
        1 sender = new /* Unavailable Anonymous Inner Class!! */;
        sender.setLoggingLevel(Level.DEBUG);
        feature.setSender((LogEventSender)sender);
        feature.setPrettyLogging(true);
        feature.setLogBinary(true);
        feature.setLogMultipart(true);
        return feature;
    }

    @Bean
    public HomeCommunityBlockOutInterceptor homeCommunityBlockOutInterceptor() {
        return Optional.ofNullable(this.homeCommunityBlockOutInterceptor).orElseGet(() -> {
            this.homeCommunityBlockOutInterceptor = new HomeCommunityBlockOutInterceptor();
            return this.homeCommunityBlockOutInterceptor;
        });
    }

    @Bean
    public MtomConfigOutInterceptor mtomConfigOutInterceptor() {
        return Optional.ofNullable(this.mtomConfigOutInterceptor).orElseGet(() -> {
            this.mtomConfigOutInterceptor = new MtomConfigOutInterceptor();
            return this.mtomConfigOutInterceptor;
        });
    }

    @Bean(name={"phrService"})
    public PHRServicePortType phrService() {
        return (PHRServicePortType)this.getClientProxyImpl(PHRServicePortType.class, "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true", this.readServiceEndpoint(PHRService.SERVICE.getLocalPart(), new String[]{"2.0.2", "2"}), jaxWsProxyFactory -> {
            jaxWsProxyFactory.getFeatures().add(new WSAddressingFeature());
            jaxWsProxyFactory.getOutInterceptors().add(this.homeCommunityBlockOutInterceptor());
            jaxWsProxyFactory.getOutInterceptors().add(this.mtomConfigOutInterceptor());
        });
    }

    @Bean(name={"phrManagementService"})
    public PHRManagementServicePortType pHRManagementService() {
        return (PHRManagementServicePortType)this.getClientProxyImpl(PHRManagementServicePortType.class, "http://www.w3.org/2003/05/soap/bindings/HTTP/", this.readServiceEndpoint(PHRManagementService.SERVICE.getLocalPart(), new String[]{"2.0.2", "2"}), jaxWsProxyFactory -> jaxWsProxyFactory.getFeatures().add(new WSAddressingFeature()));
    }

    @Bean(name={"signatureService"})
    public SignatureServicePortType signatureService() {
        return (SignatureServicePortType)this.getClientProxyImpl(SignatureServicePortType.class, "http://schemas.xmlsoap.org/wsdl/soap/http", this.readServiceEndpoint(SignatureService.SERVICE.getLocalPart(), new String[]{"7.5", "7"}), ObjectFactory::registerObjectFactory);
    }

    @Bean(name={"eventService"})
    public EventServicePortType eventService() {
        return (EventServicePortType)this.getClientProxyImpl(EventServicePortType.class, "http://schemas.xmlsoap.org/wsdl/soap/http", this.readServiceEndpoint(EventService.SERVICE.getLocalPart(), new String[]{""}));
    }

    @Bean(name={"certificateService"})
    public CertificateServicePortType certificateService() {
        return (CertificateServicePortType)this.getClientProxyImpl(CertificateServicePortType.class, "http://schemas.xmlsoap.org/wsdl/soap/http", this.readServiceEndpoint(CertificateService.SERVICE.getLocalPart(), new String[]{"6.0.1", "6"}));
    }

    @Bean(name={"cardService"})
    public CardServicePortType cardService() {
        return (CardServicePortType)this.getClientProxyImpl(CardServicePortType.class, "http://schemas.xmlsoap.org/wsdl/soap/http", this.readServiceEndpoint(CardService.SERVICE.getLocalPart(), new String[]{"8.1.2", "8.1", "8"}));
    }

    protected SdsApi sdsApi() {
        KonnektorConnectionConfiguration connectCfg = this.konnektorConfiguration.connection();
        JAXRSClientFactoryBean factoryBean = new JAXRSClientFactoryBean();
        factoryBean.setServiceClass(SdsApi.class);
        factoryBean.getFeatures().add(this.loggingFeature());
        factoryBean.setAddress(connectCfg.address().getUrl().toString());
        SdsApi sdsApi = (SdsApi)factoryBean.create(SdsApi.class, new Object[0]);
        WebClient.client((Object)sdsApi).accept(new String[]{"text/xml", "application/xml"});
        HTTPConduit sdsHttpConduit = WebClient.getConfig((Object)sdsApi).getHttpConduit();
        if (this.isTlsPreferred().booleanValue()) {
            this.configureTls(sdsHttpConduit);
        }
        this.configureBasicAuthenticationIfEnabled(sdsHttpConduit);
        this.configureProxyIfEnabled(sdsHttpConduit);
        return sdsApi;
    }

    protected <T> T getClientProxyImpl(@NonNull Class<T> portType, @NonNull String soapBinding, @NonNull String endpointAddress, Consumer<JaxWsProxyFactoryBean> addConf) {
        Objects.requireNonNull(portType, "portType is marked non-null but is null");
        Objects.requireNonNull(soapBinding, "soapBinding is marked non-null but is null");
        Objects.requireNonNull(endpointAddress, "endpointAddress is marked non-null but is null");
        JaxWsProxyFactoryBean jaxWsProxyFactory = new JaxWsProxyFactoryBean();
        jaxWsProxyFactory.setBindingId(soapBinding);
        jaxWsProxyFactory.setServiceClass(portType);
        jaxWsProxyFactory.setAddress(endpointAddress);
        jaxWsProxyFactory.getFeatures().add(this.loggingFeature());
        if (Objects.nonNull(addConf)) {
            addConf.accept(jaxWsProxyFactory);
        }
        Object proxy = jaxWsProxyFactory.create(portType);
        HTTPConduit httpConduit = (HTTPConduit)ClientProxy.getClient((Object)proxy).getConduit();
        if (endpointAddress.startsWith(HTTPS_PROTOCOL)) {
            this.configureTls(httpConduit);
        }
        this.configureBasicAuthenticationIfEnabled(httpConduit);
        this.configureProxyIfEnabled(httpConduit);
        return (T)proxy;
    }

    private void configureTls(HTTPConduit httpConduit) {
        TLSClientParameters tlsParams = new TLSClientParameters();
        tlsParams.setDisableCNCheck(true);
        tlsParams.setTrustManagers(new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */});
        TlsConfig tlsConfig = Objects.requireNonNull(this.konnektorConfiguration.connection().tlsconfig(), "No configuration data present for TLS connection to the Konnektor");
        KeyStore keyStore = KeyStore.getInstance(Objects.requireNonNull(tlsConfig.keystoretype()));
        Resource keystoreResource = SpringUtils.findReadableResource((ResourceLoader)this.resourceLoader, (String)tlsConfig.keystorepath());
        char[] keystorePwd = Objects.requireNonNull(tlsConfig.keystorepassword(), "No password is set in the TLS configuration for the Konnektor connection").toCharArray();
        keyStore.load(keystoreResource.getInputStream(), keystorePwd);
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyFactory.init(keyStore, keystorePwd);
        tlsParams.setKeyManagers(keyFactory.getKeyManagers());
        tlsParams.setCipherSuites(tlsConfig.ciphersuites());
        httpConduit.setTlsClientParameters(tlsParams);
    }

    private void configureBasicAuthenticationIfEnabled(HTTPConduit httpConduit) {
        Optional.ofNullable(this.konnektorConfiguration.connection().basicauthentication()).filter(BasicAuthenticationConfig::enabled).ifPresent(ba -> {
            AuthorizationPolicy authorizationPolicy = new AuthorizationPolicy();
            authorizationPolicy.setUserName(Objects.requireNonNull(ba.username()));
            authorizationPolicy.setPassword(Objects.requireNonNull(ba.password()));
            authorizationPolicy.setAuthorizationType("Basic");
            httpConduit.setAuthorization(authorizationPolicy);
        });
    }

    private void configureProxyIfEnabled(HTTPConduit httpConduit) {
        Optional.ofNullable(this.konnektorConfiguration.connection().proxyaddress()).filter(ProxyAddressConfig::enabled).ifPresent(pa -> {
            httpConduit.getClient().setProxyServer(Objects.requireNonNull(pa.address()));
            httpConduit.getClient().setProxyServerPort(pa.port());
        });
    }

    private <T> T getClientProxyImpl(Class<T> portType, String soapBinding, String endpointAddress) {
        return (T)this.getClientProxyImpl(portType, soapBinding, endpointAddress, null);
    }

    private String readServiceEndpoint(String serviceName, String ... serviceVersionStartsWith) {
        for (String svsw : serviceVersionStartsWith) {
            String endpoint = this.readSingleServiceEndpoint(serviceName, svsw);
            if (!Objects.nonNull(endpoint)) continue;
            return endpoint;
        }
        throw new IllegalArgumentException(String.format("No usable service endpoint configuration found for service %s in version %s", serviceName, Arrays.toString(serviceVersionStartsWith)));
    }

    private String readSingleServiceEndpoint(String serviceName, String serviceVersionStartsWith) {
        return this.connectorServices().getServiceInformation().getService().stream().filter(service -> serviceName.equals(service.getName())).flatMap(service -> service.getVersions().getVersion().stream()).filter(versionedService -> versionedService.getVersion().startsWith(serviceVersionStartsWith)).map(versionedService -> Optional.ofNullable(versionedService.getEndpointTLS()).filter(endpoint -> this.connectorServices().isTLSMandatory() || this.isTlsPreferred() != false).orElse(versionedService.getEndpoint())).map(EndpointType::getLocation).findFirst().orElse(null);
    }

    @Generated
    public KonnektorConfiguration konnektorConfiguration() {
        return this.konnektorConfiguration;
    }

    @Generated
    public ResourceLoader resourceLoader() {
        return this.resourceLoader;
    }

    @Generated
    public KonnektorContextProvider konnektorContextProvider() {
        return this.konnektorContextProvider;
    }

    @Generated
    public KonnektorInterfaceProvider konnektorInterfaceProvider() {
        return this.konnektorInterfaceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Boolean isTlsPreferred() {
        Object value = this.isTlsPreferred.get();
        if (value == null) {
            AtomicReference atomicReference = this.isTlsPreferred;
            synchronized (atomicReference) {
                value = this.isTlsPreferred.get();
                if (value == null) {
                    Boolean actualValue = this.konnektorConfiguration.connection().address().protocol().toLowerCase().startsWith(HTTPS_PROTOCOL);
                    value = actualValue == null ? this.isTlsPreferred : actualValue;
                    this.isTlsPreferred.set(value);
                }
            }
        }
        return value == this.isTlsPreferred ? null : value;
    }
}

