/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.ps.konnektor.config;

import java.util.List;
import lombok.Generated;
import org.springframework.boot.context.properties.bind.DefaultValue;

public record TlsConfig(String keystorepath, String keystorepassword, String keystoretype, List<String> ciphersuites) {
    private final String keystorepath;
    private final String keystorepassword;
    private final String keystoretype;
    private final List<String> ciphersuites;

    public TlsConfig(String keystorepath, String keystorepassword, @DefaultValue(value={"PKCS12"}) String keystoretype, @DefaultValue(value={"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA"}) List<String> ciphersuites) {
        this.keystorepath = keystorepath;
        this.keystorepassword = keystorepassword;
        this.keystoretype = keystoretype;
        this.ciphersuites = ciphersuites;
    }

    @Generated
    public TlsConfig withKeystorepath(String keystorepath) {
        return this.keystorepath == keystorepath ? this : new TlsConfig(keystorepath, this.keystorepassword, this.keystoretype, this.ciphersuites);
    }

    @Generated
    public TlsConfig withKeystorepassword(String keystorepassword) {
        return this.keystorepassword == keystorepassword ? this : new TlsConfig(this.keystorepath, keystorepassword, this.keystoretype, this.ciphersuites);
    }

    @Generated
    public TlsConfig withKeystoretype(String keystoretype) {
        return this.keystoretype == keystoretype ? this : new TlsConfig(this.keystorepath, this.keystorepassword, keystoretype, this.ciphersuites);
    }

    @Generated
    public TlsConfig withCiphersuites(List<String> ciphersuites) {
        return this.ciphersuites == ciphersuites ? this : new TlsConfig(this.keystorepath, this.keystorepassword, this.keystoretype, ciphersuites);
    }

    public String keystorepath() {
        return this.keystorepath;
    }

    public String keystorepassword() {
        return this.keystorepassword;
    }

    public String keystoretype() {
        return this.keystoretype;
    }

    public List<String> ciphersuites() {
        return this.ciphersuites;
    }
}

