/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.ps.konnektor.config;

import de.gematik.epa.ps.konnektor.config.AddressConfig;
import de.gematik.epa.ps.konnektor.config.BasicAuthenticationConfig;
import de.gematik.epa.ps.konnektor.config.ProxyAddressConfig;
import de.gematik.epa.ps.konnektor.config.TlsConfig;
import lombok.Generated;
import org.springframework.boot.context.properties.bind.DefaultValue;

public record KonnektorConnectionConfiguration(AddressConfig address, TlsConfig tlsconfig, ProxyAddressConfig proxyaddress, BasicAuthenticationConfig basicauthentication) {
    private final AddressConfig address;
    private final TlsConfig tlsconfig;
    private final ProxyAddressConfig proxyaddress;
    private final BasicAuthenticationConfig basicauthentication;

    public KonnektorConnectionConfiguration(@DefaultValue AddressConfig address, @DefaultValue TlsConfig tlsconfig, @DefaultValue ProxyAddressConfig proxyaddress, @DefaultValue BasicAuthenticationConfig basicauthentication) {
        this.address = address;
        this.tlsconfig = tlsconfig;
        this.proxyaddress = proxyaddress;
        this.basicauthentication = basicauthentication;
    }

    @Generated
    public KonnektorConnectionConfiguration withAddress(AddressConfig address) {
        return this.address == address ? this : new KonnektorConnectionConfiguration(address, this.tlsconfig, this.proxyaddress, this.basicauthentication);
    }

    @Generated
    public KonnektorConnectionConfiguration withTlsconfig(TlsConfig tlsconfig) {
        return this.tlsconfig == tlsconfig ? this : new KonnektorConnectionConfiguration(this.address, tlsconfig, this.proxyaddress, this.basicauthentication);
    }

    @Generated
    public KonnektorConnectionConfiguration withProxyaddress(ProxyAddressConfig proxyaddress) {
        return this.proxyaddress == proxyaddress ? this : new KonnektorConnectionConfiguration(this.address, this.tlsconfig, proxyaddress, this.basicauthentication);
    }

    @Generated
    public KonnektorConnectionConfiguration withBasicauthentication(BasicAuthenticationConfig basicauthentication) {
        return this.basicauthentication == basicauthentication ? this : new KonnektorConnectionConfiguration(this.address, this.tlsconfig, this.proxyaddress, basicauthentication);
    }

    public AddressConfig address() {
        return this.address;
    }

    public TlsConfig tlsconfig() {
        return this.tlsconfig;
    }

    public ProxyAddressConfig proxyaddress() {
        return this.proxyaddress;
    }

    public BasicAuthenticationConfig basicauthentication() {
        return this.basicauthentication;
    }
}

