/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.epa.ps.konnektor.config;

import de.gematik.epa.utils.StringUtils;
import java.net.URL;
import lombok.Generated;
import org.springframework.boot.context.properties.bind.DefaultValue;

public record AddressConfig(String host, Integer port, String protocol, String path) {
    private final String host;
    private final Integer port;
    private final String protocol;
    private final String path;
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_PORT = "80";

    public AddressConfig(String host, @DefaultValue(value={"80"}) Integer port, @DefaultValue(value={"http"}) String protocol, @DefaultValue(value={""}) String path) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.path = path;
    }

    public URL getUrl() {
        return new URL(this.protocol(), this.host(), this.port(), StringUtils.ensureStartsWith((String)this.path(), (String)"/"));
    }

    @Generated
    public AddressConfig withHost(String host) {
        return this.host == host ? this : new AddressConfig(host, this.port, this.protocol, this.path);
    }

    @Generated
    public AddressConfig withPort(Integer port) {
        return this.port == port ? this : new AddressConfig(this.host, port, this.protocol, this.path);
    }

    @Generated
    public AddressConfig withProtocol(String protocol) {
        return this.protocol == protocol ? this : new AddressConfig(this.host, this.port, protocol, this.path);
    }

    @Generated
    public AddressConfig withPath(String path) {
        return this.path == path ? this : new AddressConfig(this.host, this.port, this.protocol, path);
    }

    public String host() {
        return this.host;
    }

    public Integer port() {
        return this.port;
    }

    public String protocol() {
        return this.protocol;
    }

    public String path() {
        return this.path;
    }
}

