
package telematik.ws.conn.signatureservice.xsd.v7_5;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;
import telematik.ws.conn.connectorcontext.xsd.v2_0.ContextType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/ConnectorCommon/v5.0}CardHandle"/&gt;
 *         &lt;element name="Crypt" minOccurs="0"&gt;
 *           &lt;simpleType&gt;
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *               &lt;enumeration value="RSA"/&gt;
 *               &lt;enumeration value="ECC"/&gt;
 *               &lt;enumeration value="RSA_ECC"/&gt;
 *             &lt;/restriction&gt;
 *           &lt;/simpleType&gt;
 *         &lt;/element&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/ConnectorContext/v2.0}Context"/&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/SignatureService/v7.5}TvMode"/&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/SignatureService/v7.5}JobNumber" minOccurs="0"/&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/SignatureService/v7.5}SignRequest" maxOccurs="unbounded"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "cardHandle",
    "crypt",
    "context",
    "tvMode",
    "jobNumber",
    "signRequest"
})
@XmlRootElement(name = "SignDocument")
public class SignDocument {

    @XmlElement(name = "CardHandle", namespace = "http://ws.gematik.de/conn/ConnectorCommon/v5.0", required = true)
    protected String cardHandle;
    @XmlElement(name = "Crypt")
    protected String crypt;
    @XmlElement(name = "Context", namespace = "http://ws.gematik.de/conn/ConnectorContext/v2.0", required = true)
    protected ContextType context;
    @XmlElement(name = "TvMode", required = true, defaultValue = "UNCONFIRMED")
    protected String tvMode;
    @XmlElement(name = "JobNumber")
    protected String jobNumber;
    @XmlElement(name = "SignRequest", required = true)
    protected List<SignRequest> signRequest;

    /**
     * Gets the value of the cardHandle property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCardHandle() {
        return cardHandle;
    }

    /**
     * Sets the value of the cardHandle property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCardHandle(String value) {
        this.cardHandle = value;
    }

    /**
     * Gets the value of the crypt property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCrypt() {
        return crypt;
    }

    /**
     * Sets the value of the crypt property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCrypt(String value) {
        this.crypt = value;
    }

    /**
     * Gets the value of the context property.
     * 
     * @return
     *     possible object is
     *     {@link ContextType }
     *     
     */
    public ContextType getContext() {
        return context;
    }

    /**
     * Sets the value of the context property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContextType }
     *     
     */
    public void setContext(ContextType value) {
        this.context = value;
    }

    /**
     * Gets the value of the tvMode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTvMode() {
        return tvMode;
    }

    /**
     * Sets the value of the tvMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTvMode(String value) {
        this.tvMode = value;
    }

    /**
     * 
     *     						Am Konnektor verpflichtend, am Signaturproxy optional
     * 						
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobNumber() {
        return jobNumber;
    }

    /**
     * Sets the value of the jobNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJobNumber(String value) {
        this.jobNumber = value;
    }

    /**
     * Gets the value of the signRequest property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the signRequest property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSignRequest().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SignRequest }
     * 
     * 
     */
    public List<SignRequest> getSignRequest() {
        if (signRequest == null) {
            signRequest = new ArrayList<SignRequest>();
        }
        return this.signRequest;
    }

    public SignDocument withCardHandle(String value) {
        setCardHandle(value);
        return this;
    }

    public SignDocument withCrypt(String value) {
        setCrypt(value);
        return this;
    }

    public SignDocument withContext(ContextType value) {
        setContext(value);
        return this;
    }

    public SignDocument withTvMode(String value) {
        setTvMode(value);
        return this;
    }

    public SignDocument withJobNumber(String value) {
        setJobNumber(value);
        return this;
    }

    public SignDocument withSignRequest(SignRequest... values) {
        if (values!= null) {
            for (SignRequest value: values) {
                getSignRequest().add(value);
            }
        }
        return this;
    }

    public SignDocument withSignRequest(Collection<SignRequest> values) {
        if (values!= null) {
            getSignRequest().addAll(values);
        }
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final SignDocument that = ((SignDocument) object);
        {
            String leftCardHandle;
            leftCardHandle = this.getCardHandle();
            String rightCardHandle;
            rightCardHandle = that.getCardHandle();
            if (this.cardHandle!= null) {
                if (that.cardHandle!= null) {
                    if (!leftCardHandle.equals(rightCardHandle)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.cardHandle!= null) {
                    return false;
                }
            }
        }
        {
            String leftCrypt;
            leftCrypt = this.getCrypt();
            String rightCrypt;
            rightCrypt = that.getCrypt();
            if (this.crypt!= null) {
                if (that.crypt!= null) {
                    if (!leftCrypt.equals(rightCrypt)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.crypt!= null) {
                    return false;
                }
            }
        }
        {
            ContextType leftContext;
            leftContext = this.getContext();
            ContextType rightContext;
            rightContext = that.getContext();
            if (this.context!= null) {
                if (that.context!= null) {
                    if (!leftContext.equals(rightContext)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.context!= null) {
                    return false;
                }
            }
        }
        {
            String leftTvMode;
            leftTvMode = this.getTvMode();
            String rightTvMode;
            rightTvMode = that.getTvMode();
            if (this.tvMode!= null) {
                if (that.tvMode!= null) {
                    if (!leftTvMode.equals(rightTvMode)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.tvMode!= null) {
                    return false;
                }
            }
        }
        {
            String leftJobNumber;
            leftJobNumber = this.getJobNumber();
            String rightJobNumber;
            rightJobNumber = that.getJobNumber();
            if (this.jobNumber!= null) {
                if (that.jobNumber!= null) {
                    if (!leftJobNumber.equals(rightJobNumber)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.jobNumber!= null) {
                    return false;
                }
            }
        }
        {
            List<SignRequest> leftSignRequest;
            leftSignRequest = (((this.signRequest!= null)&&(!this.signRequest.isEmpty()))?this.getSignRequest():null);
            List<SignRequest> rightSignRequest;
            rightSignRequest = (((that.signRequest!= null)&&(!that.signRequest.isEmpty()))?that.getSignRequest():null);
            if ((this.signRequest!= null)&&(!this.signRequest.isEmpty())) {
                if ((that.signRequest!= null)&&(!that.signRequest.isEmpty())) {
                    if (!leftSignRequest.equals(rightSignRequest)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.signRequest!= null)&&(!that.signRequest.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theCardHandle;
            theCardHandle = this.getCardHandle();
            if (this.cardHandle!= null) {
                currentHashCode += theCardHandle.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theCrypt;
            theCrypt = this.getCrypt();
            if (this.crypt!= null) {
                currentHashCode += theCrypt.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ContextType theContext;
            theContext = this.getContext();
            if (this.context!= null) {
                currentHashCode += theContext.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theTvMode;
            theTvMode = this.getTvMode();
            if (this.tvMode!= null) {
                currentHashCode += theTvMode.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theJobNumber;
            theJobNumber = this.getJobNumber();
            if (this.jobNumber!= null) {
                currentHashCode += theJobNumber.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<SignRequest> theSignRequest;
            theSignRequest = (((this.signRequest!= null)&&(!this.signRequest.isEmpty()))?this.getSignRequest():null);
            if ((this.signRequest!= null)&&(!this.signRequest.isEmpty())) {
                currentHashCode += theSignRequest.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
