/*
 * Copyright 2023 gematik GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package telematik.ws.conn.plus;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlElementDecl;
import jakarta.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;

/**
 * ObjectFactory modelled after the ObjectFactory classes as they are generated by JAXB for classed
 * generated from XML schemas.<br>
 * See {@code package-info.java} of this package for more information
 */
@XmlRegistry
public class ObjectFactory {

  public static final QName CMS_Attribute_QNAME = QName.valueOf(CMSAttribute.CMS_ATTRIBUTE_NAME);

  public CMSAttribute createCMSAttribute() {
    return new CMSAttribute();
  }

  @XmlElementDecl(name = CMSAttribute.CMS_ATTRIBUTE_NAME)
  public JAXBElement<CMSAttribute> createCMSAttributeElement(CMSAttribute value) {
    return new JAXBElement<>(CMS_Attribute_QNAME, CMSAttribute.class, value);
  }
}
