
package telematik.ws.conn.cardservice.xsd.v8_1;

import java.math.BigInteger;
import javax.xml.datatype.XMLGregorianCalendar;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;
import telematik.ws.conn.cardservicecommon.xsd.v2_0.CardTypeType;


/**
 * <p>Java class for CardInfoType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CardInfoType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/ConnectorCommon/v5.0}CardHandle"/&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/CardServiceCommon/v2.0}CardType"/&gt;
 *         &lt;element name="CardVersion" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="COSVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType"/&gt;
 *                   &lt;element name="ObjectSystemVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType"/&gt;
 *                   &lt;element name="CardPTPersVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType" minOccurs="0"/&gt;
 *                   &lt;element name="DataStructureVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType" minOccurs="0"/&gt;
 *                   &lt;element name="LoggingVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType" minOccurs="0"/&gt;
 *                   &lt;element name="ATRVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType" minOccurs="0"/&gt;
 *                   &lt;element name="GDOVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType" minOccurs="0"/&gt;
 *                   &lt;element name="KeyInfoVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/CardServiceCommon/v2.0}Iccsn" minOccurs="0"/&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/CardServiceCommon/v2.0}CtId"/&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/CardServiceCommon/v2.0}SlotId"/&gt;
 *         &lt;element name="InsertTime" type="{http://www.w3.org/2001/XMLSchema}dateTime"/&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/CardService/v8.1}CardHolderName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/CardService/v8.1}Kvnr" minOccurs="0"/&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/CardService/v8.1}CertificateExpirationDate" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CardInfoType", propOrder = {
    "cardHandle",
    "cardType",
    "cardVersion",
    "iccsn",
    "ctId",
    "slotId",
    "insertTime",
    "cardHolderName",
    "kvnr",
    "certificateExpirationDate"
})
@XmlSeeAlso({
    CardInfoErrType.class
})
public class CardInfoType {

    @XmlElement(name = "CardHandle", namespace = "http://ws.gematik.de/conn/ConnectorCommon/v5.0", required = true)
    protected String cardHandle;
    @XmlElement(name = "CardType", namespace = "http://ws.gematik.de/conn/CardServiceCommon/v2.0", required = true)
    @XmlSchemaType(name = "string")
    protected CardTypeType cardType;
    @XmlElement(name = "CardVersion")
    protected CardInfoType.CardVersion cardVersion;
    @XmlElement(name = "Iccsn", namespace = "http://ws.gematik.de/conn/CardServiceCommon/v2.0")
    protected String iccsn;
    @XmlElement(name = "CtId", namespace = "http://ws.gematik.de/conn/CardServiceCommon/v2.0", required = true)
    protected String ctId;
    @XmlElement(name = "SlotId", namespace = "http://ws.gematik.de/conn/CardServiceCommon/v2.0", required = true)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger slotId;
    @XmlElement(name = "InsertTime", required = true)
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar insertTime;
    @XmlElement(name = "CardHolderName")
    protected String cardHolderName;
    @XmlElement(name = "Kvnr")
    protected String kvnr;
    @XmlElement(name = "CertificateExpirationDate")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar certificateExpirationDate;

    /**
     * Gets the value of the cardHandle property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCardHandle() {
        return cardHandle;
    }

    /**
     * Sets the value of the cardHandle property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCardHandle(String value) {
        this.cardHandle = value;
    }

    /**
     * Gets the value of the cardType property.
     * 
     * @return
     *     possible object is
     *     {@link CardTypeType }
     *     
     */
    public CardTypeType getCardType() {
        return cardType;
    }

    /**
     * Sets the value of the cardType property.
     * 
     * @param value
     *     allowed object is
     *     {@link CardTypeType }
     *     
     */
    public void setCardType(CardTypeType value) {
        this.cardType = value;
    }

    /**
     * Gets the value of the cardVersion property.
     * 
     * @return
     *     possible object is
     *     {@link CardInfoType.CardVersion }
     *     
     */
    public CardInfoType.CardVersion getCardVersion() {
        return cardVersion;
    }

    /**
     * Sets the value of the cardVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link CardInfoType.CardVersion }
     *     
     */
    public void setCardVersion(CardInfoType.CardVersion value) {
        this.cardVersion = value;
    }

    /**
     * Gets the value of the iccsn property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIccsn() {
        return iccsn;
    }

    /**
     * Sets the value of the iccsn property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIccsn(String value) {
        this.iccsn = value;
    }

    /**
     * Gets the value of the ctId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCtId() {
        return ctId;
    }

    /**
     * Sets the value of the ctId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCtId(String value) {
        this.ctId = value;
    }

    /**
     * Gets the value of the slotId property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getSlotId() {
        return slotId;
    }

    /**
     * Sets the value of the slotId property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setSlotId(BigInteger value) {
        this.slotId = value;
    }

    /**
     * Gets the value of the insertTime property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getInsertTime() {
        return insertTime;
    }

    /**
     * Sets the value of the insertTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setInsertTime(XMLGregorianCalendar value) {
        this.insertTime = value;
    }

    /**
     * Gets the value of the cardHolderName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCardHolderName() {
        return cardHolderName;
    }

    /**
     * Sets the value of the cardHolderName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCardHolderName(String value) {
        this.cardHolderName = value;
    }

    /**
     * Gets the value of the kvnr property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getKvnr() {
        return kvnr;
    }

    /**
     * Sets the value of the kvnr property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setKvnr(String value) {
        this.kvnr = value;
    }

    /**
     * Gets the value of the certificateExpirationDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getCertificateExpirationDate() {
        return certificateExpirationDate;
    }

    /**
     * Sets the value of the certificateExpirationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setCertificateExpirationDate(XMLGregorianCalendar value) {
        this.certificateExpirationDate = value;
    }

    public CardInfoType withCardHandle(String value) {
        setCardHandle(value);
        return this;
    }

    public CardInfoType withCardType(CardTypeType value) {
        setCardType(value);
        return this;
    }

    public CardInfoType withCardVersion(CardInfoType.CardVersion value) {
        setCardVersion(value);
        return this;
    }

    public CardInfoType withIccsn(String value) {
        setIccsn(value);
        return this;
    }

    public CardInfoType withCtId(String value) {
        setCtId(value);
        return this;
    }

    public CardInfoType withSlotId(BigInteger value) {
        setSlotId(value);
        return this;
    }

    public CardInfoType withInsertTime(XMLGregorianCalendar value) {
        setInsertTime(value);
        return this;
    }

    public CardInfoType withCardHolderName(String value) {
        setCardHolderName(value);
        return this;
    }

    public CardInfoType withKvnr(String value) {
        setKvnr(value);
        return this;
    }

    public CardInfoType withCertificateExpirationDate(XMLGregorianCalendar value) {
        setCertificateExpirationDate(value);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final CardInfoType that = ((CardInfoType) object);
        {
            String leftCardHandle;
            leftCardHandle = this.getCardHandle();
            String rightCardHandle;
            rightCardHandle = that.getCardHandle();
            if (this.cardHandle!= null) {
                if (that.cardHandle!= null) {
                    if (!leftCardHandle.equals(rightCardHandle)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.cardHandle!= null) {
                    return false;
                }
            }
        }
        {
            CardTypeType leftCardType;
            leftCardType = this.getCardType();
            CardTypeType rightCardType;
            rightCardType = that.getCardType();
            if (this.cardType!= null) {
                if (that.cardType!= null) {
                    if (!leftCardType.equals(rightCardType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.cardType!= null) {
                    return false;
                }
            }
        }
        {
            CardInfoType.CardVersion leftCardVersion;
            leftCardVersion = this.getCardVersion();
            CardInfoType.CardVersion rightCardVersion;
            rightCardVersion = that.getCardVersion();
            if (this.cardVersion!= null) {
                if (that.cardVersion!= null) {
                    if (!leftCardVersion.equals(rightCardVersion)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.cardVersion!= null) {
                    return false;
                }
            }
        }
        {
            String leftIccsn;
            leftIccsn = this.getIccsn();
            String rightIccsn;
            rightIccsn = that.getIccsn();
            if (this.iccsn!= null) {
                if (that.iccsn!= null) {
                    if (!leftIccsn.equals(rightIccsn)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.iccsn!= null) {
                    return false;
                }
            }
        }
        {
            String leftCtId;
            leftCtId = this.getCtId();
            String rightCtId;
            rightCtId = that.getCtId();
            if (this.ctId!= null) {
                if (that.ctId!= null) {
                    if (!leftCtId.equals(rightCtId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.ctId!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftSlotId;
            leftSlotId = this.getSlotId();
            BigInteger rightSlotId;
            rightSlotId = that.getSlotId();
            if (this.slotId!= null) {
                if (that.slotId!= null) {
                    if (!leftSlotId.equals(rightSlotId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.slotId!= null) {
                    return false;
                }
            }
        }
        {
            XMLGregorianCalendar leftInsertTime;
            leftInsertTime = this.getInsertTime();
            XMLGregorianCalendar rightInsertTime;
            rightInsertTime = that.getInsertTime();
            if (this.insertTime!= null) {
                if (that.insertTime!= null) {
                    if (!leftInsertTime.equals(rightInsertTime)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.insertTime!= null) {
                    return false;
                }
            }
        }
        {
            String leftCardHolderName;
            leftCardHolderName = this.getCardHolderName();
            String rightCardHolderName;
            rightCardHolderName = that.getCardHolderName();
            if (this.cardHolderName!= null) {
                if (that.cardHolderName!= null) {
                    if (!leftCardHolderName.equals(rightCardHolderName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.cardHolderName!= null) {
                    return false;
                }
            }
        }
        {
            String leftKvnr;
            leftKvnr = this.getKvnr();
            String rightKvnr;
            rightKvnr = that.getKvnr();
            if (this.kvnr!= null) {
                if (that.kvnr!= null) {
                    if (!leftKvnr.equals(rightKvnr)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.kvnr!= null) {
                    return false;
                }
            }
        }
        {
            XMLGregorianCalendar leftCertificateExpirationDate;
            leftCertificateExpirationDate = this.getCertificateExpirationDate();
            XMLGregorianCalendar rightCertificateExpirationDate;
            rightCertificateExpirationDate = that.getCertificateExpirationDate();
            if (this.certificateExpirationDate!= null) {
                if (that.certificateExpirationDate!= null) {
                    if (!leftCertificateExpirationDate.equals(rightCertificateExpirationDate)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.certificateExpirationDate!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theCardHandle;
            theCardHandle = this.getCardHandle();
            if (this.cardHandle!= null) {
                currentHashCode += theCardHandle.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            CardTypeType theCardType;
            theCardType = this.getCardType();
            if (this.cardType!= null) {
                currentHashCode += theCardType.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            CardInfoType.CardVersion theCardVersion;
            theCardVersion = this.getCardVersion();
            if (this.cardVersion!= null) {
                currentHashCode += theCardVersion.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theIccsn;
            theIccsn = this.getIccsn();
            if (this.iccsn!= null) {
                currentHashCode += theIccsn.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theCtId;
            theCtId = this.getCtId();
            if (this.ctId!= null) {
                currentHashCode += theCtId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theSlotId;
            theSlotId = this.getSlotId();
            if (this.slotId!= null) {
                currentHashCode += theSlotId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            XMLGregorianCalendar theInsertTime;
            theInsertTime = this.getInsertTime();
            if (this.insertTime!= null) {
                currentHashCode += theInsertTime.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theCardHolderName;
            theCardHolderName = this.getCardHolderName();
            if (this.cardHolderName!= null) {
                currentHashCode += theCardHolderName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theKvnr;
            theKvnr = this.getKvnr();
            if (this.kvnr!= null) {
                currentHashCode += theKvnr.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            XMLGregorianCalendar theCertificateExpirationDate;
            theCertificateExpirationDate = this.getCertificateExpirationDate();
            if (this.certificateExpirationDate!= null) {
                currentHashCode += theCertificateExpirationDate.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element name="COSVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType"/&gt;
     *         &lt;element name="ObjectSystemVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType"/&gt;
     *         &lt;element name="CardPTPersVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType" minOccurs="0"/&gt;
     *         &lt;element name="DataStructureVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType" minOccurs="0"/&gt;
     *         &lt;element name="LoggingVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType" minOccurs="0"/&gt;
     *         &lt;element name="ATRVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType" minOccurs="0"/&gt;
     *         &lt;element name="GDOVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType" minOccurs="0"/&gt;
     *         &lt;element name="KeyInfoVersion" type="{http://ws.gematik.de/conn/CardService/v8.1}VersionInfoType" minOccurs="0"/&gt;
     *       &lt;/sequence&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "cosVersion",
        "objectSystemVersion",
        "cardPTPersVersion",
        "dataStructureVersion",
        "loggingVersion",
        "atrVersion",
        "gdoVersion",
        "keyInfoVersion"
    })
    public static class CardVersion {

        @XmlElement(name = "COSVersion", required = true)
        protected VersionInfoType cosVersion;
        @XmlElement(name = "ObjectSystemVersion", required = true)
        protected VersionInfoType objectSystemVersion;
        @XmlElement(name = "CardPTPersVersion")
        protected VersionInfoType cardPTPersVersion;
        @XmlElement(name = "DataStructureVersion")
        protected VersionInfoType dataStructureVersion;
        @XmlElement(name = "LoggingVersion")
        protected VersionInfoType loggingVersion;
        @XmlElement(name = "ATRVersion")
        protected VersionInfoType atrVersion;
        @XmlElement(name = "GDOVersion")
        protected VersionInfoType gdoVersion;
        @XmlElement(name = "KeyInfoVersion")
        protected VersionInfoType keyInfoVersion;

        /**
         * Gets the value of the cosVersion property.
         * 
         * @return
         *     possible object is
         *     {@link VersionInfoType }
         *     
         */
        public VersionInfoType getCOSVersion() {
            return cosVersion;
        }

        /**
         * Sets the value of the cosVersion property.
         * 
         * @param value
         *     allowed object is
         *     {@link VersionInfoType }
         *     
         */
        public void setCOSVersion(VersionInfoType value) {
            this.cosVersion = value;
        }

        /**
         * Gets the value of the objectSystemVersion property.
         * 
         * @return
         *     possible object is
         *     {@link VersionInfoType }
         *     
         */
        public VersionInfoType getObjectSystemVersion() {
            return objectSystemVersion;
        }

        /**
         * Sets the value of the objectSystemVersion property.
         * 
         * @param value
         *     allowed object is
         *     {@link VersionInfoType }
         *     
         */
        public void setObjectSystemVersion(VersionInfoType value) {
            this.objectSystemVersion = value;
        }

        /**
         * Gets the value of the cardPTPersVersion property.
         * 
         * @return
         *     possible object is
         *     {@link VersionInfoType }
         *     
         */
        public VersionInfoType getCardPTPersVersion() {
            return cardPTPersVersion;
        }

        /**
         * Sets the value of the cardPTPersVersion property.
         * 
         * @param value
         *     allowed object is
         *     {@link VersionInfoType }
         *     
         */
        public void setCardPTPersVersion(VersionInfoType value) {
            this.cardPTPersVersion = value;
        }

        /**
         * Gets the value of the dataStructureVersion property.
         * 
         * @return
         *     possible object is
         *     {@link VersionInfoType }
         *     
         */
        public VersionInfoType getDataStructureVersion() {
            return dataStructureVersion;
        }

        /**
         * Sets the value of the dataStructureVersion property.
         * 
         * @param value
         *     allowed object is
         *     {@link VersionInfoType }
         *     
         */
        public void setDataStructureVersion(VersionInfoType value) {
            this.dataStructureVersion = value;
        }

        /**
         * Gets the value of the loggingVersion property.
         * 
         * @return
         *     possible object is
         *     {@link VersionInfoType }
         *     
         */
        public VersionInfoType getLoggingVersion() {
            return loggingVersion;
        }

        /**
         * Sets the value of the loggingVersion property.
         * 
         * @param value
         *     allowed object is
         *     {@link VersionInfoType }
         *     
         */
        public void setLoggingVersion(VersionInfoType value) {
            this.loggingVersion = value;
        }

        /**
         * Gets the value of the atrVersion property.
         * 
         * @return
         *     possible object is
         *     {@link VersionInfoType }
         *     
         */
        public VersionInfoType getATRVersion() {
            return atrVersion;
        }

        /**
         * Sets the value of the atrVersion property.
         * 
         * @param value
         *     allowed object is
         *     {@link VersionInfoType }
         *     
         */
        public void setATRVersion(VersionInfoType value) {
            this.atrVersion = value;
        }

        /**
         * Gets the value of the gdoVersion property.
         * 
         * @return
         *     possible object is
         *     {@link VersionInfoType }
         *     
         */
        public VersionInfoType getGDOVersion() {
            return gdoVersion;
        }

        /**
         * Sets the value of the gdoVersion property.
         * 
         * @param value
         *     allowed object is
         *     {@link VersionInfoType }
         *     
         */
        public void setGDOVersion(VersionInfoType value) {
            this.gdoVersion = value;
        }

        /**
         * Gets the value of the keyInfoVersion property.
         * 
         * @return
         *     possible object is
         *     {@link VersionInfoType }
         *     
         */
        public VersionInfoType getKeyInfoVersion() {
            return keyInfoVersion;
        }

        /**
         * Sets the value of the keyInfoVersion property.
         * 
         * @param value
         *     allowed object is
         *     {@link VersionInfoType }
         *     
         */
        public void setKeyInfoVersion(VersionInfoType value) {
            this.keyInfoVersion = value;
        }

        public CardInfoType.CardVersion withCOSVersion(VersionInfoType value) {
            setCOSVersion(value);
            return this;
        }

        public CardInfoType.CardVersion withObjectSystemVersion(VersionInfoType value) {
            setObjectSystemVersion(value);
            return this;
        }

        public CardInfoType.CardVersion withCardPTPersVersion(VersionInfoType value) {
            setCardPTPersVersion(value);
            return this;
        }

        public CardInfoType.CardVersion withDataStructureVersion(VersionInfoType value) {
            setDataStructureVersion(value);
            return this;
        }

        public CardInfoType.CardVersion withLoggingVersion(VersionInfoType value) {
            setLoggingVersion(value);
            return this;
        }

        public CardInfoType.CardVersion withATRVersion(VersionInfoType value) {
            setATRVersion(value);
            return this;
        }

        public CardInfoType.CardVersion withGDOVersion(VersionInfoType value) {
            setGDOVersion(value);
            return this;
        }

        public CardInfoType.CardVersion withKeyInfoVersion(VersionInfoType value) {
            setKeyInfoVersion(value);
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if ((object == null)||(this.getClass()!= object.getClass())) {
                return false;
            }
            if (this == object) {
                return true;
            }
            final CardInfoType.CardVersion that = ((CardInfoType.CardVersion) object);
            {
                VersionInfoType leftCOSVersion;
                leftCOSVersion = this.getCOSVersion();
                VersionInfoType rightCOSVersion;
                rightCOSVersion = that.getCOSVersion();
                if (this.cosVersion!= null) {
                    if (that.cosVersion!= null) {
                        if (!leftCOSVersion.equals(rightCOSVersion)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                } else {
                    if (that.cosVersion!= null) {
                        return false;
                    }
                }
            }
            {
                VersionInfoType leftObjectSystemVersion;
                leftObjectSystemVersion = this.getObjectSystemVersion();
                VersionInfoType rightObjectSystemVersion;
                rightObjectSystemVersion = that.getObjectSystemVersion();
                if (this.objectSystemVersion!= null) {
                    if (that.objectSystemVersion!= null) {
                        if (!leftObjectSystemVersion.equals(rightObjectSystemVersion)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                } else {
                    if (that.objectSystemVersion!= null) {
                        return false;
                    }
                }
            }
            {
                VersionInfoType leftCardPTPersVersion;
                leftCardPTPersVersion = this.getCardPTPersVersion();
                VersionInfoType rightCardPTPersVersion;
                rightCardPTPersVersion = that.getCardPTPersVersion();
                if (this.cardPTPersVersion!= null) {
                    if (that.cardPTPersVersion!= null) {
                        if (!leftCardPTPersVersion.equals(rightCardPTPersVersion)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                } else {
                    if (that.cardPTPersVersion!= null) {
                        return false;
                    }
                }
            }
            {
                VersionInfoType leftDataStructureVersion;
                leftDataStructureVersion = this.getDataStructureVersion();
                VersionInfoType rightDataStructureVersion;
                rightDataStructureVersion = that.getDataStructureVersion();
                if (this.dataStructureVersion!= null) {
                    if (that.dataStructureVersion!= null) {
                        if (!leftDataStructureVersion.equals(rightDataStructureVersion)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                } else {
                    if (that.dataStructureVersion!= null) {
                        return false;
                    }
                }
            }
            {
                VersionInfoType leftLoggingVersion;
                leftLoggingVersion = this.getLoggingVersion();
                VersionInfoType rightLoggingVersion;
                rightLoggingVersion = that.getLoggingVersion();
                if (this.loggingVersion!= null) {
                    if (that.loggingVersion!= null) {
                        if (!leftLoggingVersion.equals(rightLoggingVersion)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                } else {
                    if (that.loggingVersion!= null) {
                        return false;
                    }
                }
            }
            {
                VersionInfoType leftATRVersion;
                leftATRVersion = this.getATRVersion();
                VersionInfoType rightATRVersion;
                rightATRVersion = that.getATRVersion();
                if (this.atrVersion!= null) {
                    if (that.atrVersion!= null) {
                        if (!leftATRVersion.equals(rightATRVersion)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                } else {
                    if (that.atrVersion!= null) {
                        return false;
                    }
                }
            }
            {
                VersionInfoType leftGDOVersion;
                leftGDOVersion = this.getGDOVersion();
                VersionInfoType rightGDOVersion;
                rightGDOVersion = that.getGDOVersion();
                if (this.gdoVersion!= null) {
                    if (that.gdoVersion!= null) {
                        if (!leftGDOVersion.equals(rightGDOVersion)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                } else {
                    if (that.gdoVersion!= null) {
                        return false;
                    }
                }
            }
            {
                VersionInfoType leftKeyInfoVersion;
                leftKeyInfoVersion = this.getKeyInfoVersion();
                VersionInfoType rightKeyInfoVersion;
                rightKeyInfoVersion = that.getKeyInfoVersion();
                if (this.keyInfoVersion!= null) {
                    if (that.keyInfoVersion!= null) {
                        if (!leftKeyInfoVersion.equals(rightKeyInfoVersion)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                } else {
                    if (that.keyInfoVersion!= null) {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public int hashCode() {
            int currentHashCode = 1;
            {
                currentHashCode = (currentHashCode* 31);
                VersionInfoType theCOSVersion;
                theCOSVersion = this.getCOSVersion();
                if (this.cosVersion!= null) {
                    currentHashCode += theCOSVersion.hashCode();
                }
            }
            {
                currentHashCode = (currentHashCode* 31);
                VersionInfoType theObjectSystemVersion;
                theObjectSystemVersion = this.getObjectSystemVersion();
                if (this.objectSystemVersion!= null) {
                    currentHashCode += theObjectSystemVersion.hashCode();
                }
            }
            {
                currentHashCode = (currentHashCode* 31);
                VersionInfoType theCardPTPersVersion;
                theCardPTPersVersion = this.getCardPTPersVersion();
                if (this.cardPTPersVersion!= null) {
                    currentHashCode += theCardPTPersVersion.hashCode();
                }
            }
            {
                currentHashCode = (currentHashCode* 31);
                VersionInfoType theDataStructureVersion;
                theDataStructureVersion = this.getDataStructureVersion();
                if (this.dataStructureVersion!= null) {
                    currentHashCode += theDataStructureVersion.hashCode();
                }
            }
            {
                currentHashCode = (currentHashCode* 31);
                VersionInfoType theLoggingVersion;
                theLoggingVersion = this.getLoggingVersion();
                if (this.loggingVersion!= null) {
                    currentHashCode += theLoggingVersion.hashCode();
                }
            }
            {
                currentHashCode = (currentHashCode* 31);
                VersionInfoType theATRVersion;
                theATRVersion = this.getATRVersion();
                if (this.atrVersion!= null) {
                    currentHashCode += theATRVersion.hashCode();
                }
            }
            {
                currentHashCode = (currentHashCode* 31);
                VersionInfoType theGDOVersion;
                theGDOVersion = this.getGDOVersion();
                if (this.gdoVersion!= null) {
                    currentHashCode += theGDOVersion.hashCode();
                }
            }
            {
                currentHashCode = (currentHashCode* 31);
                VersionInfoType theKeyInfoVersion;
                theKeyInfoVersion = this.getKeyInfoVersion();
                if (this.keyInfoVersion!= null) {
                    currentHashCode += theKeyInfoVersion.hashCode();
                }
            }
            return currentHashCode;
        }

        /**
         * Generates a String representation of the contents of this type.
         * This is an extension method, produced by the 'ts' xjc plugin
         * 
         */
        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
        }

    }

}
