
package org.hl7.v3;

import java.math.BigInteger;
import java.util.Collection;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;


/**
 * <p>Java class for IVXB_INT complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="IVXB_INT"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:hl7-org:v3}INT"&gt;
 *       &lt;attribute name="inclusive" type="{urn:hl7-org:v3}bl" default="true" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "IVXB_INT")
public class IVXBINT
    extends INT
{

    @XmlAttribute(name = "inclusive")
    protected Boolean inclusive;

    /**
     * Gets the value of the inclusive property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isInclusive() {
        if (inclusive == null) {
            return true;
        } else {
            return inclusive;
        }
    }

    /**
     * Sets the value of the inclusive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInclusive(Boolean value) {
        this.inclusive = value;
    }

    public IVXBINT withInclusive(Boolean value) {
        setInclusive(value);
        return this;
    }

    @Override
    public IVXBINT withValue(BigInteger value) {
        setValue(value);
        return this;
    }

    @Override
    public IVXBINT withNullFlavor(String... values) {
        if (values!= null) {
            for (String value: values) {
                getNullFlavor().add(value);
            }
        }
        return this;
    }

    @Override
    public IVXBINT withNullFlavor(Collection<String> values) {
        if (values!= null) {
            getNullFlavor().addAll(values);
        }
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final IVXBINT that = ((IVXBINT) object);
        {
            boolean leftInclusive;
            leftInclusive = ((this.inclusive!= null)?this.isInclusive():true);
            boolean rightInclusive;
            rightInclusive = ((that.inclusive!= null)?that.isInclusive():true);
            if (this.inclusive!= null) {
                if (that.inclusive!= null) {
                    if (leftInclusive!= rightInclusive) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.inclusive!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            boolean theInclusive;
            theInclusive = ((this.inclusive!= null)?this.isInclusive():true);
            if (this.inclusive!= null) {
                currentHashCode += (theInclusive? 1231 : 1237);
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
