
package org.hl7.v3;

import java.util.Collection;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;


/**
 * 
 *             An identifier that uniquely identifies a thing or object.
 *             Examples are object identifier for HL7 RIM objects,
 *             medical record number, order id, service catalog item id,
 *             Vehicle Identification Number (VIN), etc. Instance
 *             identifiers are defined based on ISO object identifiers.
 *          
 * 
 * <p>Java class for II complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="II"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:hl7-org:v3}ANY"&gt;
 *       &lt;attribute name="root" type="{urn:hl7-org:v3}uid" /&gt;
 *       &lt;attribute name="extension" type="{urn:hl7-org:v3}st" /&gt;
 *       &lt;attribute name="assigningAuthorityName" type="{urn:hl7-org:v3}st" /&gt;
 *       &lt;attribute name="displayable" type="{urn:hl7-org:v3}bl" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "II")
public class II
    extends ANY
{

    @XmlAttribute(name = "root")
    protected String root;
    @XmlAttribute(name = "extension")
    protected String extension;
    @XmlAttribute(name = "assigningAuthorityName")
    protected String assigningAuthorityName;
    @XmlAttribute(name = "displayable")
    protected Boolean displayable;

    /**
     * Gets the value of the root property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRoot() {
        return root;
    }

    /**
     * Sets the value of the root property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRoot(String value) {
        this.root = value;
    }

    /**
     * Gets the value of the extension property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getExtension() {
        return extension;
    }

    /**
     * Sets the value of the extension property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setExtension(String value) {
        this.extension = value;
    }

    /**
     * Gets the value of the assigningAuthorityName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAssigningAuthorityName() {
        return assigningAuthorityName;
    }

    /**
     * Sets the value of the assigningAuthorityName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAssigningAuthorityName(String value) {
        this.assigningAuthorityName = value;
    }

    /**
     * Gets the value of the displayable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isDisplayable() {
        return displayable;
    }

    /**
     * Sets the value of the displayable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDisplayable(Boolean value) {
        this.displayable = value;
    }

    public II withRoot(String value) {
        setRoot(value);
        return this;
    }

    public II withExtension(String value) {
        setExtension(value);
        return this;
    }

    public II withAssigningAuthorityName(String value) {
        setAssigningAuthorityName(value);
        return this;
    }

    public II withDisplayable(Boolean value) {
        setDisplayable(value);
        return this;
    }

    @Override
    public II withNullFlavor(String... values) {
        if (values!= null) {
            for (String value: values) {
                getNullFlavor().add(value);
            }
        }
        return this;
    }

    @Override
    public II withNullFlavor(Collection<String> values) {
        if (values!= null) {
            getNullFlavor().addAll(values);
        }
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final II that = ((II) object);
        {
            String leftRoot;
            leftRoot = this.getRoot();
            String rightRoot;
            rightRoot = that.getRoot();
            if (this.root!= null) {
                if (that.root!= null) {
                    if (!leftRoot.equals(rightRoot)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.root!= null) {
                    return false;
                }
            }
        }
        {
            String leftExtension;
            leftExtension = this.getExtension();
            String rightExtension;
            rightExtension = that.getExtension();
            if (this.extension!= null) {
                if (that.extension!= null) {
                    if (!leftExtension.equals(rightExtension)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.extension!= null) {
                    return false;
                }
            }
        }
        {
            String leftAssigningAuthorityName;
            leftAssigningAuthorityName = this.getAssigningAuthorityName();
            String rightAssigningAuthorityName;
            rightAssigningAuthorityName = that.getAssigningAuthorityName();
            if (this.assigningAuthorityName!= null) {
                if (that.assigningAuthorityName!= null) {
                    if (!leftAssigningAuthorityName.equals(rightAssigningAuthorityName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.assigningAuthorityName!= null) {
                    return false;
                }
            }
        }
        {
            Boolean leftDisplayable;
            leftDisplayable = this.isDisplayable();
            Boolean rightDisplayable;
            rightDisplayable = that.isDisplayable();
            if (this.displayable!= null) {
                if (that.displayable!= null) {
                    if (!leftDisplayable.equals(rightDisplayable)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.displayable!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            String theRoot;
            theRoot = this.getRoot();
            if (this.root!= null) {
                currentHashCode += theRoot.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theExtension;
            theExtension = this.getExtension();
            if (this.extension!= null) {
                currentHashCode += theExtension.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theAssigningAuthorityName;
            theAssigningAuthorityName = this.getAssigningAuthorityName();
            if (this.assigningAuthorityName!= null) {
                currentHashCode += theAssigningAuthorityName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Boolean theDisplayable;
            theDisplayable = this.isDisplayable();
            if (this.displayable!= null) {
                currentHashCode += theDisplayable.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
