
package org.hl7.v3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;


/**
 * 
 *             Defines the basic properties of every data value. This
 *             is an abstract type, meaning that no value can be just
 *             a data value without belonging to any concrete type.
 *             Every concrete type is a specialization of this
 *             general abstract DataValue type.
 *          
 * 
 * <p>Java class for ANY complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ANY"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;attribute name="nullFlavor" type="{urn:hl7-org:v3}NullFlavor" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ANY")
@XmlSeeAlso({
    BL.class,
    ANYNonNull.class,
    CR.class,
    II.class,
    URL.class,
    BIN.class,
    CD.class,
    SLISTPQ.class,
    SLISTTS.class,
    GLISTTS.class,
    GLISTPQ.class,
    QTY.class
})
public abstract class ANY {

    @XmlAttribute(name = "nullFlavor")
    protected List<String> nullFlavor;

    /**
     * Gets the value of the nullFlavor property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the nullFlavor property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNullFlavor().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    public List<String> getNullFlavor() {
        if (nullFlavor == null) {
            nullFlavor = new ArrayList<String>();
        }
        return this.nullFlavor;
    }

    public ANY withNullFlavor(String... values) {
        if (values!= null) {
            for (String value: values) {
                getNullFlavor().add(value);
            }
        }
        return this;
    }

    public ANY withNullFlavor(Collection<String> values) {
        if (values!= null) {
            getNullFlavor().addAll(values);
        }
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final ANY that = ((ANY) object);
        {
            List<String> leftNullFlavor;
            leftNullFlavor = (((this.nullFlavor!= null)&&(!this.nullFlavor.isEmpty()))?this.getNullFlavor():null);
            List<String> rightNullFlavor;
            rightNullFlavor = (((that.nullFlavor!= null)&&(!that.nullFlavor.isEmpty()))?that.getNullFlavor():null);
            if ((this.nullFlavor!= null)&&(!this.nullFlavor.isEmpty())) {
                if ((that.nullFlavor!= null)&&(!that.nullFlavor.isEmpty())) {
                    if (!leftNullFlavor.equals(rightNullFlavor)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.nullFlavor!= null)&&(!that.nullFlavor.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theNullFlavor;
            theNullFlavor = (((this.nullFlavor!= null)&&(!this.nullFlavor.isEmpty()))?this.getNullFlavor():null);
            if ((this.nullFlavor!= null)&&(!this.nullFlavor.isEmpty())) {
                currentHashCode += theNullFlavor.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
