
package oasis.names.tc.saml._2_0.assertion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;


/**
 * <p>Java class for AuthzDecisionStatementType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="AuthzDecisionStatementType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:oasis:names:tc:SAML:2.0:assertion}StatementAbstractType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{urn:oasis:names:tc:SAML:2.0:assertion}Action" maxOccurs="unbounded"/&gt;
 *         &lt;element ref="{urn:oasis:names:tc:SAML:2.0:assertion}Evidence" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="Resource" use="required" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&gt;
 *       &lt;attribute name="Decision" use="required" type="{urn:oasis:names:tc:SAML:2.0:assertion}DecisionType" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AuthzDecisionStatementType", propOrder = {
    "action",
    "evidence"
})
public class AuthzDecisionStatementType
    extends StatementAbstractType
{

    @XmlElement(name = "Action", required = true)
    protected List<ActionType> action;
    @XmlElement(name = "Evidence")
    protected EvidenceType evidence;
    @XmlAttribute(name = "Resource", required = true)
    @XmlSchemaType(name = "anyURI")
    protected String resource;
    @XmlAttribute(name = "Decision", required = true)
    protected DecisionType decision;

    /**
     * Gets the value of the action property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the action property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAction().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ActionType }
     * 
     * 
     */
    public List<ActionType> getAction() {
        if (action == null) {
            action = new ArrayList<ActionType>();
        }
        return this.action;
    }

    /**
     * Gets the value of the evidence property.
     * 
     * @return
     *     possible object is
     *     {@link EvidenceType }
     *     
     */
    public EvidenceType getEvidence() {
        return evidence;
    }

    /**
     * Sets the value of the evidence property.
     * 
     * @param value
     *     allowed object is
     *     {@link EvidenceType }
     *     
     */
    public void setEvidence(EvidenceType value) {
        this.evidence = value;
    }

    /**
     * Gets the value of the resource property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getResource() {
        return resource;
    }

    /**
     * Sets the value of the resource property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setResource(String value) {
        this.resource = value;
    }

    /**
     * Gets the value of the decision property.
     * 
     * @return
     *     possible object is
     *     {@link DecisionType }
     *     
     */
    public DecisionType getDecision() {
        return decision;
    }

    /**
     * Sets the value of the decision property.
     * 
     * @param value
     *     allowed object is
     *     {@link DecisionType }
     *     
     */
    public void setDecision(DecisionType value) {
        this.decision = value;
    }

    public AuthzDecisionStatementType withAction(ActionType... values) {
        if (values!= null) {
            for (ActionType value: values) {
                getAction().add(value);
            }
        }
        return this;
    }

    public AuthzDecisionStatementType withAction(Collection<ActionType> values) {
        if (values!= null) {
            getAction().addAll(values);
        }
        return this;
    }

    public AuthzDecisionStatementType withEvidence(EvidenceType value) {
        setEvidence(value);
        return this;
    }

    public AuthzDecisionStatementType withResource(String value) {
        setResource(value);
        return this;
    }

    public AuthzDecisionStatementType withDecision(DecisionType value) {
        setDecision(value);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final AuthzDecisionStatementType that = ((AuthzDecisionStatementType) object);
        {
            List<ActionType> leftAction;
            leftAction = (((this.action!= null)&&(!this.action.isEmpty()))?this.getAction():null);
            List<ActionType> rightAction;
            rightAction = (((that.action!= null)&&(!that.action.isEmpty()))?that.getAction():null);
            if ((this.action!= null)&&(!this.action.isEmpty())) {
                if ((that.action!= null)&&(!that.action.isEmpty())) {
                    if (!leftAction.equals(rightAction)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.action!= null)&&(!that.action.isEmpty())) {
                    return false;
                }
            }
        }
        {
            EvidenceType leftEvidence;
            leftEvidence = this.getEvidence();
            EvidenceType rightEvidence;
            rightEvidence = that.getEvidence();
            if (this.evidence!= null) {
                if (that.evidence!= null) {
                    if (!leftEvidence.equals(rightEvidence)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.evidence!= null) {
                    return false;
                }
            }
        }
        {
            String leftResource;
            leftResource = this.getResource();
            String rightResource;
            rightResource = that.getResource();
            if (this.resource!= null) {
                if (that.resource!= null) {
                    if (!leftResource.equals(rightResource)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.resource!= null) {
                    return false;
                }
            }
        }
        {
            DecisionType leftDecision;
            leftDecision = this.getDecision();
            DecisionType rightDecision;
            rightDecision = that.getDecision();
            if (this.decision!= null) {
                if (that.decision!= null) {
                    if (!leftDecision.equals(rightDecision)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.decision!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<ActionType> theAction;
            theAction = (((this.action!= null)&&(!this.action.isEmpty()))?this.getAction():null);
            if ((this.action!= null)&&(!this.action.isEmpty())) {
                currentHashCode += theAction.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            EvidenceType theEvidence;
            theEvidence = this.getEvidence();
            if (this.evidence!= null) {
                currentHashCode += theEvidence.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theResource;
            theResource = this.getResource();
            if (this.resource!= null) {
                currentHashCode += theResource.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            DecisionType theDecision;
            theDecision = this.getDecision();
            if (this.decision!= null) {
                currentHashCode += theDecision.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
