
package oasis.names.tc.saml._2_0.assertion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;
import org.w3._2000._09.xmldsig_.SignatureType;


/**
 * <p>Java class for AssertionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="AssertionType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{urn:oasis:names:tc:SAML:2.0:assertion}Issuer"/&gt;
 *         &lt;element ref="{http://www.w3.org/2000/09/xmldsig#}Signature" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:tc:SAML:2.0:assertion}Subject" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:tc:SAML:2.0:assertion}Conditions" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:tc:SAML:2.0:assertion}Advice" minOccurs="0"/&gt;
 *         &lt;choice maxOccurs="unbounded" minOccurs="0"&gt;
 *           &lt;element ref="{urn:oasis:names:tc:SAML:2.0:assertion}Statement"/&gt;
 *           &lt;element ref="{urn:oasis:names:tc:SAML:2.0:assertion}AuthnStatement"/&gt;
 *           &lt;element ref="{urn:oasis:names:tc:SAML:2.0:assertion}AuthzDecisionStatement"/&gt;
 *           &lt;element ref="{urn:oasis:names:tc:SAML:2.0:assertion}AttributeStatement"/&gt;
 *         &lt;/choice&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="Version" use="required" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="ID" use="required" type="{http://www.w3.org/2001/XMLSchema}ID" /&gt;
 *       &lt;attribute name="IssueInstant" use="required" type="{http://www.w3.org/2001/XMLSchema}dateTime" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AssertionType", propOrder = {
    "issuer",
    "signature",
    "subject",
    "conditions",
    "advice",
    "statementOrAuthnStatementOrAuthzDecisionStatement"
})
public class AssertionType {

    @XmlElement(name = "Issuer", required = true)
    protected NameIDType issuer;
    @XmlElement(name = "Signature", namespace = "http://www.w3.org/2000/09/xmldsig#")
    protected SignatureType signature;
    @XmlElement(name = "Subject")
    protected SubjectType subject;
    @XmlElement(name = "Conditions")
    protected ConditionsType conditions;
    @XmlElement(name = "Advice")
    protected AdviceType advice;
    @XmlElements({
        @XmlElement(name = "Statement"),
        @XmlElement(name = "AuthnStatement", type = AuthnStatementType.class),
        @XmlElement(name = "AuthzDecisionStatement", type = AuthzDecisionStatementType.class),
        @XmlElement(name = "AttributeStatement", type = AttributeStatementType.class)
    })
    protected List<StatementAbstractType> statementOrAuthnStatementOrAuthzDecisionStatement;
    @XmlAttribute(name = "Version", required = true)
    protected String version;
    @XmlAttribute(name = "ID", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    protected String id;
    @XmlAttribute(name = "IssueInstant", required = true)
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar issueInstant;

    /**
     * Gets the value of the issuer property.
     * 
     * @return
     *     possible object is
     *     {@link NameIDType }
     *     
     */
    public NameIDType getIssuer() {
        return issuer;
    }

    /**
     * Sets the value of the issuer property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameIDType }
     *     
     */
    public void setIssuer(NameIDType value) {
        this.issuer = value;
    }

    /**
     * Gets the value of the signature property.
     * 
     * @return
     *     possible object is
     *     {@link SignatureType }
     *     
     */
    public SignatureType getSignature() {
        return signature;
    }

    /**
     * Sets the value of the signature property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureType }
     *     
     */
    public void setSignature(SignatureType value) {
        this.signature = value;
    }

    /**
     * Gets the value of the subject property.
     * 
     * @return
     *     possible object is
     *     {@link SubjectType }
     *     
     */
    public SubjectType getSubject() {
        return subject;
    }

    /**
     * Sets the value of the subject property.
     * 
     * @param value
     *     allowed object is
     *     {@link SubjectType }
     *     
     */
    public void setSubject(SubjectType value) {
        this.subject = value;
    }

    /**
     * Gets the value of the conditions property.
     * 
     * @return
     *     possible object is
     *     {@link ConditionsType }
     *     
     */
    public ConditionsType getConditions() {
        return conditions;
    }

    /**
     * Sets the value of the conditions property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConditionsType }
     *     
     */
    public void setConditions(ConditionsType value) {
        this.conditions = value;
    }

    /**
     * Gets the value of the advice property.
     * 
     * @return
     *     possible object is
     *     {@link AdviceType }
     *     
     */
    public AdviceType getAdvice() {
        return advice;
    }

    /**
     * Sets the value of the advice property.
     * 
     * @param value
     *     allowed object is
     *     {@link AdviceType }
     *     
     */
    public void setAdvice(AdviceType value) {
        this.advice = value;
    }

    /**
     * Gets the value of the statementOrAuthnStatementOrAuthzDecisionStatement property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the statementOrAuthnStatementOrAuthzDecisionStatement property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getStatementOrAuthnStatementOrAuthzDecisionStatement().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AttributeStatementType }
     * {@link AuthnStatementType }
     * {@link AuthzDecisionStatementType }
     * {@link StatementAbstractType }
     * 
     * 
     */
    public List<StatementAbstractType> getStatementOrAuthnStatementOrAuthzDecisionStatement() {
        if (statementOrAuthnStatementOrAuthzDecisionStatement == null) {
            statementOrAuthnStatementOrAuthzDecisionStatement = new ArrayList<StatementAbstractType>();
        }
        return this.statementOrAuthnStatementOrAuthzDecisionStatement;
    }

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersion(String value) {
        this.version = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setID(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the issueInstant property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getIssueInstant() {
        return issueInstant;
    }

    /**
     * Sets the value of the issueInstant property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setIssueInstant(XMLGregorianCalendar value) {
        this.issueInstant = value;
    }

    public AssertionType withIssuer(NameIDType value) {
        setIssuer(value);
        return this;
    }

    public AssertionType withSignature(SignatureType value) {
        setSignature(value);
        return this;
    }

    public AssertionType withSubject(SubjectType value) {
        setSubject(value);
        return this;
    }

    public AssertionType withConditions(ConditionsType value) {
        setConditions(value);
        return this;
    }

    public AssertionType withAdvice(AdviceType value) {
        setAdvice(value);
        return this;
    }

    public AssertionType withStatementOrAuthnStatementOrAuthzDecisionStatement(StatementAbstractType... values) {
        if (values!= null) {
            for (StatementAbstractType value: values) {
                getStatementOrAuthnStatementOrAuthzDecisionStatement().add(value);
            }
        }
        return this;
    }

    public AssertionType withStatementOrAuthnStatementOrAuthzDecisionStatement(Collection<StatementAbstractType> values) {
        if (values!= null) {
            getStatementOrAuthnStatementOrAuthzDecisionStatement().addAll(values);
        }
        return this;
    }

    public AssertionType withVersion(String value) {
        setVersion(value);
        return this;
    }

    public AssertionType withID(String value) {
        setID(value);
        return this;
    }

    public AssertionType withIssueInstant(XMLGregorianCalendar value) {
        setIssueInstant(value);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final AssertionType that = ((AssertionType) object);
        {
            NameIDType leftIssuer;
            leftIssuer = this.getIssuer();
            NameIDType rightIssuer;
            rightIssuer = that.getIssuer();
            if (this.issuer!= null) {
                if (that.issuer!= null) {
                    if (!leftIssuer.equals(rightIssuer)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.issuer!= null) {
                    return false;
                }
            }
        }
        {
            SignatureType leftSignature;
            leftSignature = this.getSignature();
            SignatureType rightSignature;
            rightSignature = that.getSignature();
            if (this.signature!= null) {
                if (that.signature!= null) {
                    if (!leftSignature.equals(rightSignature)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.signature!= null) {
                    return false;
                }
            }
        }
        {
            SubjectType leftSubject;
            leftSubject = this.getSubject();
            SubjectType rightSubject;
            rightSubject = that.getSubject();
            if (this.subject!= null) {
                if (that.subject!= null) {
                    if (!leftSubject.equals(rightSubject)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.subject!= null) {
                    return false;
                }
            }
        }
        {
            ConditionsType leftConditions;
            leftConditions = this.getConditions();
            ConditionsType rightConditions;
            rightConditions = that.getConditions();
            if (this.conditions!= null) {
                if (that.conditions!= null) {
                    if (!leftConditions.equals(rightConditions)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.conditions!= null) {
                    return false;
                }
            }
        }
        {
            AdviceType leftAdvice;
            leftAdvice = this.getAdvice();
            AdviceType rightAdvice;
            rightAdvice = that.getAdvice();
            if (this.advice!= null) {
                if (that.advice!= null) {
                    if (!leftAdvice.equals(rightAdvice)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.advice!= null) {
                    return false;
                }
            }
        }
        {
            List<StatementAbstractType> leftStatementOrAuthnStatementOrAuthzDecisionStatement;
            leftStatementOrAuthnStatementOrAuthzDecisionStatement = (((this.statementOrAuthnStatementOrAuthzDecisionStatement!= null)&&(!this.statementOrAuthnStatementOrAuthzDecisionStatement.isEmpty()))?this.getStatementOrAuthnStatementOrAuthzDecisionStatement():null);
            List<StatementAbstractType> rightStatementOrAuthnStatementOrAuthzDecisionStatement;
            rightStatementOrAuthnStatementOrAuthzDecisionStatement = (((that.statementOrAuthnStatementOrAuthzDecisionStatement!= null)&&(!that.statementOrAuthnStatementOrAuthzDecisionStatement.isEmpty()))?that.getStatementOrAuthnStatementOrAuthzDecisionStatement():null);
            if ((this.statementOrAuthnStatementOrAuthzDecisionStatement!= null)&&(!this.statementOrAuthnStatementOrAuthzDecisionStatement.isEmpty())) {
                if ((that.statementOrAuthnStatementOrAuthzDecisionStatement!= null)&&(!that.statementOrAuthnStatementOrAuthzDecisionStatement.isEmpty())) {
                    if (!leftStatementOrAuthnStatementOrAuthzDecisionStatement.equals(rightStatementOrAuthnStatementOrAuthzDecisionStatement)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.statementOrAuthnStatementOrAuthzDecisionStatement!= null)&&(!that.statementOrAuthnStatementOrAuthzDecisionStatement.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftVersion;
            leftVersion = this.getVersion();
            String rightVersion;
            rightVersion = that.getVersion();
            if (this.version!= null) {
                if (that.version!= null) {
                    if (!leftVersion.equals(rightVersion)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.version!= null) {
                    return false;
                }
            }
        }
        {
            String leftID;
            leftID = this.getID();
            String rightID;
            rightID = that.getID();
            if (this.id!= null) {
                if (that.id!= null) {
                    if (!leftID.equals(rightID)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.id!= null) {
                    return false;
                }
            }
        }
        {
            XMLGregorianCalendar leftIssueInstant;
            leftIssueInstant = this.getIssueInstant();
            XMLGregorianCalendar rightIssueInstant;
            rightIssueInstant = that.getIssueInstant();
            if (this.issueInstant!= null) {
                if (that.issueInstant!= null) {
                    if (!leftIssueInstant.equals(rightIssueInstant)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.issueInstant!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            NameIDType theIssuer;
            theIssuer = this.getIssuer();
            if (this.issuer!= null) {
                currentHashCode += theIssuer.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            SignatureType theSignature;
            theSignature = this.getSignature();
            if (this.signature!= null) {
                currentHashCode += theSignature.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            SubjectType theSubject;
            theSubject = this.getSubject();
            if (this.subject!= null) {
                currentHashCode += theSubject.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ConditionsType theConditions;
            theConditions = this.getConditions();
            if (this.conditions!= null) {
                currentHashCode += theConditions.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            AdviceType theAdvice;
            theAdvice = this.getAdvice();
            if (this.advice!= null) {
                currentHashCode += theAdvice.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<StatementAbstractType> theStatementOrAuthnStatementOrAuthzDecisionStatement;
            theStatementOrAuthnStatementOrAuthzDecisionStatement = (((this.statementOrAuthnStatementOrAuthzDecisionStatement!= null)&&(!this.statementOrAuthnStatementOrAuthzDecisionStatement.isEmpty()))?this.getStatementOrAuthnStatementOrAuthzDecisionStatement():null);
            if ((this.statementOrAuthnStatementOrAuthzDecisionStatement!= null)&&(!this.statementOrAuthnStatementOrAuthzDecisionStatement.isEmpty())) {
                currentHashCode += theStatementOrAuthnStatementOrAuthzDecisionStatement.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theVersion;
            theVersion = this.getVersion();
            if (this.version!= null) {
                currentHashCode += theVersion.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theID;
            theID = this.getID();
            if (this.id!= null) {
                currentHashCode += theID.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            XMLGregorianCalendar theIssueInstant;
            theIssueInstant = this.getIssueInstant();
            if (this.issueInstant!= null) {
                currentHashCode += theIssueInstant.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
