
package oasis.names.tc.saml._1_0.assertion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;


/**
 * <p>Java class for AuthenticationStatementType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="AuthenticationStatementType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:oasis:names:tc:SAML:1.0:assertion}SubjectStatementAbstractType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{urn:oasis:names:tc:SAML:1.0:assertion}SubjectLocality" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:tc:SAML:1.0:assertion}AuthorityBinding" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="AuthenticationMethod" use="required" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&gt;
 *       &lt;attribute name="AuthenticationInstant" use="required" type="{http://www.w3.org/2001/XMLSchema}dateTime" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AuthenticationStatementType", propOrder = {
    "subjectLocality",
    "authorityBinding"
})
public class AuthenticationStatementType
    extends SubjectStatementAbstractType
{

    @XmlElement(name = "SubjectLocality")
    protected SubjectLocalityType subjectLocality;
    @XmlElement(name = "AuthorityBinding")
    protected List<AuthorityBindingType> authorityBinding;
    @XmlAttribute(name = "AuthenticationMethod", required = true)
    @XmlSchemaType(name = "anyURI")
    protected String authenticationMethod;
    @XmlAttribute(name = "AuthenticationInstant", required = true)
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar authenticationInstant;

    /**
     * Gets the value of the subjectLocality property.
     * 
     * @return
     *     possible object is
     *     {@link SubjectLocalityType }
     *     
     */
    public SubjectLocalityType getSubjectLocality() {
        return subjectLocality;
    }

    /**
     * Sets the value of the subjectLocality property.
     * 
     * @param value
     *     allowed object is
     *     {@link SubjectLocalityType }
     *     
     */
    public void setSubjectLocality(SubjectLocalityType value) {
        this.subjectLocality = value;
    }

    /**
     * Gets the value of the authorityBinding property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the authorityBinding property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAuthorityBinding().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AuthorityBindingType }
     * 
     * 
     */
    public List<AuthorityBindingType> getAuthorityBinding() {
        if (authorityBinding == null) {
            authorityBinding = new ArrayList<AuthorityBindingType>();
        }
        return this.authorityBinding;
    }

    /**
     * Gets the value of the authenticationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAuthenticationMethod() {
        return authenticationMethod;
    }

    /**
     * Sets the value of the authenticationMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAuthenticationMethod(String value) {
        this.authenticationMethod = value;
    }

    /**
     * Gets the value of the authenticationInstant property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getAuthenticationInstant() {
        return authenticationInstant;
    }

    /**
     * Sets the value of the authenticationInstant property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setAuthenticationInstant(XMLGregorianCalendar value) {
        this.authenticationInstant = value;
    }

    public AuthenticationStatementType withSubjectLocality(SubjectLocalityType value) {
        setSubjectLocality(value);
        return this;
    }

    public AuthenticationStatementType withAuthorityBinding(AuthorityBindingType... values) {
        if (values!= null) {
            for (AuthorityBindingType value: values) {
                getAuthorityBinding().add(value);
            }
        }
        return this;
    }

    public AuthenticationStatementType withAuthorityBinding(Collection<AuthorityBindingType> values) {
        if (values!= null) {
            getAuthorityBinding().addAll(values);
        }
        return this;
    }

    public AuthenticationStatementType withAuthenticationMethod(String value) {
        setAuthenticationMethod(value);
        return this;
    }

    public AuthenticationStatementType withAuthenticationInstant(XMLGregorianCalendar value) {
        setAuthenticationInstant(value);
        return this;
    }

    @Override
    public AuthenticationStatementType withSubject(SubjectType value) {
        setSubject(value);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final AuthenticationStatementType that = ((AuthenticationStatementType) object);
        {
            SubjectLocalityType leftSubjectLocality;
            leftSubjectLocality = this.getSubjectLocality();
            SubjectLocalityType rightSubjectLocality;
            rightSubjectLocality = that.getSubjectLocality();
            if (this.subjectLocality!= null) {
                if (that.subjectLocality!= null) {
                    if (!leftSubjectLocality.equals(rightSubjectLocality)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.subjectLocality!= null) {
                    return false;
                }
            }
        }
        {
            List<AuthorityBindingType> leftAuthorityBinding;
            leftAuthorityBinding = (((this.authorityBinding!= null)&&(!this.authorityBinding.isEmpty()))?this.getAuthorityBinding():null);
            List<AuthorityBindingType> rightAuthorityBinding;
            rightAuthorityBinding = (((that.authorityBinding!= null)&&(!that.authorityBinding.isEmpty()))?that.getAuthorityBinding():null);
            if ((this.authorityBinding!= null)&&(!this.authorityBinding.isEmpty())) {
                if ((that.authorityBinding!= null)&&(!that.authorityBinding.isEmpty())) {
                    if (!leftAuthorityBinding.equals(rightAuthorityBinding)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.authorityBinding!= null)&&(!that.authorityBinding.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftAuthenticationMethod;
            leftAuthenticationMethod = this.getAuthenticationMethod();
            String rightAuthenticationMethod;
            rightAuthenticationMethod = that.getAuthenticationMethod();
            if (this.authenticationMethod!= null) {
                if (that.authenticationMethod!= null) {
                    if (!leftAuthenticationMethod.equals(rightAuthenticationMethod)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.authenticationMethod!= null) {
                    return false;
                }
            }
        }
        {
            XMLGregorianCalendar leftAuthenticationInstant;
            leftAuthenticationInstant = this.getAuthenticationInstant();
            XMLGregorianCalendar rightAuthenticationInstant;
            rightAuthenticationInstant = that.getAuthenticationInstant();
            if (this.authenticationInstant!= null) {
                if (that.authenticationInstant!= null) {
                    if (!leftAuthenticationInstant.equals(rightAuthenticationInstant)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.authenticationInstant!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            SubjectLocalityType theSubjectLocality;
            theSubjectLocality = this.getSubjectLocality();
            if (this.subjectLocality!= null) {
                currentHashCode += theSubjectLocality.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<AuthorityBindingType> theAuthorityBinding;
            theAuthorityBinding = (((this.authorityBinding!= null)&&(!this.authorityBinding.isEmpty()))?this.getAuthorityBinding():null);
            if ((this.authorityBinding!= null)&&(!this.authorityBinding.isEmpty())) {
                currentHashCode += theAuthorityBinding.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theAuthenticationMethod;
            theAuthenticationMethod = this.getAuthenticationMethod();
            if (this.authenticationMethod!= null) {
                currentHashCode += theAuthenticationMethod.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            XMLGregorianCalendar theAuthenticationInstant;
            theAuthenticationInstant = this.getAuthenticationInstant();
            if (this.authenticationInstant!= null) {
                currentHashCode += theAuthenticationInstant.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
