
package oasis.names.tc.saml._1_0.assertion;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;
import org.w3._2000._09.xmldsig_.SignatureType;


/**
 * <p>Java class for AssertionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="AssertionType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{urn:oasis:names:tc:SAML:1.0:assertion}Conditions" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:tc:SAML:1.0:assertion}Advice" minOccurs="0"/&gt;
 *         &lt;choice maxOccurs="unbounded"&gt;
 *           &lt;element ref="{urn:oasis:names:tc:SAML:1.0:assertion}Statement"/&gt;
 *           &lt;element ref="{urn:oasis:names:tc:SAML:1.0:assertion}SubjectStatement"/&gt;
 *           &lt;element ref="{urn:oasis:names:tc:SAML:1.0:assertion}AuthenticationStatement"/&gt;
 *           &lt;element ref="{urn:oasis:names:tc:SAML:1.0:assertion}AuthorizationDecisionStatement"/&gt;
 *           &lt;element ref="{urn:oasis:names:tc:SAML:1.0:assertion}AttributeStatement"/&gt;
 *         &lt;/choice&gt;
 *         &lt;element ref="{http://www.w3.org/2000/09/xmldsig#}Signature" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="MajorVersion" use="required" type="{http://www.w3.org/2001/XMLSchema}integer" /&gt;
 *       &lt;attribute name="MinorVersion" use="required" type="{http://www.w3.org/2001/XMLSchema}integer" /&gt;
 *       &lt;attribute name="AssertionID" use="required" type="{http://www.w3.org/2001/XMLSchema}ID" /&gt;
 *       &lt;attribute name="Issuer" use="required" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="IssueInstant" use="required" type="{http://www.w3.org/2001/XMLSchema}dateTime" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AssertionType", propOrder = {
    "conditions",
    "advice",
    "statementOrSubjectStatementOrAuthenticationStatement",
    "signature"
})
public class AssertionType {

    @XmlElement(name = "Conditions")
    protected ConditionsType conditions;
    @XmlElement(name = "Advice")
    protected AdviceType advice;
    @XmlElements({
        @XmlElement(name = "Statement"),
        @XmlElement(name = "SubjectStatement", type = SubjectStatementAbstractType.class),
        @XmlElement(name = "AuthenticationStatement", type = AuthenticationStatementType.class),
        @XmlElement(name = "AuthorizationDecisionStatement", type = AuthorizationDecisionStatementType.class),
        @XmlElement(name = "AttributeStatement", type = AttributeStatementType.class)
    })
    protected List<StatementAbstractType> statementOrSubjectStatementOrAuthenticationStatement;
    @XmlElement(name = "Signature", namespace = "http://www.w3.org/2000/09/xmldsig#")
    protected SignatureType signature;
    @XmlAttribute(name = "MajorVersion", required = true)
    protected BigInteger majorVersion;
    @XmlAttribute(name = "MinorVersion", required = true)
    protected BigInteger minorVersion;
    @XmlAttribute(name = "AssertionID", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    protected String assertionID;
    @XmlAttribute(name = "Issuer", required = true)
    protected String issuer;
    @XmlAttribute(name = "IssueInstant", required = true)
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar issueInstant;

    /**
     * Gets the value of the conditions property.
     * 
     * @return
     *     possible object is
     *     {@link ConditionsType }
     *     
     */
    public ConditionsType getConditions() {
        return conditions;
    }

    /**
     * Sets the value of the conditions property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConditionsType }
     *     
     */
    public void setConditions(ConditionsType value) {
        this.conditions = value;
    }

    /**
     * Gets the value of the advice property.
     * 
     * @return
     *     possible object is
     *     {@link AdviceType }
     *     
     */
    public AdviceType getAdvice() {
        return advice;
    }

    /**
     * Sets the value of the advice property.
     * 
     * @param value
     *     allowed object is
     *     {@link AdviceType }
     *     
     */
    public void setAdvice(AdviceType value) {
        this.advice = value;
    }

    /**
     * Gets the value of the statementOrSubjectStatementOrAuthenticationStatement property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the statementOrSubjectStatementOrAuthenticationStatement property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getStatementOrSubjectStatementOrAuthenticationStatement().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AttributeStatementType }
     * {@link AuthenticationStatementType }
     * {@link AuthorizationDecisionStatementType }
     * {@link StatementAbstractType }
     * {@link SubjectStatementAbstractType }
     * 
     * 
     */
    public List<StatementAbstractType> getStatementOrSubjectStatementOrAuthenticationStatement() {
        if (statementOrSubjectStatementOrAuthenticationStatement == null) {
            statementOrSubjectStatementOrAuthenticationStatement = new ArrayList<StatementAbstractType>();
        }
        return this.statementOrSubjectStatementOrAuthenticationStatement;
    }

    /**
     * Gets the value of the signature property.
     * 
     * @return
     *     possible object is
     *     {@link SignatureType }
     *     
     */
    public SignatureType getSignature() {
        return signature;
    }

    /**
     * Sets the value of the signature property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureType }
     *     
     */
    public void setSignature(SignatureType value) {
        this.signature = value;
    }

    /**
     * Gets the value of the majorVersion property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getMajorVersion() {
        return majorVersion;
    }

    /**
     * Sets the value of the majorVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setMajorVersion(BigInteger value) {
        this.majorVersion = value;
    }

    /**
     * Gets the value of the minorVersion property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getMinorVersion() {
        return minorVersion;
    }

    /**
     * Sets the value of the minorVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setMinorVersion(BigInteger value) {
        this.minorVersion = value;
    }

    /**
     * Gets the value of the assertionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAssertionID() {
        return assertionID;
    }

    /**
     * Sets the value of the assertionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAssertionID(String value) {
        this.assertionID = value;
    }

    /**
     * Gets the value of the issuer property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIssuer() {
        return issuer;
    }

    /**
     * Sets the value of the issuer property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIssuer(String value) {
        this.issuer = value;
    }

    /**
     * Gets the value of the issueInstant property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getIssueInstant() {
        return issueInstant;
    }

    /**
     * Sets the value of the issueInstant property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setIssueInstant(XMLGregorianCalendar value) {
        this.issueInstant = value;
    }

    public AssertionType withConditions(ConditionsType value) {
        setConditions(value);
        return this;
    }

    public AssertionType withAdvice(AdviceType value) {
        setAdvice(value);
        return this;
    }

    public AssertionType withStatementOrSubjectStatementOrAuthenticationStatement(StatementAbstractType... values) {
        if (values!= null) {
            for (StatementAbstractType value: values) {
                getStatementOrSubjectStatementOrAuthenticationStatement().add(value);
            }
        }
        return this;
    }

    public AssertionType withStatementOrSubjectStatementOrAuthenticationStatement(Collection<StatementAbstractType> values) {
        if (values!= null) {
            getStatementOrSubjectStatementOrAuthenticationStatement().addAll(values);
        }
        return this;
    }

    public AssertionType withSignature(SignatureType value) {
        setSignature(value);
        return this;
    }

    public AssertionType withMajorVersion(BigInteger value) {
        setMajorVersion(value);
        return this;
    }

    public AssertionType withMinorVersion(BigInteger value) {
        setMinorVersion(value);
        return this;
    }

    public AssertionType withAssertionID(String value) {
        setAssertionID(value);
        return this;
    }

    public AssertionType withIssuer(String value) {
        setIssuer(value);
        return this;
    }

    public AssertionType withIssueInstant(XMLGregorianCalendar value) {
        setIssueInstant(value);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final AssertionType that = ((AssertionType) object);
        {
            ConditionsType leftConditions;
            leftConditions = this.getConditions();
            ConditionsType rightConditions;
            rightConditions = that.getConditions();
            if (this.conditions!= null) {
                if (that.conditions!= null) {
                    if (!leftConditions.equals(rightConditions)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.conditions!= null) {
                    return false;
                }
            }
        }
        {
            AdviceType leftAdvice;
            leftAdvice = this.getAdvice();
            AdviceType rightAdvice;
            rightAdvice = that.getAdvice();
            if (this.advice!= null) {
                if (that.advice!= null) {
                    if (!leftAdvice.equals(rightAdvice)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.advice!= null) {
                    return false;
                }
            }
        }
        {
            List<StatementAbstractType> leftStatementOrSubjectStatementOrAuthenticationStatement;
            leftStatementOrSubjectStatementOrAuthenticationStatement = (((this.statementOrSubjectStatementOrAuthenticationStatement!= null)&&(!this.statementOrSubjectStatementOrAuthenticationStatement.isEmpty()))?this.getStatementOrSubjectStatementOrAuthenticationStatement():null);
            List<StatementAbstractType> rightStatementOrSubjectStatementOrAuthenticationStatement;
            rightStatementOrSubjectStatementOrAuthenticationStatement = (((that.statementOrSubjectStatementOrAuthenticationStatement!= null)&&(!that.statementOrSubjectStatementOrAuthenticationStatement.isEmpty()))?that.getStatementOrSubjectStatementOrAuthenticationStatement():null);
            if ((this.statementOrSubjectStatementOrAuthenticationStatement!= null)&&(!this.statementOrSubjectStatementOrAuthenticationStatement.isEmpty())) {
                if ((that.statementOrSubjectStatementOrAuthenticationStatement!= null)&&(!that.statementOrSubjectStatementOrAuthenticationStatement.isEmpty())) {
                    if (!leftStatementOrSubjectStatementOrAuthenticationStatement.equals(rightStatementOrSubjectStatementOrAuthenticationStatement)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.statementOrSubjectStatementOrAuthenticationStatement!= null)&&(!that.statementOrSubjectStatementOrAuthenticationStatement.isEmpty())) {
                    return false;
                }
            }
        }
        {
            SignatureType leftSignature;
            leftSignature = this.getSignature();
            SignatureType rightSignature;
            rightSignature = that.getSignature();
            if (this.signature!= null) {
                if (that.signature!= null) {
                    if (!leftSignature.equals(rightSignature)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.signature!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftMajorVersion;
            leftMajorVersion = this.getMajorVersion();
            BigInteger rightMajorVersion;
            rightMajorVersion = that.getMajorVersion();
            if (this.majorVersion!= null) {
                if (that.majorVersion!= null) {
                    if (!leftMajorVersion.equals(rightMajorVersion)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.majorVersion!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftMinorVersion;
            leftMinorVersion = this.getMinorVersion();
            BigInteger rightMinorVersion;
            rightMinorVersion = that.getMinorVersion();
            if (this.minorVersion!= null) {
                if (that.minorVersion!= null) {
                    if (!leftMinorVersion.equals(rightMinorVersion)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.minorVersion!= null) {
                    return false;
                }
            }
        }
        {
            String leftAssertionID;
            leftAssertionID = this.getAssertionID();
            String rightAssertionID;
            rightAssertionID = that.getAssertionID();
            if (this.assertionID!= null) {
                if (that.assertionID!= null) {
                    if (!leftAssertionID.equals(rightAssertionID)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.assertionID!= null) {
                    return false;
                }
            }
        }
        {
            String leftIssuer;
            leftIssuer = this.getIssuer();
            String rightIssuer;
            rightIssuer = that.getIssuer();
            if (this.issuer!= null) {
                if (that.issuer!= null) {
                    if (!leftIssuer.equals(rightIssuer)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.issuer!= null) {
                    return false;
                }
            }
        }
        {
            XMLGregorianCalendar leftIssueInstant;
            leftIssueInstant = this.getIssueInstant();
            XMLGregorianCalendar rightIssueInstant;
            rightIssueInstant = that.getIssueInstant();
            if (this.issueInstant!= null) {
                if (that.issueInstant!= null) {
                    if (!leftIssueInstant.equals(rightIssueInstant)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.issueInstant!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            ConditionsType theConditions;
            theConditions = this.getConditions();
            if (this.conditions!= null) {
                currentHashCode += theConditions.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            AdviceType theAdvice;
            theAdvice = this.getAdvice();
            if (this.advice!= null) {
                currentHashCode += theAdvice.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<StatementAbstractType> theStatementOrSubjectStatementOrAuthenticationStatement;
            theStatementOrSubjectStatementOrAuthenticationStatement = (((this.statementOrSubjectStatementOrAuthenticationStatement!= null)&&(!this.statementOrSubjectStatementOrAuthenticationStatement.isEmpty()))?this.getStatementOrSubjectStatementOrAuthenticationStatement():null);
            if ((this.statementOrSubjectStatementOrAuthenticationStatement!= null)&&(!this.statementOrSubjectStatementOrAuthenticationStatement.isEmpty())) {
                currentHashCode += theStatementOrSubjectStatementOrAuthenticationStatement.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            SignatureType theSignature;
            theSignature = this.getSignature();
            if (this.signature!= null) {
                currentHashCode += theSignature.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theMajorVersion;
            theMajorVersion = this.getMajorVersion();
            if (this.majorVersion!= null) {
                currentHashCode += theMajorVersion.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theMinorVersion;
            theMinorVersion = this.getMinorVersion();
            if (this.minorVersion!= null) {
                currentHashCode += theMinorVersion.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theAssertionID;
            theAssertionID = this.getAssertionID();
            if (this.assertionID!= null) {
                currentHashCode += theAssertionID.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theIssuer;
            theIssuer = this.getIssuer();
            if (this.issuer!= null) {
                currentHashCode += theIssuer.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            XMLGregorianCalendar theIssueInstant;
            theIssueInstant = this.getIssueInstant();
            if (this.issueInstant!= null) {
                currentHashCode += theIssueInstant.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
