
package telematik.ws.conn.connectorcontext.xsd.v2_0;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;


/**
 * <p>Java class for ContextType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ContextType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/ConnectorCommon/v5.0}MandantId"/&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/ConnectorCommon/v5.0}ClientSystemId"/&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/ConnectorCommon/v5.0}WorkplaceId"/&gt;
 *         &lt;element ref="{http://ws.gematik.de/conn/ConnectorCommon/v5.0}UserId" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ContextType", propOrder = {
    "mandantId",
    "clientSystemId",
    "workplaceId",
    "userId"
})
public class ContextType {

    @XmlElement(name = "MandantId", namespace = "http://ws.gematik.de/conn/ConnectorCommon/v5.0", required = true)
    protected String mandantId;
    @XmlElement(name = "ClientSystemId", namespace = "http://ws.gematik.de/conn/ConnectorCommon/v5.0", required = true)
    protected String clientSystemId;
    @XmlElement(name = "WorkplaceId", namespace = "http://ws.gematik.de/conn/ConnectorCommon/v5.0", required = true)
    protected String workplaceId;
    @XmlElement(name = "UserId", namespace = "http://ws.gematik.de/conn/ConnectorCommon/v5.0")
    protected String userId;

    /**
     * Die ID des Mandanten.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMandantId() {
        return mandantId;
    }

    /**
     * Sets the value of the mandantId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMandantId(String value) {
        this.mandantId = value;
    }

    /**
     * Die ID des Clientsystems, von dem bzw. für das der Aufruf des Konnektors erfolgt.
     * 					Unter einem Clientsystem wird hier ein einzelnes oder eine Gruppe von Systemen verstanden,
     * 					welche im LAN des Leistungserbringers auf die Clientsystem-Schnittstelle des Konnektors zugreifen.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getClientSystemId() {
        return clientSystemId;
    }

    /**
     * Sets the value of the clientSystemId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setClientSystemId(String value) {
        this.clientSystemId = value;
    }

    /**
     * Die ID des Arbeitsplatzes, von dem bzw. für den der Aufruf des Konnektors erfolgt.
     * 					Bei fachlichen Aufrufen ist sie immer erforderlich.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getWorkplaceId() {
        return workplaceId;
    }

    /**
     * Sets the value of the workplaceId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setWorkplaceId(String value) {
        this.workplaceId = value;
    }

    /**
     * Die ID des Nutzers im Primärsystem. Ist nur dann erforderlich, falls ein HBA verwendet wird.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUserId() {
        return userId;
    }

    /**
     * Sets the value of the userId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUserId(String value) {
        this.userId = value;
    }

    public ContextType withMandantId(String value) {
        setMandantId(value);
        return this;
    }

    public ContextType withClientSystemId(String value) {
        setClientSystemId(value);
        return this;
    }

    public ContextType withWorkplaceId(String value) {
        setWorkplaceId(value);
        return this;
    }

    public ContextType withUserId(String value) {
        setUserId(value);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final ContextType that = ((ContextType) object);
        {
            String leftMandantId;
            leftMandantId = this.getMandantId();
            String rightMandantId;
            rightMandantId = that.getMandantId();
            if (this.mandantId!= null) {
                if (that.mandantId!= null) {
                    if (!leftMandantId.equals(rightMandantId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.mandantId!= null) {
                    return false;
                }
            }
        }
        {
            String leftClientSystemId;
            leftClientSystemId = this.getClientSystemId();
            String rightClientSystemId;
            rightClientSystemId = that.getClientSystemId();
            if (this.clientSystemId!= null) {
                if (that.clientSystemId!= null) {
                    if (!leftClientSystemId.equals(rightClientSystemId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.clientSystemId!= null) {
                    return false;
                }
            }
        }
        {
            String leftWorkplaceId;
            leftWorkplaceId = this.getWorkplaceId();
            String rightWorkplaceId;
            rightWorkplaceId = that.getWorkplaceId();
            if (this.workplaceId!= null) {
                if (that.workplaceId!= null) {
                    if (!leftWorkplaceId.equals(rightWorkplaceId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.workplaceId!= null) {
                    return false;
                }
            }
        }
        {
            String leftUserId;
            leftUserId = this.getUserId();
            String rightUserId;
            rightUserId = that.getUserId();
            if (this.userId!= null) {
                if (that.userId!= null) {
                    if (!leftUserId.equals(rightUserId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.userId!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theMandantId;
            theMandantId = this.getMandantId();
            if (this.mandantId!= null) {
                currentHashCode += theMandantId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theClientSystemId;
            theClientSystemId = this.getClientSystemId();
            if (this.clientSystemId!= null) {
                currentHashCode += theClientSystemId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theWorkplaceId;
            theWorkplaceId = this.getWorkplaceId();
            if (this.workplaceId!= null) {
                currentHashCode += theWorkplaceId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theUserId;
            theUserId = this.getUserId();
            if (this.userId!= null) {
                currentHashCode += theUserId.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
