
package org.hl7.v3;

import java.util.Collection;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;


/**
 * 
 *             An ST that optionally may have a code attached.
 *             The text must always be present if a code is present. The
 *             code is often a local code.
 *          
 * 
 * <p>Java class for SC complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="SC"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:hl7-org:v3}ST"&gt;
 *       &lt;attribute name="code" type="{urn:hl7-org:v3}cs" /&gt;
 *       &lt;attribute name="codeSystem" type="{urn:hl7-org:v3}uid" /&gt;
 *       &lt;attribute name="codeSystemName" type="{urn:hl7-org:v3}st" /&gt;
 *       &lt;attribute name="codeSystemVersion" type="{urn:hl7-org:v3}st" /&gt;
 *       &lt;attribute name="displayName" type="{urn:hl7-org:v3}st" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SC")
public class SC
    extends ST
{

    @XmlAttribute(name = "code")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String code;
    @XmlAttribute(name = "codeSystem")
    protected String codeSystem;
    @XmlAttribute(name = "codeSystemName")
    protected String codeSystemName;
    @XmlAttribute(name = "codeSystemVersion")
    protected String codeSystemVersion;
    @XmlAttribute(name = "displayName")
    protected String displayName;

    /**
     * Gets the value of the code property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCode() {
        return code;
    }

    /**
     * Sets the value of the code property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCode(String value) {
        this.code = value;
    }

    /**
     * Gets the value of the codeSystem property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCodeSystem() {
        return codeSystem;
    }

    /**
     * Sets the value of the codeSystem property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCodeSystem(String value) {
        this.codeSystem = value;
    }

    /**
     * Gets the value of the codeSystemName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCodeSystemName() {
        return codeSystemName;
    }

    /**
     * Sets the value of the codeSystemName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCodeSystemName(String value) {
        this.codeSystemName = value;
    }

    /**
     * Gets the value of the codeSystemVersion property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCodeSystemVersion() {
        return codeSystemVersion;
    }

    /**
     * Sets the value of the codeSystemVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCodeSystemVersion(String value) {
        this.codeSystemVersion = value;
    }

    /**
     * Gets the value of the displayName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * Sets the value of the displayName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDisplayName(String value) {
        this.displayName = value;
    }

    public SC withCode(String value) {
        setCode(value);
        return this;
    }

    public SC withCodeSystem(String value) {
        setCodeSystem(value);
        return this;
    }

    public SC withCodeSystemName(String value) {
        setCodeSystemName(value);
        return this;
    }

    public SC withCodeSystemVersion(String value) {
        setCodeSystemVersion(value);
        return this;
    }

    public SC withDisplayName(String value) {
        setDisplayName(value);
        return this;
    }

    @Override
    public SC withReference(TEL value) {
        setReference(value);
        return this;
    }

    @Override
    public SC withThumbnail(Thumbnail value) {
        setThumbnail(value);
        return this;
    }

    @Override
    public SC withMediaType(String value) {
        setMediaType(value);
        return this;
    }

    @Override
    public SC withLanguage(String value) {
        setLanguage(value);
        return this;
    }

    @Override
    public SC withCompression(CompressionAlgorithm value) {
        setCompression(value);
        return this;
    }

    @Override
    public SC withIntegrityCheck(byte[] value) {
        setIntegrityCheck(value);
        return this;
    }

    @Override
    public SC withIntegrityCheckAlgorithm(IntegrityCheckAlgorithm value) {
        setIntegrityCheckAlgorithm(value);
        return this;
    }

    @Override
    public SC withRepresentation(BinaryDataEncoding value) {
        setRepresentation(value);
        return this;
    }

    @Override
    public SC withNullFlavor(String... values) {
        if (values!= null) {
            for (String value: values) {
                getNullFlavor().add(value);
            }
        }
        return this;
    }

    @Override
    public SC withNullFlavor(Collection<String> values) {
        if (values!= null) {
            getNullFlavor().addAll(values);
        }
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final SC that = ((SC) object);
        {
            String leftCode;
            leftCode = this.getCode();
            String rightCode;
            rightCode = that.getCode();
            if (this.code!= null) {
                if (that.code!= null) {
                    if (!leftCode.equals(rightCode)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.code!= null) {
                    return false;
                }
            }
        }
        {
            String leftCodeSystem;
            leftCodeSystem = this.getCodeSystem();
            String rightCodeSystem;
            rightCodeSystem = that.getCodeSystem();
            if (this.codeSystem!= null) {
                if (that.codeSystem!= null) {
                    if (!leftCodeSystem.equals(rightCodeSystem)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.codeSystem!= null) {
                    return false;
                }
            }
        }
        {
            String leftCodeSystemName;
            leftCodeSystemName = this.getCodeSystemName();
            String rightCodeSystemName;
            rightCodeSystemName = that.getCodeSystemName();
            if (this.codeSystemName!= null) {
                if (that.codeSystemName!= null) {
                    if (!leftCodeSystemName.equals(rightCodeSystemName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.codeSystemName!= null) {
                    return false;
                }
            }
        }
        {
            String leftCodeSystemVersion;
            leftCodeSystemVersion = this.getCodeSystemVersion();
            String rightCodeSystemVersion;
            rightCodeSystemVersion = that.getCodeSystemVersion();
            if (this.codeSystemVersion!= null) {
                if (that.codeSystemVersion!= null) {
                    if (!leftCodeSystemVersion.equals(rightCodeSystemVersion)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.codeSystemVersion!= null) {
                    return false;
                }
            }
        }
        {
            String leftDisplayName;
            leftDisplayName = this.getDisplayName();
            String rightDisplayName;
            rightDisplayName = that.getDisplayName();
            if (this.displayName!= null) {
                if (that.displayName!= null) {
                    if (!leftDisplayName.equals(rightDisplayName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.displayName!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            String theCode;
            theCode = this.getCode();
            if (this.code!= null) {
                currentHashCode += theCode.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theCodeSystem;
            theCodeSystem = this.getCodeSystem();
            if (this.codeSystem!= null) {
                currentHashCode += theCodeSystem.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theCodeSystemName;
            theCodeSystemName = this.getCodeSystemName();
            if (this.codeSystemName!= null) {
                currentHashCode += theCodeSystemName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theCodeSystemVersion;
            theCodeSystemVersion = this.getCodeSystemVersion();
            if (this.codeSystemVersion!= null) {
                currentHashCode += theCodeSystemVersion.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDisplayName;
            theDisplayName = this.getDisplayName();
            if (this.displayName!= null) {
                currentHashCode += theDisplayName.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
