
package org.hl7.v3;

import java.util.Arrays;
import java.util.Collection;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;


/**
 * 
 *             Data that is primarily intended for human interpretation
 *             or for further machine processing is outside the scope of
 *             HL7. This includes unformatted or formatted written language,
 *             multimedia data, or structured information as defined by a
 *             different standard (e.g., XML-signatures.)  Instead of the
 *             data itself, an ED may contain 
 *             only a reference (see TEL.) Note
 *             that the ST data type is a
 *             specialization of 
 *             when the  is text/plain.
 *          
 * 
 * <p>Java class for ED complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ED"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:hl7-org:v3}BIN"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="reference" type="{urn:hl7-org:v3}TEL" minOccurs="0"/&gt;
 *         &lt;element name="thumbnail" type="{urn:hl7-org:v3}thumbnail" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="mediaType" type="{urn:hl7-org:v3}cs" default="text/plain" /&gt;
 *       &lt;attribute name="language" type="{urn:hl7-org:v3}cs" /&gt;
 *       &lt;attribute name="compression" type="{urn:hl7-org:v3}CompressionAlgorithm" /&gt;
 *       &lt;attribute name="integrityCheck" type="{urn:hl7-org:v3}bin" /&gt;
 *       &lt;attribute name="integrityCheckAlgorithm" type="{urn:hl7-org:v3}IntegrityCheckAlgorithm" default="SHA-1" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ED", propOrder = {
    "reference",
    "thumbnail"
})
@XmlSeeAlso({
    Thumbnail.class,
    ST.class
})
public class ED
    extends BIN
{

    protected TEL reference;
    protected Thumbnail thumbnail;
    @XmlAttribute(name = "mediaType")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String mediaType;
    @XmlAttribute(name = "language")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String language;
    @XmlAttribute(name = "compression")
    protected CompressionAlgorithm compression;
    @XmlAttribute(name = "integrityCheck")
    protected byte[] integrityCheck;
    @XmlAttribute(name = "integrityCheckAlgorithm")
    protected IntegrityCheckAlgorithm integrityCheckAlgorithm;

    /**
     * Gets the value of the reference property.
     * 
     * @return
     *     possible object is
     *     {@link TEL }
     *     
     */
    public TEL getReference() {
        return reference;
    }

    /**
     * Sets the value of the reference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TEL }
     *     
     */
    public void setReference(TEL value) {
        this.reference = value;
    }

    /**
     * Gets the value of the thumbnail property.
     * 
     * @return
     *     possible object is
     *     {@link Thumbnail }
     *     
     */
    public Thumbnail getThumbnail() {
        return thumbnail;
    }

    /**
     * Sets the value of the thumbnail property.
     * 
     * @param value
     *     allowed object is
     *     {@link Thumbnail }
     *     
     */
    public void setThumbnail(Thumbnail value) {
        this.thumbnail = value;
    }

    /**
     * Gets the value of the mediaType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMediaType() {
        if (mediaType == null) {
            return "text/plain";
        } else {
            return mediaType;
        }
    }

    /**
     * Sets the value of the mediaType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMediaType(String value) {
        this.mediaType = value;
    }

    /**
     * Gets the value of the language property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLanguage() {
        return language;
    }

    /**
     * Sets the value of the language property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLanguage(String value) {
        this.language = value;
    }

    /**
     * Gets the value of the compression property.
     * 
     * @return
     *     possible object is
     *     {@link CompressionAlgorithm }
     *     
     */
    public CompressionAlgorithm getCompression() {
        return compression;
    }

    /**
     * Sets the value of the compression property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompressionAlgorithm }
     *     
     */
    public void setCompression(CompressionAlgorithm value) {
        this.compression = value;
    }

    /**
     * Gets the value of the integrityCheck property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getIntegrityCheck() {
        return integrityCheck;
    }

    /**
     * Sets the value of the integrityCheck property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setIntegrityCheck(byte[] value) {
        this.integrityCheck = value;
    }

    /**
     * Gets the value of the integrityCheckAlgorithm property.
     * 
     * @return
     *     possible object is
     *     {@link IntegrityCheckAlgorithm }
     *     
     */
    public IntegrityCheckAlgorithm getIntegrityCheckAlgorithm() {
        if (integrityCheckAlgorithm == null) {
            return IntegrityCheckAlgorithm.SHA_1;
        } else {
            return integrityCheckAlgorithm;
        }
    }

    /**
     * Sets the value of the integrityCheckAlgorithm property.
     * 
     * @param value
     *     allowed object is
     *     {@link IntegrityCheckAlgorithm }
     *     
     */
    public void setIntegrityCheckAlgorithm(IntegrityCheckAlgorithm value) {
        this.integrityCheckAlgorithm = value;
    }

    public ED withReference(TEL value) {
        setReference(value);
        return this;
    }

    public ED withThumbnail(Thumbnail value) {
        setThumbnail(value);
        return this;
    }

    public ED withMediaType(String value) {
        setMediaType(value);
        return this;
    }

    public ED withLanguage(String value) {
        setLanguage(value);
        return this;
    }

    public ED withCompression(CompressionAlgorithm value) {
        setCompression(value);
        return this;
    }

    public ED withIntegrityCheck(byte[] value) {
        setIntegrityCheck(value);
        return this;
    }

    public ED withIntegrityCheckAlgorithm(IntegrityCheckAlgorithm value) {
        setIntegrityCheckAlgorithm(value);
        return this;
    }

    @Override
    public ED withRepresentation(BinaryDataEncoding value) {
        setRepresentation(value);
        return this;
    }

    @Override
    public ED withNullFlavor(String... values) {
        if (values!= null) {
            for (String value: values) {
                getNullFlavor().add(value);
            }
        }
        return this;
    }

    @Override
    public ED withNullFlavor(Collection<String> values) {
        if (values!= null) {
            getNullFlavor().addAll(values);
        }
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final ED that = ((ED) object);
        {
            TEL leftReference;
            leftReference = this.getReference();
            TEL rightReference;
            rightReference = that.getReference();
            if (this.reference!= null) {
                if (that.reference!= null) {
                    if (!leftReference.equals(rightReference)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.reference!= null) {
                    return false;
                }
            }
        }
        {
            Thumbnail leftThumbnail;
            leftThumbnail = this.getThumbnail();
            Thumbnail rightThumbnail;
            rightThumbnail = that.getThumbnail();
            if (this.thumbnail!= null) {
                if (that.thumbnail!= null) {
                    if (!leftThumbnail.equals(rightThumbnail)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.thumbnail!= null) {
                    return false;
                }
            }
        }
        {
            String leftMediaType;
            leftMediaType = this.getMediaType();
            String rightMediaType;
            rightMediaType = that.getMediaType();
            if (this.mediaType!= null) {
                if (that.mediaType!= null) {
                    if (!leftMediaType.equals(rightMediaType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.mediaType!= null) {
                    return false;
                }
            }
        }
        {
            String leftLanguage;
            leftLanguage = this.getLanguage();
            String rightLanguage;
            rightLanguage = that.getLanguage();
            if (this.language!= null) {
                if (that.language!= null) {
                    if (!leftLanguage.equals(rightLanguage)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.language!= null) {
                    return false;
                }
            }
        }
        {
            CompressionAlgorithm leftCompression;
            leftCompression = this.getCompression();
            CompressionAlgorithm rightCompression;
            rightCompression = that.getCompression();
            if (this.compression!= null) {
                if (that.compression!= null) {
                    if (!leftCompression.equals(rightCompression)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.compression!= null) {
                    return false;
                }
            }
        }
        {
            byte[] leftIntegrityCheck;
            leftIntegrityCheck = this.getIntegrityCheck();
            byte[] rightIntegrityCheck;
            rightIntegrityCheck = that.getIntegrityCheck();
            if (this.integrityCheck!= null) {
                if (that.integrityCheck!= null) {
                    if (!Arrays.equals(leftIntegrityCheck, rightIntegrityCheck)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.integrityCheck!= null) {
                    return false;
                }
            }
        }
        {
            IntegrityCheckAlgorithm leftIntegrityCheckAlgorithm;
            leftIntegrityCheckAlgorithm = this.getIntegrityCheckAlgorithm();
            IntegrityCheckAlgorithm rightIntegrityCheckAlgorithm;
            rightIntegrityCheckAlgorithm = that.getIntegrityCheckAlgorithm();
            if (this.integrityCheckAlgorithm!= null) {
                if (that.integrityCheckAlgorithm!= null) {
                    if (!leftIntegrityCheckAlgorithm.equals(rightIntegrityCheckAlgorithm)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.integrityCheckAlgorithm!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            TEL theReference;
            theReference = this.getReference();
            if (this.reference!= null) {
                currentHashCode += theReference.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Thumbnail theThumbnail;
            theThumbnail = this.getThumbnail();
            if (this.thumbnail!= null) {
                currentHashCode += theThumbnail.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theMediaType;
            theMediaType = this.getMediaType();
            if (this.mediaType!= null) {
                currentHashCode += theMediaType.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theLanguage;
            theLanguage = this.getLanguage();
            if (this.language!= null) {
                currentHashCode += theLanguage.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            CompressionAlgorithm theCompression;
            theCompression = this.getCompression();
            if (this.compression!= null) {
                currentHashCode += theCompression.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            byte[] theIntegrityCheck;
            theIntegrityCheck = this.getIntegrityCheck();
            currentHashCode += Arrays.hashCode(theIntegrityCheck);
        }
        {
            currentHashCode = (currentHashCode* 31);
            IntegrityCheckAlgorithm theIntegrityCheckAlgorithm;
            theIntegrityCheckAlgorithm = this.getIntegrityCheckAlgorithm();
            if (this.integrityCheckAlgorithm!= null) {
                currentHashCode += theIntegrityCheckAlgorithm.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
