
package org.hl7.v3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;


/**
 * 
 *             A character string that may have a type-tag signifying its
 *             role in the address. Typical parts that exist in about
 *             every address are street, house number, or post box,
 *             postal code, city, country but other roles may be defined
 *             regionally, nationally, or on an enterprise level (e.g. in
 *             military addresses). Addresses are usually broken up into
 *             lines, which are indicated by special line-breaking
 *             delimiter elements (e.g., DEL).
 *          
 * 
 * <p>Java class for ADXP complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ADXP"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:hl7-org:v3}ST"&gt;
 *       &lt;attribute name="partType" type="{urn:hl7-org:v3}AddressPartType" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ADXP")
@XmlSeeAlso({
    AdxpDelimiter.class,
    AdxpCountry.class,
    AdxpState.class,
    AdxpCounty.class,
    AdxpCity.class,
    AdxpPostalCode.class,
    AdxpStreetAddressLine.class,
    AdxpHouseNumber.class,
    AdxpHouseNumberNumeric.class,
    AdxpDirection.class,
    AdxpStreetName.class,
    AdxpStreetNameBase.class,
    AdxpStreetNameType.class,
    AdxpAdditionalLocator.class,
    AdxpUnitID.class,
    AdxpUnitType.class,
    AdxpCareOf.class,
    AdxpCensusTract.class,
    AdxpDeliveryAddressLine.class,
    AdxpDeliveryInstallationType.class,
    AdxpDeliveryInstallationArea.class,
    AdxpDeliveryInstallationQualifier.class,
    AdxpDeliveryMode.class,
    AdxpDeliveryModeIdentifier.class,
    AdxpBuildingNumberSuffix.class,
    AdxpPostBox.class,
    AdxpPrecinct.class
})
public class ADXP
    extends ST
{

    @XmlAttribute(name = "partType")
    protected List<String> partType;

    /**
     * Gets the value of the partType property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the partType property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPartType().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    public List<String> getPartType() {
        if (partType == null) {
            partType = new ArrayList<String>();
        }
        return this.partType;
    }

    public ADXP withPartType(String... values) {
        if (values!= null) {
            for (String value: values) {
                getPartType().add(value);
            }
        }
        return this;
    }

    public ADXP withPartType(Collection<String> values) {
        if (values!= null) {
            getPartType().addAll(values);
        }
        return this;
    }

    @Override
    public ADXP withReference(TEL value) {
        setReference(value);
        return this;
    }

    @Override
    public ADXP withThumbnail(Thumbnail value) {
        setThumbnail(value);
        return this;
    }

    @Override
    public ADXP withMediaType(String value) {
        setMediaType(value);
        return this;
    }

    @Override
    public ADXP withLanguage(String value) {
        setLanguage(value);
        return this;
    }

    @Override
    public ADXP withCompression(CompressionAlgorithm value) {
        setCompression(value);
        return this;
    }

    @Override
    public ADXP withIntegrityCheck(byte[] value) {
        setIntegrityCheck(value);
        return this;
    }

    @Override
    public ADXP withIntegrityCheckAlgorithm(IntegrityCheckAlgorithm value) {
        setIntegrityCheckAlgorithm(value);
        return this;
    }

    @Override
    public ADXP withRepresentation(BinaryDataEncoding value) {
        setRepresentation(value);
        return this;
    }

    @Override
    public ADXP withNullFlavor(String... values) {
        if (values!= null) {
            for (String value: values) {
                getNullFlavor().add(value);
            }
        }
        return this;
    }

    @Override
    public ADXP withNullFlavor(Collection<String> values) {
        if (values!= null) {
            getNullFlavor().addAll(values);
        }
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final ADXP that = ((ADXP) object);
        {
            List<String> leftPartType;
            leftPartType = (((this.partType!= null)&&(!this.partType.isEmpty()))?this.getPartType():null);
            List<String> rightPartType;
            rightPartType = (((that.partType!= null)&&(!that.partType.isEmpty()))?that.getPartType():null);
            if ((this.partType!= null)&&(!this.partType.isEmpty())) {
                if ((that.partType!= null)&&(!that.partType.isEmpty())) {
                    if (!leftPartType.equals(rightPartType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.partType!= null)&&(!that.partType.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<String> thePartType;
            thePartType = (((this.partType!= null)&&(!this.partType.isEmpty()))?this.getPartType():null);
            if ((this.partType!= null)&&(!this.partType.isEmpty())) {
                currentHashCode += thePartType.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
