
package oasis.names.tc.saml._2_0.assertion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlMixed;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;
import org.w3c.dom.Element;


/**
 * <p>Java class for SubjectConfirmationDataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="SubjectConfirmationDataType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;any processContents='lax' maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="NotBefore" type="{http://www.w3.org/2001/XMLSchema}dateTime" /&gt;
 *       &lt;attribute name="NotOnOrAfter" type="{http://www.w3.org/2001/XMLSchema}dateTime" /&gt;
 *       &lt;attribute name="Recipient" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&gt;
 *       &lt;attribute name="InResponseTo" type="{http://www.w3.org/2001/XMLSchema}NCName" /&gt;
 *       &lt;attribute name="Address" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;anyAttribute processContents='lax' namespace='##other'/&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SubjectConfirmationDataType", propOrder = {
    "content"
})
@XmlSeeAlso({
    KeyInfoConfirmationDataType.class
})
public class SubjectConfirmationDataType {

    @XmlMixed
    @XmlAnyElement(lax = true)
    protected List<Object> content;
    @XmlAttribute(name = "NotBefore")
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar notBefore;
    @XmlAttribute(name = "NotOnOrAfter")
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar notOnOrAfter;
    @XmlAttribute(name = "Recipient")
    @XmlSchemaType(name = "anyURI")
    protected String recipient;
    @XmlAttribute(name = "InResponseTo")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "NCName")
    protected String inResponseTo;
    @XmlAttribute(name = "Address")
    protected String address;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    /**
     * Gets the value of the content property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the content property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * {@link String }
     * {@link Element }
     * 
     * 
     */
    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<Object>();
        }
        return this.content;
    }

    /**
     * Gets the value of the notBefore property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getNotBefore() {
        return notBefore;
    }

    /**
     * Sets the value of the notBefore property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setNotBefore(XMLGregorianCalendar value) {
        this.notBefore = value;
    }

    /**
     * Gets the value of the notOnOrAfter property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getNotOnOrAfter() {
        return notOnOrAfter;
    }

    /**
     * Sets the value of the notOnOrAfter property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setNotOnOrAfter(XMLGregorianCalendar value) {
        this.notOnOrAfter = value;
    }

    /**
     * Gets the value of the recipient property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRecipient() {
        return recipient;
    }

    /**
     * Sets the value of the recipient property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRecipient(String value) {
        this.recipient = value;
    }

    /**
     * Gets the value of the inResponseTo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInResponseTo() {
        return inResponseTo;
    }

    /**
     * Sets the value of the inResponseTo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setInResponseTo(String value) {
        this.inResponseTo = value;
    }

    /**
     * Gets the value of the address property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAddress() {
        return address;
    }

    /**
     * Sets the value of the address property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAddress(String value) {
        this.address = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    public SubjectConfirmationDataType withContent(Object... values) {
        if (values!= null) {
            for (Object value: values) {
                getContent().add(value);
            }
        }
        return this;
    }

    public SubjectConfirmationDataType withContent(Collection<Object> values) {
        if (values!= null) {
            getContent().addAll(values);
        }
        return this;
    }

    public SubjectConfirmationDataType withNotBefore(XMLGregorianCalendar value) {
        setNotBefore(value);
        return this;
    }

    public SubjectConfirmationDataType withNotOnOrAfter(XMLGregorianCalendar value) {
        setNotOnOrAfter(value);
        return this;
    }

    public SubjectConfirmationDataType withRecipient(String value) {
        setRecipient(value);
        return this;
    }

    public SubjectConfirmationDataType withInResponseTo(String value) {
        setInResponseTo(value);
        return this;
    }

    public SubjectConfirmationDataType withAddress(String value) {
        setAddress(value);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final SubjectConfirmationDataType that = ((SubjectConfirmationDataType) object);
        {
            List<Object> leftContent;
            leftContent = (((this.content!= null)&&(!this.content.isEmpty()))?this.getContent():null);
            List<Object> rightContent;
            rightContent = (((that.content!= null)&&(!that.content.isEmpty()))?that.getContent():null);
            if ((this.content!= null)&&(!this.content.isEmpty())) {
                if ((that.content!= null)&&(!that.content.isEmpty())) {
                    if (!leftContent.equals(rightContent)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.content!= null)&&(!that.content.isEmpty())) {
                    return false;
                }
            }
        }
        {
            XMLGregorianCalendar leftNotBefore;
            leftNotBefore = this.getNotBefore();
            XMLGregorianCalendar rightNotBefore;
            rightNotBefore = that.getNotBefore();
            if (this.notBefore!= null) {
                if (that.notBefore!= null) {
                    if (!leftNotBefore.equals(rightNotBefore)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.notBefore!= null) {
                    return false;
                }
            }
        }
        {
            XMLGregorianCalendar leftNotOnOrAfter;
            leftNotOnOrAfter = this.getNotOnOrAfter();
            XMLGregorianCalendar rightNotOnOrAfter;
            rightNotOnOrAfter = that.getNotOnOrAfter();
            if (this.notOnOrAfter!= null) {
                if (that.notOnOrAfter!= null) {
                    if (!leftNotOnOrAfter.equals(rightNotOnOrAfter)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.notOnOrAfter!= null) {
                    return false;
                }
            }
        }
        {
            String leftRecipient;
            leftRecipient = this.getRecipient();
            String rightRecipient;
            rightRecipient = that.getRecipient();
            if (this.recipient!= null) {
                if (that.recipient!= null) {
                    if (!leftRecipient.equals(rightRecipient)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.recipient!= null) {
                    return false;
                }
            }
        }
        {
            String leftInResponseTo;
            leftInResponseTo = this.getInResponseTo();
            String rightInResponseTo;
            rightInResponseTo = that.getInResponseTo();
            if (this.inResponseTo!= null) {
                if (that.inResponseTo!= null) {
                    if (!leftInResponseTo.equals(rightInResponseTo)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.inResponseTo!= null) {
                    return false;
                }
            }
        }
        {
            String leftAddress;
            leftAddress = this.getAddress();
            String rightAddress;
            rightAddress = that.getAddress();
            if (this.address!= null) {
                if (that.address!= null) {
                    if (!leftAddress.equals(rightAddress)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.address!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            List<Object> theContent;
            theContent = (((this.content!= null)&&(!this.content.isEmpty()))?this.getContent():null);
            if ((this.content!= null)&&(!this.content.isEmpty())) {
                currentHashCode += theContent.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            XMLGregorianCalendar theNotBefore;
            theNotBefore = this.getNotBefore();
            if (this.notBefore!= null) {
                currentHashCode += theNotBefore.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            XMLGregorianCalendar theNotOnOrAfter;
            theNotOnOrAfter = this.getNotOnOrAfter();
            if (this.notOnOrAfter!= null) {
                currentHashCode += theNotOnOrAfter.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theRecipient;
            theRecipient = this.getRecipient();
            if (this.recipient!= null) {
                currentHashCode += theRecipient.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theInResponseTo;
            theInResponseTo = this.getInResponseTo();
            if (this.inResponseTo!= null) {
                currentHashCode += theInResponseTo.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theAddress;
            theAddress = this.getAddress();
            if (this.address!= null) {
                currentHashCode += theAddress.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
